/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public abstract class Component
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(Component.class);
    private volatile boolean initialized = false;
    private final String name;

    protected Component(String name) {
        this.name = name;
    }

    @ManagedAttribute(currencyTimeLimit=-1, description="The component's class name")
    public String getType() {
        return this.getClass().getName();
    }

    @ManagedAttribute(currencyTimeLimit=-1, description="The component's name")
    public String getName() {
        return this.name;
    }

    public final void afterPropertiesSet() throws Exception {
        LOG.info("Initializing component {}", (Object)this.name);
        try {
            this.init();
            LOG.info("Component {} initialized", (Object)this.name);
        }
        catch (Exception e) {
            LOG.error("Exception while initializing " + this.name, (Throwable)e);
            throw e;
        }
    }

    public final void destroy() throws Exception {
        LOG.info("Destroying component {}", (Object)this.name);
        try {
            this.shutdown();
            LOG.info("Component {} destroyed", (Object)this.name);
        }
        catch (Exception e) {
            LOG.warn("Exception while destroying " + this.name, (Throwable)e);
            throw e;
        }
    }

    @ManagedAttribute(currencyTimeLimit=0, description="Whether or not this component has been fully initialized")
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void assertDuringInitialization() {
        if (this.initialized) {
            throw new IllegalStateException("Method must only be called during bean initialization");
        }
    }

    protected void assertInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Method must only be called after bean initialization");
        }
    }

    protected void init() throws Exception {
        this.assertDuringInitialization();
    }

    protected void postInit() throws Exception {
        this.assertDuringInitialization();
        this.initialized = true;
    }

    protected void shutdown() {
    }

    public String toString() {
        return this.name + '(' + this.getClass().getName() + ')';
    }
}

