/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.spring;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class MBeanNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    private JmxAttributeSource attributeSource;
    private String defaultDomain;

    public MBeanNamingStrategy() {
    }

    public MBeanNamingStrategy(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, (String)"JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, (String)"JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public MBeanNamingStrategy setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
        return this;
    }

    public void afterPropertiesSet() {
        if (this.attributeSource == null) {
            throw new IllegalArgumentException("Property 'attributeSource' is required");
        }
    }

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        Class managedClass = AopUtils.getTargetClass((Object)managedBean);
        ManagedResource mr = this.attributeSource.getManagedResource(managedClass);
        if (mr != null && StringUtils.hasText((String)mr.getObjectName())) {
            return ObjectName.getInstance(mr.getObjectName());
        }
        String domain = this.defaultDomain;
        if (domain == null) {
            domain = ClassUtils.getPackageName((Class)managedClass);
        }
        return ObjectName.getInstance(domain + ":type=components,name=" + beanKey);
    }
}

