/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.spring;

import co.paralleluniverse.common.spring.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;

public abstract class Service
extends Component {
    private static final Logger LOG = LoggerFactory.getLogger(Service.class);
    private static final Object SERVICE_AVILABILITY_LOCK = new Object();
    private volatile boolean available;
    private boolean dependenciesAvailable;
    private boolean ready = false;
    private boolean availabilityChanged;
    private final Set<Service> dependsOn = new CopyOnWriteArraySet<Service>();
    private final Set<Service> dependedBy = new CopyOnWriteArraySet<Service>();

    protected Service(String name) {
        super(name);
    }

    void addDependedBy(Service service) {
        this.assertDuringInitialization();
        this.dependedBy.add(service);
    }

    void addDependsOn(Service service) {
        this.assertDuringInitialization();
        this.dependsOn.add(service);
    }

    public void addDependency(Service service) {
        this.assertDuringInitialization();
        LOG.info("Adding a dependency on {} to {}", (Object)service.getName(), (Object)this.getName());
        this.addDependsOn(service);
        service.addDependedBy(this);
    }

    protected void removeDependency(Service service) {
        this.assertDuringInitialization();
        LOG.info("Service {} is not dependent on {}", (Object)this, (Object)service);
        if (!this.dependsOn.remove(service)) {
            LOG.warn("Service {} asked to remove dependency on {}, but wasn't dependendent on it", (Object)this.getName(), (Object)service.getName());
        }
    }

    @ManagedAttribute(currencyTimeLimit=0, description="Services that depend on this service")
    public List<String> getDependedBy() {
        ArrayList<String> ds = new ArrayList<String>(this.dependedBy.size());
        for (Service s : this.dependedBy) {
            ds.add(s.getName());
        }
        return ds;
    }

    @ManagedAttribute(currencyTimeLimit=0, description="Services this service depends on")
    public List<String> getDependsOn() {
        ArrayList<String> ds = new ArrayList<String>(this.dependsOn.size());
        for (Service s : this.dependsOn) {
            ds.add(s.getName());
        }
        return ds;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        LOG.info("Service {} dependencies: {}", (Object)this.getName(), this.getDependsOn());
    }

    @Override
    protected void postInit() throws Exception {
        super.postInit();
        this.checkDependenciesAvailability();
        this.checkAvailability();
        this.runAvailableMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDependenciesAvailability() {
        Object object = SERVICE_AVILABILITY_LOCK;
        synchronized (object) {
            for (Service dep : this.dependsOn) {
                if (dep.isAvailable()) continue;
                this.dependenciesAvailable = false;
                return false;
            }
            this.dependenciesAvailable = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAvailability() {
        Object object = SERVICE_AVILABILITY_LOCK;
        synchronized (object) {
            boolean _available;
            boolean bl = _available = this.ready && this.dependenciesAvailable;
            if (_available != this.available) {
                this.availabilityChanged = true;
                SERVICE_AVILABILITY_LOCK.notifyAll();
                this.available = _available;
                SERVICE_AVILABILITY_LOCK.notifyAll();
                LOG.info("SERVICE {} IS NOW {}", (Object)this, (Object)(this.available ? "AVILABLE" : "NOT AVAILABLE"));
                for (Service dependent : this.dependedBy) {
                    dependent.dependencyChanged(this);
                }
            }
        }
        return this.available;
    }

    private void runAvailableMethod() {
        if (this.availabilityChanged) {
            this.available(this.available);
            this.availabilityChanged = false;
            for (Service dependent : this.dependedBy) {
                dependent.runAvailableMethod();
            }
        }
    }

    private void dependencyChanged(Service service) {
        this.checkDependenciesAvailability();
        this.checkAvailability();
    }

    protected void available(boolean value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReady(boolean ready) {
        Object object = SERVICE_AVILABILITY_LOCK;
        synchronized (object) {
            LOG.info("Service {} is now {}", (Object)this.getName(), (Object)(ready ? "READY" : "NOT READY"));
            this.ready = ready;
            this.checkAvailability();
        }
        this.runAvailableMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitAvailable() throws InterruptedException {
        Object object = SERVICE_AVILABILITY_LOCK;
        synchronized (object) {
            while (!this.available) {
                LOG.info("Waiting for service {} to become available...", (Object)this.getName());
                LOG.debug(this.getDependencyGraph());
                SERVICE_AVILABILITY_LOCK.wait();
            }
        }
    }

    @ManagedAttribute(currencyTimeLimit=0)
    public boolean isReady() {
        return this.ready;
    }

    @ManagedAttribute(currencyTimeLimit=0)
    public boolean isAvailable() {
        return this.available;
    }

    @ManagedAttribute
    public String getDependencyGraph() {
        return this.getDependencyGraph(new StringBuilder(), 0).toString();
    }

    private StringBuilder getDependencyGraph(StringBuilder sb, int indent) {
        sb.append('\n');
        for (int i = 0; i < indent * 4; ++i) {
            sb.append(' ');
        }
        sb.append(this.getName()).append(": ").append(this.isReady() ? "READY" : "NOT READY");
        for (Service s : this.dependsOn) {
            s.getDependencyGraph(sb, indent + 1);
        }
        return sb;
    }
}

