/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.spring;

import co.paralleluniverse.common.spring.Component;
import co.paralleluniverse.common.spring.MBeanNamingStrategy;
import co.paralleluniverse.common.spring.Service;
import co.paralleluniverse.common.util.DOMElementProprtyEditor;
import com.google.common.base.Throwables;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.w3c.dom.Element;

public final class SpringContainerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SpringContainerHelper.class);

    public static ConfigurableApplicationContext createContext(String defaultDomain, Resource xmlResource, Object properties, BeanFactoryPostProcessor beanFactoryPostProcessor) {
        LOG.info("JAVA: {} {}, {}", new Object[]{System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"), System.getProperty("java.vendor")});
        LOG.info("OS: {} {}, {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        LOG.info("DIR: {}", (Object)System.getProperty("user.dir"));
        final DefaultListableBeanFactory beanFactory = SpringContainerHelper.createBeanFactory();
        GenericApplicationContext context = new GenericApplicationContext(beanFactory);
        context.registerShutdownHook();
        PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertyPlaceholderConfigurer();
        propertyPlaceholderConfigurer.setSystemPropertiesMode(2);
        if (properties != null) {
            if (properties instanceof Resource) {
                propertyPlaceholderConfigurer.setLocation((Resource)properties);
            } else if (properties instanceof Properties) {
                propertyPlaceholderConfigurer.setProperties((Properties)properties);
            } else {
                throw new IllegalArgumentException("Properties argument - " + properties + " - is of an unhandled type");
            }
        }
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)propertyPlaceholderConfigurer);
        context.registerBeanDefinition("mbeanExporter", SpringContainerHelper.getMBeanExporterBeanDefinition(defaultDomain));
        context.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                for (String beanName : beanFactory.getBeanDefinitionNames()) {
                    try {
                        Class<?> beanClass;
                        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                        if (beanDefinition.getBeanClassName() == null || !Component.class.isAssignableFrom(beanClass = Class.forName(beanDefinition.getBeanClassName()))) continue;
                        beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanName);
                    }
                    catch (Exception ex) {
                        LOG.error("Error loading bean " + beanName + " definition.", (Throwable)ex);
                        throw new Error(ex);
                    }
                }
            }
        });
        if (beanFactoryPostProcessor != null) {
            context.addBeanFactoryPostProcessor(beanFactoryPostProcessor);
        }
        beanFactory.registerCustomEditor(Element.class, DOMElementProprtyEditor.class);
        final HashMap beans = new HashMap();
        beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                LOG.info("Loading bean {} [{}]", (Object)beanName, (Object)bean.getClass().getName());
                beans.put(beanName, bean);
                if (bean instanceof Service) {
                    BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                    Collection<String> dependencies = SpringContainerHelper.getBeanDependencies(beanDefinition);
                    for (String dependeeName : dependencies) {
                        Object dependee = beanFactory.getBean(dependeeName);
                        if (!(dependee instanceof Service)) continue;
                        ((Service)dependee).addDependedBy((Service)bean);
                        ((Service)bean).addDependsOn((Service)dependee);
                    }
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                LOG.info("Bean {} [{}] loaded", (Object)beanName, (Object)bean.getClass().getName());
                return bean;
            }
        });
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        xmlReader.loadBeanDefinitions(xmlResource);
        context.refresh();
        try {
            for (Map.Entry entry : beans.entrySet()) {
                String beanName = (String)entry.getKey();
                Object bean = entry.getValue();
                if (!(bean instanceof Component)) continue;
                LOG.info("Performing post-initialization on bean {} [{}]", (Object)beanName, (Object)bean.getClass().getName());
                ((Component)bean).postInit();
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return context;
    }

    public static Collection<String> getBeanDependencies(BeanDefinition beanDefinition) {
        HashSet<String> dependencies = new HashSet<String>();
        if (beanDefinition.getDependsOn() != null) {
            dependencies.addAll(Arrays.asList(beanDefinition.getDependsOn()));
        }
        for (ConstructorArgumentValues.ValueHolder value : beanDefinition.getConstructorArgumentValues().getGenericArgumentValues()) {
            if (!(value.getValue() instanceof BeanReference)) continue;
            dependencies.add(((BeanReference)value.getValue()).getBeanName());
        }
        for (ConstructorArgumentValues.ValueHolder value : beanDefinition.getConstructorArgumentValues().getIndexedArgumentValues().values()) {
            if (!(value.getValue() instanceof BeanReference)) continue;
            dependencies.add(((BeanReference)value.getValue()).getBeanName());
        }
        for (ConstructorArgumentValues.ValueHolder value : beanDefinition.getPropertyValues().getPropertyValueList()) {
            if (!(value.getValue() instanceof BeanReference)) continue;
            dependencies.add(((BeanReference)value.getValue()).getBeanName());
        }
        return dependencies;
    }

    private static DefaultListableBeanFactory createBeanFactory() {
        return new DefaultListableBeanFactory(){
            {
                final InstantiationStrategy is = this.getInstantiationStrategy();
                this.setInstantiationStrategy(new InstantiationStrategy(){

                    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) throws BeansException {
                        return is.instantiate(beanDefinition, beanName, owner);
                    }

                    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor<?> ctor, Object[] args) throws BeansException {
                        Object bean = is.instantiate(beanDefinition, beanName, owner, ctor, args);
                        this.addDependencies(bean, args);
                        return bean;
                    }

                    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Object factoryBean, Method factoryMethod, Object[] args) throws BeansException {
                        Object bean = is.instantiate(beanDefinition, beanName, owner, factoryBean, factoryMethod, args);
                        this.addDependencies(bean, args);
                        return bean;
                    }
                });
            }

            private void addDependencies(Object bean, Object[] args) {
                if (bean instanceof Service) {
                    for (Object arg : args) {
                        if (!(arg instanceof Service)) continue;
                        ((Service)arg).addDependedBy((Service)bean);
                        ((Service)bean).addDependsOn((Service)arg);
                    }
                }
            }
        };
    }

    public static BeanDefinition defineBean(Class<?> clazz, ConstructorArgumentValues constructorArgs, MutablePropertyValues properties) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(clazz);
        bean.setAutowireCandidate(true);
        bean.setConstructorArgumentValues(constructorArgs);
        bean.setPropertyValues(properties);
        return bean;
    }

    private static BeanDefinition getMBeanExporterBeanDefinition(String defaultDomain) {
        AnnotationJmxAttributeSource annotationSource = new AnnotationJmxAttributeSource();
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(MBeanExporter.class);
        MutablePropertyValues properties = new MutablePropertyValues();
        properties.add("server", (Object)ManagementFactory.getPlatformMBeanServer());
        properties.add("autodetectMode", (Object)2);
        properties.add("assembler", (Object)new MetadataMBeanInfoAssembler((JmxAttributeSource)annotationSource));
        properties.add("namingStrategy", (Object)new MBeanNamingStrategy((JmxAttributeSource)annotationSource).setDefaultDomain(defaultDomain));
        bean.setPropertyValues(properties);
        return bean;
    }

    public static ConstructorArgumentValues constructorArgs(Object ... args) {
        ConstructorArgumentValues cav = new ConstructorArgumentValues();
        for (int i = 0; i < args.length; ++i) {
            cav.addIndexedArgumentValue(i, args[i]);
        }
        return cav;
    }

    public static MutablePropertyValues properties(Map<String, ? extends Object> properties) {
        MutablePropertyValues mpv = new MutablePropertyValues(properties);
        return mpv;
    }

    private SpringContainerHelper() {
    }
}

