/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy;

import co.paralleluniverse.common.spring.Service;
import co.paralleluniverse.common.spring.SpringContainerHelper;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.Messenger;
import co.paralleluniverse.galaxy.Store;
import co.paralleluniverse.galaxy.core.AbstractCluster;
import co.paralleluniverse.galaxy.core.Backup;
import co.paralleluniverse.galaxy.core.Cache;
import co.paralleluniverse.galaxy.core.ClusterMonitor;
import co.paralleluniverse.galaxy.core.StoreImpl;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class Grid {
    private static Grid instance = null;
    private static final Object lock = new Object();
    private final ApplicationContext context;
    private final Messenger messenger;
    private final Backup backup;
    private final Cache cache;
    private final Store store;
    private final Cluster cluster;
    private final ClusterMonitor clusterMonitor;

    public static Grid getInstance() throws InterruptedException {
        return Grid.getInstance(null, (Object)null);
    }

    public static Grid getInstance(String configFile, String propertiesFile) throws InterruptedException {
        return Grid.getInstance(configFile, (Object)propertiesFile);
    }

    public static Grid getInstance(String configFile, Properties properties) throws InterruptedException {
        return Grid.getInstance(configFile, (Object)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Grid getInstance(String configFile, Object properties) throws InterruptedException {
        Object object = lock;
        synchronized (object) {
            Grid _instance = instance;
            if (_instance == null) {
                _instance = new Grid(configFile, properties);
                if (_instance == null) {
                    throw new RuntimeException("Error while creating a grid instance from configuration file " + configFile + "!");
                }
                instance = _instance;
                if (Boolean.getBoolean("co.paralleluniverse.galaxy.autoGoOnline")) {
                    instance.goOnline();
                }
            }
            return _instance;
        }
    }

    private Grid(String configFile, Object properties) throws InterruptedException {
        if (configFile == null) {
            configFile = System.getProperty("co.paralleluniverse.galaxy.configFile");
        }
        if (properties == null) {
            properties = System.getProperty("co.paralleluniverse.galaxy.propertiesFile");
        }
        this.context = SpringContainerHelper.createContext("co.paralleluniverse.galaxy", (Resource)(configFile != null ? new FileSystemResource(configFile) : new ClassPathResource("galaxy.xml")), properties instanceof String ? new FileSystemResource((String)properties) : properties, new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory1) throws BeansException {
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)beanFactory1;
            }
        });
        this.cluster = (Cluster)this.context.getBean("cluster", Cluster.class);
        this.clusterMonitor = new ClusterMonitor(this.cluster);
        this.backup = (Backup)this.context.getBean("backup", Backup.class);
        this.cache = (Cache)this.context.getBean("cache", Cache.class);
        this.store = new StoreImpl(this.cache);
        this.messenger = (Messenger)this.context.getBean("messenger", Messenger.class);
    }

    public Store store() {
        return this.store;
    }

    public Messenger messenger() {
        return this.messenger;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public void goOnline() throws InterruptedException {
        ((Service)((Object)this.backup)).awaitAvailable();
        ((AbstractCluster)this.cluster).goOnline();
        this.cache.awaitAvailable();
    }
}

