/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy;

import co.paralleluniverse.common.spring.SpringContainerHelper;
import co.paralleluniverse.galaxy.core.AbstractCluster;
import co.paralleluniverse.galaxy.core.MainMemory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class Server {
    public static void start(String configFile) {
        Server.start(configFile, null);
    }

    public static void start(String configFile, String propertiesFile) {
        ConfigurableApplicationContext context = SpringContainerHelper.createContext("co.paralleluniverse.galaxy", (Resource)(configFile != null ? new FileSystemResource(configFile) : new ClassPathResource("galaxy.xml")), propertiesFile != null ? new FileSystemResource(propertiesFile) : null, null);
        MainMemory memory = (MainMemory)context.getBean("memory", MainMemory.class);
        ((AbstractCluster)memory.getCluster()).goOnline();
    }

    public static void main(String[] args) throws Exception {
        String configFile = args.length > 0 ? args[0] : null;
        String propertiesFile = args.length > 1 ? args[1] : null;
        Server.start(configFile, propertiesFile);
        Thread.sleep(Long.MAX_VALUE);
    }
}

