/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.berkeleydb;

import co.paralleluniverse.common.logging.LoggingUtils;
import co.paralleluniverse.common.spring.Component;
import co.paralleluniverse.galaxy.server.MainMemoryDB;
import co.paralleluniverse.galaxy.server.MainMemoryEntry;
import com.google.common.base.Throwables;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseExistsException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.list.array.TLongArrayList;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;

public class BerkeleyDB
extends Component
implements MainMemoryDB {
    private static final Logger LOG = LoggerFactory.getLogger(BerkeleyDB.class);
    private final Environment env;
    private Database ownerDirectory;
    private SecondaryDatabase ownerIndex;
    private Database mainStore;
    private Database allocationDirectory;
    private final TupleBinding<MainMemoryEntry> entryBinding;
    private static final DatabaseEntry SERVER = new DatabaseEntry(Shorts.toByteArray((short)0));
    private final String envHome;
    private boolean truncate = false;
    private Durability.SyncPolicy durability = Durability.SyncPolicy.WRITE_NO_SYNC;

    @ConstructorProperties(value={"name", "envHome"})
    public BerkeleyDB(String name, String envHome) {
        super(name);
        this.envHome = envHome;
        EnvironmentConfig envConfig = new EnvironmentConfig().setAllowCreate(true).setTransactional(true);
        envConfig.setDurability(new Durability(this.durability, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        File dir = new File(this.envHome);
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot mkdir " + envHome, ex);
        }
        this.env = new Environment(dir, envConfig);
        this.entryBinding = new MainMemoryTupleBinding();
    }

    public void setTruncate(boolean truncate) {
        this.assertDuringInitialization();
        this.truncate = truncate;
    }

    @ManagedAttribute
    public boolean isTruncate() {
        return this.truncate;
    }

    @ManagedAttribute(currencyTimeLimit=-1, description="The BDB environment directory")
    public String getEnvHome() {
        return this.envHome;
    }

    @Override
    public void init() throws Exception {
        super.init();
        LOG.info("Opening database, home: {}", (Object)this.env.getHome());
        if (this.truncate) {
            this.openOrCreate();
            this.ownerIndex.close();
            this.ownerDirectory.close();
            this.mainStore.close();
            this.allocationDirectory.close();
            this.truncate();
        }
        this.openOrCreate();
        PreloadConfig ownerDirectoryPreloadConfig = new PreloadConfig();
        this.ownerDirectory.preload(ownerDirectoryPreloadConfig);
        if (!this.truncate) {
            this.resetOwners();
        }
    }

    private void openOrCreate() throws DatabaseException, IllegalStateException, DatabaseExistsException, DatabaseNotFoundException, IllegalArgumentException {
        this.ownerDirectory = this.env.openDatabase(null, "ownerDirecotry", new DatabaseConfig().setAllowCreate(true).setTransactional(true));
        this.ownerIndex = this.env.openSecondaryDatabase(null, "ownerIndex", this.ownerDirectory, ((SecondaryConfig)new SecondaryConfig().setAllowCreate(true).setSortedDuplicates(true).setTransactional(true)).setAllowPopulate(true).setKeyCreator((SecondaryKeyCreator)new OwnerKeyCreator()));
        this.mainStore = this.env.openDatabase(null, "mainStore", new DatabaseConfig().setAllowCreate(true).setTransactional(true));
        this.allocationDirectory = this.env.openDatabase(null, "allocationDirectory", new DatabaseConfig().setAllowCreate(true).setTransactional(true));
    }

    public void truncate() {
        LOG.info("Truncating database, home: {}", (Object)this.env.getHome());
        Transaction txn = this.env.beginTransaction(null, TransactionConfig.DEFAULT);
        try {
            this.env.truncateDatabase(txn, "ownerDirecotry", false);
            this.env.truncateDatabase(txn, "ownerIndex", false);
            txn.commit();
            this.env.truncateDatabase(null, "mainStore", false);
            this.env.truncateDatabase(null, "allocationDirectory", false);
        }
        catch (Exception e) {
            LOG.error("Exception while truncating database. Aborting.", (Throwable)e);
            txn.abort();
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public short casOwner(long id, short oldNode, short newNode) {
        DatabaseEntry key = new DatabaseEntry(Longs.toByteArray((long)id));
        DatabaseEntry value = new DatabaseEntry();
        Transaction txn = this.env.beginTransaction(null, null);
        try {
            OperationStatus status;
            value.setData(Shorts.toByteArray((short)newNode));
            if (oldNode < 0 && (status = this.ownerDirectory.putNoOverwrite(txn, key, value)) == OperationStatus.SUCCESS) {
                LOG.debug("CAS owner succeeded.");
                txn.commit();
                return newNode;
            }
            status = this.ownerDirectory.get(txn, key, value, LockMode.RMW);
            if (status == OperationStatus.SUCCESS) {
                short curOldNode = Shorts.fromByteArray((byte[])value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CAS owner of {}: current old node: {} wanted old node: {}", new Object[]{LoggingUtils.hex(id), curOldNode, oldNode});
                }
                if (oldNode != curOldNode) {
                    assert (curOldNode >= 0);
                    LOG.debug("CAS owner failed.");
                    txn.commit();
                    return curOldNode;
                }
                LOG.debug("CAS owner succeeded.");
                value.setData(Shorts.toByteArray((short)newNode));
                this.ownerDirectory.put(txn, key, value);
                txn.commit();
                return newNode;
            }
            if (status == OperationStatus.NOTFOUND) {
                LOG.debug("CAS owner failed.");
                txn.commit();
                return -1;
            }
            LOG.debug("Bad status: {}", (Object)status);
            throw new AssertionError();
        }
        catch (Exception e) {
            LOG.error("Exception during DB operation. Aborting transaction.", (Throwable)e);
            txn.abort();
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void removeOwner(short node) {
        boolean trace = LOG.isTraceEnabled();
        Transaction txn = null;
        TLongArrayList lines = new TLongArrayList();
        DatabaseEntry sKey = new DatabaseEntry(Shorts.toByteArray((short)node));
        DatabaseEntry pKey = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try (SecondaryCursor cursor = this.ownerIndex.openCursor(txn, null);){
            OperationStatus retVal = cursor.getSearchKey(sKey, pKey, data, LockMode.DEFAULT);
            while (retVal == OperationStatus.SUCCESS) {
                long id = Longs.fromByteArray((byte[])pKey.getData());
                if (trace) {
                    LOG.trace("Owner of {}: {} -> 0", (Object)id, (Object)node);
                }
                lines.add(id);
                retVal = cursor.getNextDup(sKey, pKey, data, LockMode.DEFAULT);
            }
        }
        byte[] longArray = new byte[8];
        TLongIterator it = lines.iterator();
        while (it.hasNext()) {
            BerkeleyDB.toByteArray(it.next(), longArray);
            pKey.setData(longArray);
            this.ownerDirectory.put(null, pKey, SERVER);
        }
    }

    public void resetOwners() {
        boolean trace = LOG.isTraceEnabled();
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try (DiskOrderedCursor cursor = this.ownerDirectory.openCursor(new DiskOrderedCursorConfig().setKeysOnly(true));){
            OperationStatus retVal = cursor.getNext(key, data, null);
            while (retVal == OperationStatus.SUCCESS) {
                if (trace) {
                    LOG.trace("Owner of {} -> 0", (Object)Longs.fromByteArray((byte[])key.getData()));
                }
                this.ownerDirectory.put(null, key, SERVER);
                retVal = cursor.getNext(key, data, null);
            }
        }
    }

    @Override
    public void allocate(short owner, long start, int num) {
        DatabaseEntry key = new DatabaseEntry(Longs.toByteArray((long)(start + (long)num - 1L)));
        DatabaseEntry value = new DatabaseEntry(Shorts.toByteArray((short)owner));
        Transaction txn = null;
        try {
            OperationStatus status = this.allocationDirectory.putNoOverwrite(txn, key, value);
            if (status != OperationStatus.SUCCESS) {
                LOG.debug("Bad status: {}", (Object)status);
                throw new AssertionError();
            }
            if (txn != null) {
                txn.commit();
            }
        }
        catch (Exception e) {
            LOG.error("Exception during DB operation. Aborting transaction.", (Throwable)e);
            if (txn != null) {
                txn.abort();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public short findAllocation(long ref) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Throwable throwable = null;
        try (Cursor cursor = this.allocationDirectory.openCursor(null, CursorConfig.DEFAULT);){
            OperationStatus retVal = cursor.getSearchKeyRange(key, data, null);
            if (retVal == OperationStatus.SUCCESS) {
                this.ownerDirectory.put(null, key, SERVER);
                short s = Shorts.fromByteArray((byte[])data.getData());
                return s;
            }
            if (retVal == OperationStatus.NOTFOUND) {
                short s = -1;
                return s;
            }
            try {
                throw new AssertionError();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public Object beginTransaction() {
        return this.env.beginTransaction(null, TransactionConfig.DEFAULT);
    }

    @Override
    public void commit(Object txn) {
        LOG.debug("commit");
        ((Transaction)txn).commit();
    }

    @Override
    public void abort(Object txn) {
        LOG.debug("abort");
        ((Transaction)txn).abort();
    }

    @Override
    public void write(long id, short owner, long version, byte[] data, Object txn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("WRITE " + LoggingUtils.hex(id) + " ver: " + version + " data: " + (data != null ? "(" + data.length + " bytes)" : "null"));
        }
        DatabaseEntry key = new DatabaseEntry(Longs.toByteArray((long)id));
        DatabaseEntry dbEntry = new DatabaseEntry();
        this.entryBinding.objectToEntry((Object)new MainMemoryEntry(version, data), dbEntry);
        this.mainStore.put((Transaction)txn, key, dbEntry);
        this.ownerDirectory.putNoOverwrite((Transaction)txn, key, new DatabaseEntry(Shorts.toByteArray((short)owner)));
    }

    @Override
    public MainMemoryEntry read(long id) {
        DatabaseEntry dbEntry = new DatabaseEntry();
        OperationStatus status = this.mainStore.get(null, new DatabaseEntry(Longs.toByteArray((long)id)), dbEntry, LockMode.READ_COMMITTED);
        if (status == OperationStatus.SUCCESS) {
            MainMemoryEntry entry = (MainMemoryEntry)this.entryBinding.entryToObject(dbEntry);
            return entry;
        }
        return null;
    }

    @Override
    public void delete(long id, Object txn) {
        this.mainStore.delete((Transaction)txn, new DatabaseEntry(Longs.toByteArray((long)id)));
        this.ownerDirectory.delete((Transaction)txn, new DatabaseEntry(Longs.toByteArray((long)id)));
    }

    @Override
    public long getMaxId() {
        long allocationDirectoryMaxId = this.getMaxId(this.allocationDirectory);
        LOG.info("AllocationDirectory max id: {}", (Object)allocationDirectoryMaxId);
        return allocationDirectoryMaxId;
    }

    private long getMaxId(Database db) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try (Cursor cursor = db.openCursor(null, CursorConfig.DEFAULT);){
            OperationStatus status = cursor.getLast(key, value, null);
            if (status == OperationStatus.SUCCESS) {
                long l = Longs.fromByteArray((byte[])key.getData());
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    @Override
    public void close() {
        this.ownerIndex.close();
        this.ownerDirectory.close();
        this.mainStore.close();
        this.env.close();
    }

    @Override
    public void dump(PrintStream ps) {
        String home = "";
        try {
            home = this.env.getHome().getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ps.println();
        ps.println("BERKELEYDB " + home);
        ps.println("=====================================");
        ps.println();
        this.printOwners(ps);
        ps.println();
        this.printMainStore(ps);
        ps.println();
        this.printOwnerIndex(ps);
        ps.println();
    }

    public void printOwners(PrintStream ps) {
        ps.println("OWNERS");
        ps.println("======");
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try (Cursor cursor = this.ownerDirectory.openCursor(null, CursorConfig.DEFAULT);){
            while (cursor.getNext(key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                long id = Longs.fromByteArray((byte[])key.getData());
                short owner = Shorts.fromByteArray((byte[])value.getData());
                ps.println("Id : " + LoggingUtils.hex(id) + " owner: " + owner + "");
            }
        }
    }

    public void printMainStore(PrintStream ps) {
        ps.println("MAIN STORE");
        ps.println("==========");
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try (Cursor cursor = this.mainStore.openCursor(null, CursorConfig.DEFAULT);){
            while (cursor.getNext(key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                long id = Longs.fromByteArray((byte[])key.getData());
                MainMemoryEntry entry = (MainMemoryEntry)this.entryBinding.entryToObject(value);
                ps.println("Id : " + LoggingUtils.hex(id) + " version: " + entry.version + " data: (" + entry.data.length + " bytes).");
            }
        }
    }

    public void printOwnerIndex(PrintStream ps) {
        ps.println("OWNER INDEX");
        ps.println("===========");
        DatabaseEntry sKey = new DatabaseEntry();
        DatabaseEntry pKey = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try (SecondaryCursor cursor = this.ownerIndex.openCursor(null, CursorConfig.DEFAULT);){
            while (cursor.getNext(sKey, pKey, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                long id = Longs.fromByteArray((byte[])pKey.getData());
                short owner = Shorts.fromByteArray((byte[])sKey.getData());
                ps.println("Owner: " + owner + " id : " + LoggingUtils.hex(id));
            }
        }
    }

    public static byte[] toByteArray(long value, byte[] array) {
        array[0] = (byte)(value >> 56);
        array[1] = (byte)(value >> 48);
        array[2] = (byte)(value >> 40);
        array[3] = (byte)(value >> 32);
        array[4] = (byte)(value >> 24);
        array[5] = (byte)(value >> 16);
        array[6] = (byte)(value >> 8);
        array[7] = (byte)value;
        return array;
    }

    private static class OwnerKeyCreator
    implements SecondaryKeyCreator {
        private OwnerKeyCreator() {
        }

        public boolean createSecondaryKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, DatabaseEntry result) {
            result.setData(data.getData());
            return true;
        }
    }

    private static class MainMemoryTupleBinding
    extends TupleBinding<MainMemoryEntry> {
        private MainMemoryTupleBinding() {
        }

        public void objectToEntry(MainMemoryEntry entry, TupleOutput out) {
            out.writeLong(entry.version);
            out.writeFast(entry.data);
        }

        public MainMemoryEntry entryToObject(TupleInput in) {
            long version = in.readLong();
            int dataLength = in.getBufferLength() - in.getBufferOffset();
            byte[] data = new byte[dataLength];
            in.readFast(data);
            return new MainMemoryEntry(version, data);
        }
    }
}

