/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.cluster;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeAddressResolver;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.cluster.NodeInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeAddressResolver<Address>
implements NodeAddressResolver<Address> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeAddressResolver.class);
    private final Cluster cluster;
    private final Map<Short, Address> nodeIdToAddress = new ConcurrentHashMap<Short, Address>();
    private final Map<Address, Short> addressToNodeId = new ConcurrentHashMap<Address, Short>();

    public AbstractNodeAddressResolver(final Cluster cluster) {
        this.cluster = cluster;
        cluster.addNodeChangeListener(new NodeChangeListener(){

            @Override
            public void nodeAdded(short id) {
                AbstractNodeAddressResolver.this.put(cluster.getMaster(id));
            }

            @Override
            public void nodeSwitched(short id) {
                AbstractNodeAddressResolver.this.put(cluster.getMaster(id));
            }

            @Override
            public void nodeRemoved(short id) {
                Object address = AbstractNodeAddressResolver.this.nodeIdToAddress.get(id);
                if (address != null) {
                    AbstractNodeAddressResolver.this.addressToNodeId.remove(address);
                }
                AbstractNodeAddressResolver.this.nodeIdToAddress.remove(id);
            }
        });
    }

    protected void init() {
        for (NodeInfo node : this.cluster.getMasters()) {
            this.put(node);
        }
    }

    private void put(NodeInfo node) {
        short id = node.getNodeId();
        Address address = this.getAddress(this.cluster.getMaster(id));
        LOG.debug("Node {}, address: {}", (Object)id, address);
        if (address != null) {
            this.nodeIdToAddress.put(id, address);
            this.addressToNodeId.put(address, id);
        }
    }

    protected abstract Address getAddress(NodeInfo var1);

    @Override
    public short getNodeId(Address address) {
        Short node = this.addressToNodeId.get(address);
        return node != null ? (short)node : (short)-1;
    }

    @Override
    public Address getNodeAddress(short id) {
        return this.nodeIdToAddress.get(id);
    }
}

