/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.cluster;

import co.paralleluniverse.galaxy.cluster.DistributedTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DistributedBranchHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedBranchHelper.class);
    private final DistributedTree tree;
    private final String branchRoot;
    private final boolean ordered;
    private final ConcurrentSkipListMap<String, Node> nodes = new ConcurrentSkipListMap();
    private final List<DistributedTree.Listener> listeners = new CopyOnWriteArrayList<DistributedTree.Listener>();
    private boolean doneInit = false;

    public DistributedBranchHelper(DistributedTree tree, final String branchRoot, boolean ordered) {
        if (!branchRoot.startsWith("/")) {
            throw new IllegalArgumentException("Branch root must start with a '/', but is " + branchRoot);
        }
        this.tree = tree;
        this.branchRoot = branchRoot;
        this.ordered = ordered;
        tree.addListener(branchRoot, new DistributedTree.Listener(){

            @Override
            public void nodeChildAdded(String node, String childName) {
                assert (node.equals(branchRoot));
                DistributedBranchHelper.this.nodeAdded(childName);
            }

            @Override
            public void nodeChildDeleted(String node, String childName) {
                assert (node.equals(branchRoot));
                DistributedBranchHelper.this.nodeRemoved(childName);
            }

            @Override
            public void nodeChildUpdated(String node, String childName) {
                assert (node.equals(branchRoot));
                DistributedBranchHelper.this.nodeUpdated(childName);
            }

            @Override
            public void nodeUpdated(String node) {
                assert (node.equals(branchRoot));
                for (DistributedTree.Listener listener : DistributedBranchHelper.this.listeners) {
                    listener.nodeUpdated(node);
                }
            }

            @Override
            public void nodeAdded(String node) {
                assert (node.equals(branchRoot));
                for (DistributedTree.Listener listener : DistributedBranchHelper.this.listeners) {
                    listener.nodeAdded(node);
                }
            }

            @Override
            public void nodeDeleted(String node) {
                assert (node.equals(branchRoot));
                for (DistributedTree.Listener listener : DistributedBranchHelper.this.listeners) {
                    listener.nodeDeleted(node);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
        synchronized (concurrentSkipListMap) {
            Node first;
            if (this.ordered && (first = this.getFirstNode()) != null) {
                first.predecessorsComplete();
            }
            this.doneInit = true;
            this.nodes.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DistributedTree.Listener listener) {
        ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
        synchronized (concurrentSkipListMap) {
            for (Node node : this.nodes.values()) {
                if (node.isComplete()) {
                    listener.nodeChildAdded(this.branchRoot, node.name);
                    continue;
                }
                if (!this.ordered) continue;
                break;
            }
            this.listeners.add(listener);
        }
    }

    public void removeListener(DistributedTree.Listener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren() {
        ArrayList<String> children = new ArrayList<String>();
        ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
        synchronized (concurrentSkipListMap) {
            for (Node node : this.nodes.values()) {
                if (!node.isComplete()) break;
                children.add(node.name);
            }
        }
        return Collections.unmodifiableList(children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeAdded(String name) {
        ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
        synchronized (concurrentSkipListMap) {
            Node previous;
            Node node = this.nodes.remove(name);
            if (node == null) {
                node = new Node(name);
            }
            this.nodes.put(name, node);
            LOG.debug("Node {} added.", (Object)name);
            if (this.ordered && ((previous = this.getPreviousNode(name)) == null && this.doneInit || previous != null && previous.isComplete())) {
                node.predecessorsComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeCompleted(String name) {
        LOG.debug("Node {} completed", (Object)name);
        for (DistributedTree.Listener listener : this.listeners) {
            listener.nodeChildAdded(this.branchRoot, name);
        }
        if (this.ordered) {
            ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
            synchronized (concurrentSkipListMap) {
                Node next = this.getNextNode(name);
                if (next != null) {
                    next.predecessorsComplete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeUpdated(String name) {
        try {
            Node node;
            ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
            synchronized (concurrentSkipListMap) {
                while (!this.doneInit) {
                    this.nodes.wait();
                }
                node = this.nodes.get(name);
            }
            assert (node != null);
            LOG.debug("Node {} updated. ({})", (Object)name, (Object)(node.isComplete() ? "complete" : "incomplete"));
            if (node.isComplete()) {
                for (DistributedTree.Listener listener : this.listeners) {
                    listener.nodeChildUpdated(this.branchRoot, name);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeRemoved(String name) {
        try {
            boolean _doneInit;
            Node node;
            Node previous = null;
            Node next = null;
            ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
            synchronized (concurrentSkipListMap) {
                while (!this.doneInit) {
                    this.nodes.wait();
                }
                if (this.ordered) {
                    previous = DistributedBranchHelper.value(this.nodes.lowerEntry(name));
                    next = DistributedBranchHelper.value(this.nodes.higherEntry(name));
                }
                node = this.nodes.remove(name);
                _doneInit = this.doneInit;
            }
            if (node.isComplete()) {
                for (DistributedTree.Listener listener : this.listeners) {
                    listener.nodeChildDeleted(this.branchRoot, name);
                }
            }
            if (this.ordered && _doneInit && next != null && (previous == null || previous.isComplete())) {
                next.predecessorsComplete();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getNextNode(String node) {
        assert (this.ordered);
        ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
        synchronized (concurrentSkipListMap) {
            Map.Entry<String, Node> entry = this.nodes.higherEntry(node);
            return entry != null ? entry.getValue() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getPreviousNode(String node) {
        assert (this.ordered);
        ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
        synchronized (concurrentSkipListMap) {
            Map.Entry<String, Node> entry = this.nodes.lowerEntry(node);
            return entry != null ? entry.getValue() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getFirstNode() {
        assert (this.ordered);
        ConcurrentSkipListMap<String, Node> concurrentSkipListMap = this.nodes;
        synchronized (concurrentSkipListMap) {
            Map.Entry<String, Node> entry = this.nodes.firstEntry();
            return entry != null ? entry.getValue() : null;
        }
    }

    protected abstract boolean isNodeComplete(String var1, Set<String> var2);

    private static <K, V> V value(Map.Entry<K, V> entry) {
        return entry != null ? (V)entry.getValue() : null;
    }

    private static <K, V> K key(Map.Entry<K, V> entry) {
        return entry != null ? (K)entry.getKey() : null;
    }

    private class Node
    extends DistributedTree.ListenerAdapter {
        final String name;
        private final String treePath;
        private final Set<String> properties = new HashSet<String>();
        private boolean predecessorsComplete;
        private boolean complete = false;

        public Node(String name) {
            this.name = name;
            this.treePath = DistributedBranchHelper.this.branchRoot + '/' + name;
            this.predecessorsComplete = !DistributedBranchHelper.this.ordered;
            DistributedBranchHelper.this.tree.addListener(this.treePath, this);
            for (String property : DistributedBranchHelper.this.tree.getChildren(this.treePath)) {
                this.testProperty(property);
            }
        }

        public synchronized boolean isComplete() {
            return this.complete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void predecessorsComplete() {
            assert (DistributedBranchHelper.this.ordered);
            Node node = this;
            synchronized (node) {
                if (this.predecessorsComplete) {
                    return;
                }
                this.predecessorsComplete = true;
            }
            this.testComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testProperty(String property) {
            LOG.debug("Test property for {}: {}", (Object)this.name, (Object)property);
            Node node = this;
            synchronized (node) {
                if (DistributedBranchHelper.this.tree.get(this.treePath + '/' + property) == null) {
                    return;
                }
                this.properties.add(property);
            }
            this.testComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testComplete() {
            Node node = this;
            synchronized (node) {
                if (this.complete) {
                    return;
                }
                if (!this.predecessorsComplete || !DistributedBranchHelper.this.isNodeComplete(this.treePath, this.properties)) {
                    return;
                }
                this.complete = true;
                DistributedBranchHelper.this.tree.removeListener(this.treePath, this);
                LOG.debug("Node {} is now complete!", (Object)this.name);
            }
            DistributedBranchHelper.this.nodeCompleted(this.name);
        }

        @Override
        public void nodeChildAdded(String node, String childName) {
            this.nodeChildUpdated(node, childName);
        }

        @Override
        public void nodeChildUpdated(String node, String childName) {
            assert (node.equals(this.treePath));
            this.testProperty(childName);
        }
    }
}

