/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.cluster;

import co.paralleluniverse.galaxy.cluster.ReaderWriter;
import com.google.common.base.Charsets;

public final class ReaderWriters {
    public static final ReaderWriter<String> STRING = new ReaderWriter<String>(){

        @Override
        public String read(byte[] data) {
            return new String(data, Charsets.UTF_8);
        }

        @Override
        public byte[] write(String value) {
            return value.getBytes(Charsets.UTF_8);
        }
    };
    public static final ReaderWriter<Boolean> BOOLEAN = new ReaderWriter<Boolean>(){

        @Override
        public Boolean read(byte[] data) {
            return Boolean.parseBoolean(STRING.read(data));
        }

        @Override
        public byte[] write(Boolean value) {
            return STRING.write(value.toString());
        }
    };
    public static final ReaderWriter<Short> SHORT = new ReaderWriter<Short>(){

        @Override
        public Short read(byte[] data) {
            return Short.parseShort(STRING.read(data));
        }

        @Override
        public byte[] write(Short value) {
            return STRING.write(value.toString());
        }
    };
    public static final ReaderWriter<Integer> INTEGER = new ReaderWriter<Integer>(){

        @Override
        public Integer read(byte[] data) {
            return Integer.parseInt(STRING.read(data));
        }

        @Override
        public byte[] write(Integer value) {
            return STRING.write(value.toString());
        }
    };
    public static final ReaderWriter<Long> LONG = new ReaderWriter<Long>(){

        @Override
        public Long read(byte[] data) {
            return Long.parseLong(STRING.read(data));
        }

        @Override
        public byte[] write(Long value) {
            return STRING.write(value.toString());
        }
    };

    private ReaderWriters() {
    }
}

