/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.collection.ConcurrentMultimapWithCopyOnWriteArrayList;
import co.paralleluniverse.common.spring.Service;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.DistributedBranchHelper;
import co.paralleluniverse.galaxy.cluster.DistributedTree;
import co.paralleluniverse.galaxy.cluster.DistributedTreeAdapter;
import co.paralleluniverse.galaxy.cluster.LifecycleListener;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.cluster.NodeInfo;
import co.paralleluniverse.galaxy.cluster.NodePropertyListener;
import co.paralleluniverse.galaxy.cluster.ReaderWriter;
import co.paralleluniverse.galaxy.cluster.SlaveConfigurationListener;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCluster
extends Service
implements Cluster {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCluster.class);
    protected static final String ROOT = "/co.paralleluniverse.galaxy";
    protected static final String NODES = "/co.paralleluniverse.galaxy/nodes";
    protected static final String LEADERS = "/co.paralleluniverse.galaxy/leaders";
    private boolean hasServer = true;
    private final Set<String> requiredPeerNodeProperties = new HashSet<String>();
    private final Set<String> requiredServerProperties = new HashSet<String>();
    private final Map<String, ReaderWriter> readerWriters = new ConcurrentHashMap<String, ReaderWriter>();
    private final Map<String, NodeInfoImpl> nodes = new ConcurrentHashMap<String, NodeInfoImpl>();
    private final Set<String> leaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private DistributedTree controlTree;
    private DistributedTree protectedTree;
    private DistributedBranchHelper branch;
    protected final short myId;
    protected final NodeInfoImpl myNodeInfo;
    private volatile boolean online;
    private volatile boolean joined;
    private volatile boolean master;
    private volatile NodeInfoImpl myMaster;
    private final List<NodeInfoImpl> mySlaves = new CopyOnWriteArrayList<NodeInfoImpl>();
    private final Map<Short, NodeInfoImpl> masters = new ConcurrentHashMap<Short, NodeInfoImpl>();
    private volatile NodeInfoImpl server;
    private final List<NodeInfoImpl> slaveServers = new CopyOnWriteArrayList<NodeInfoImpl>();
    private final Set<Short> activeNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<NodeChangeListener> nodeChangeListeners = new CopyOnWriteArrayList<NodeChangeListener>();
    private final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();
    private final List<SlaveConfigurationListener> slaveConfigurationListeners = new CopyOnWriteArrayList<SlaveConfigurationListener>();
    private final ConcurrentMultimapWithCopyOnWriteArrayList<String, NodePropertyListener> masterNodePropertyListeners = new ConcurrentMultimapWithCopyOnWriteArrayList();
    private final ConcurrentMultimapWithCopyOnWriteArrayList<String, NodePropertyListener> slaveNodePropertyListeners = new ConcurrentMultimapWithCopyOnWriteArrayList();

    public AbstractCluster(String name, short nodeId) {
        super(name);
        if (nodeId < 0) {
            throw new IllegalArgumentException("nodId " + nodeId + " is <= 0!");
        }
        this.myId = nodeId;
        this.online = false;
        this.master = false;
        this.requiredPeerNodeProperties.add("id");
        this.requiredServerProperties.add("id");
        this.myNodeInfo = new NodeInfoImpl();
        this.myNodeInfo.setNodeId(nodeId);
    }

    protected void setName(String name) {
        this.assertDuringInitialization();
        this.myNodeInfo.setName(name);
    }

    public void setHasServer(boolean hasServer) {
        this.assertDuringInitialization();
        this.hasServer = hasServer;
    }

    @Override
    public boolean hasServer() {
        return this.hasServer;
    }

    @Override
    public synchronized void addNodeProperty(String property, boolean requiredForPeer, boolean requiredForServer, ReaderWriter<?> readerWriter) {
        if (requiredForPeer) {
            this.assertDuringInitialization();
            this.requiredPeerNodeProperties.add(property);
        }
        if (requiredForServer) {
            this.assertDuringInitialization();
            this.requiredServerProperties.add(property);
        }
        if (!requiredForPeer && !requiredForServer) {
            this.myNodeInfo.addProperty(property);
        }
        this.readerWriters.put(property, readerWriter);
    }

    @Override
    public synchronized void setNodeProperty(String property, Object value) {
        if (this.requiredPeerNodeProperties.contains(property) || this.requiredServerProperties.contains(property)) {
            this.assertDuringInitialization();
        }
        this.myNodeInfo.set(property, value);
    }

    protected final void setControlTree(DistributedTree controlTree) {
        this.assertDuringInitialization();
        this.controlTree = controlTree;
        this.protectedTree = new DistributedTreeAdapter(controlTree){

            @Override
            public void create(String node, boolean ephemeral) {
                super.create(this.protect(node), ephemeral);
            }

            @Override
            public void set(String node, byte[] data) {
                super.set(this.protect(node), data);
            }

            @Override
            public void delete(String node) {
                super.delete(this.protect(node));
            }

            private String protect(String node) {
                if (node.startsWith(AbstractCluster.NODES)) {
                    throw new IllegalArgumentException("Tree contents under /co.paralleluniverse.galaxy/nodes are reserved for internal use only!");
                }
                return node;
            }
        };
    }

    @Override
    protected void postInit() throws Exception {
        if (this.controlTree == null) {
            throw new RuntimeException("controlTree not set");
        }
        this.controlTree.create(NODES, false);
        this.controlTree.create(LEADERS, false);
        if (this.controlTree.exists(this.myNodeInfo.treeNodePath)) {
            LOG.error("A node with the name " + this.myNodeInfo.getName() + " already exists!");
            throw new RuntimeException("Initialization failure");
        }
        LOG.info("Required peer node properties: {}", this.requiredPeerNodeProperties);
        LOG.info("Required server properties: {}", this.requiredServerProperties);
        Set<String> requiredProperties = this.myId == 0 ? this.requiredServerProperties : this.requiredPeerNodeProperties;
        for (String property : requiredProperties) {
            if (property.equals("id") || this.myNodeInfo.get(property) != null) continue;
            LOG.error("Required property {} not set!", (Object)property);
            throw new RuntimeException("Initialization failure");
        }
        this.branch = new DistributedBranchHelper(this.controlTree, NODES, false){

            @Override
            protected boolean isNodeComplete(String node, Set<String> properties) {
                if (!properties.contains("id")) {
                    return false;
                }
                short id = Short.parseShort(new String(AbstractCluster.this.controlTree.get(node + "/id"), Charsets.UTF_8));
                Set requiredProperties = id == 0 ? AbstractCluster.this.requiredServerProperties : AbstractCluster.this.requiredPeerNodeProperties;
                boolean success = properties.containsAll(requiredProperties);
                return success;
            }
        };
        this.branch.addListener(new DistributedTree.ListenerAdapter(){

            @Override
            public void nodeChildAdded(String parentPath, String childName) {
                AbstractCluster.this.nodeAdded(childName);
            }

            @Override
            public void nodeChildDeleted(String parentPath, String childName) {
                AbstractCluster.this.nodeRemoved(childName);
            }
        });
        this.branch.init();
        this.controlTree.addListener(LEADERS, new DistributedTree.ListenerAdapter(){

            @Override
            public void nodeChildAdded(String parentPath, String childName) {
                AbstractCluster.this.leaderAdded(childName);
            }

            @Override
            public void nodeChildDeleted(String parentPath, String childName) {
                AbstractCluster.this.leaderRemoved(childName);
            }
        });
        this.myNodeInfo.writeToTree();
        this.setReady(true);
        super.postInit();
        this.joined = true;
        this.fireJoinedCluster();
        Iterator<Object> i$ = this.masters.keySet().iterator();
        while (i$.hasNext()) {
            short id = (Short)i$.next();
            if (id == this.myId) continue;
            this.fireNodeAdded(id);
        }
    }

    @Override
    protected void available(boolean value) {
        super.available(value);
        if (!value) {
            this.goOffline();
        }
    }

    @Override
    public DistributedTree getDistributedTree() {
        return this.protectedTree;
    }

    @Override
    public short getMyNodeId() {
        return this.myId;
    }

    @Override
    public NodeInfo getMyNodeInfo() {
        return this.myNodeInfo;
    }

    @Override
    public NodeInfo getNodeInfoByName(String nodeName) {
        return this.nodes.get(nodeName);
    }

    @Override
    public Collection<NodeInfo> getMasters() {
        return Collections.unmodifiableCollection(this.masters.values());
    }

    public Collection<NodeInfo> getAllSlaves() {
        return Collections.unmodifiableCollection(this.slaveServers);
    }

    @Override
    public NodeInfo getMaster(short node) {
        return this.masters.get(node);
    }

    @Override
    public boolean isMaster(NodeInfo node) {
        return this.masters.get(node.getNodeId()) == node;
    }

    @Override
    public NodeInfo getMyMaster() {
        return this.myMaster;
    }

    @Override
    public List<NodeInfo> getMySlaves() {
        return ImmutableList.copyOf(this.mySlaves);
    }

    @Override
    public boolean isMaster() {
        return this.master;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    public boolean isJoined() {
        return this.joined;
    }

    @Override
    public void shutdown() {
    }

    public void goOnline() {
        if (this.isOnline()) {
            return;
        }
        if (this.isSecondSlave()) {
            LOG.error("THERE ALREADY EXISTS A SLAVE FOR NODE " + this.getMyNodeId() + ". ABORTING.");
            this.goOffline();
            throw new UnsupportedOperationException("Second slave is not supported");
        }
        try {
            this.awaitAvailable();
            LOG.info("NODE IS NOW ATTEMPTING TO GO ONLINE");
            this.controlTree.createEphemeralOrdered("/co.paralleluniverse.galaxy/leaders/" + this.myNodeInfo.getName());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void goOffline() {
        this.setOnline(false);
    }

    private void setOnline(boolean value) {
        if (this.online == value) {
            return;
        }
        if (value && this.isSecondSlave()) {
            LOG.error("THERE ALREADY EXISTS A SLAVE FOR NODE " + this.getMyNodeId() + ". ABORTING.");
            value = false;
        }
        this.online = value;
        if (this.online) {
            this.fireOnline();
            for (NodeInfo nodeInfo : this.mySlaves) {
                this.fireSlaveAdded(nodeInfo);
            }
        } else {
            LOG.info("NODE IS GOING OFFLINE!");
            this.controlTree.delete("/co.paralleluniverse.galaxy/leaders/" + this.myNodeInfo.getName());
            this.fireOffline();
            this.shutdown();
        }
    }

    private void setMaster(boolean value) {
        if (this.master == value) {
            return;
        }
        this.master = value;
        if (this.master) {
            this.fireSwitchToMaster();
        } else {
            LOG.error("Switch to slave??? Souldn't happen!!!!");
        }
        for (NodeInfoImpl slave : this.findSlaves(this.myId)) {
            this.mySlaves.add(slave);
            this.fireSlaveAdded(slave);
        }
    }

    private void setMyMaster(NodeInfoImpl newMaster) {
        if (this.myMaster == newMaster) {
            return;
        }
        this.myMaster = newMaster;
        this.fireNewMaster(newMaster);
    }

    @Override
    public Set<Short> getNodes() {
        return Collections.unmodifiableSet(this.activeNodes);
    }

    @Override
    public Set<NodeInfo> getNodesByProperty(String propertyName, Object value) {
        HashSet<NodeInfoImpl> ns = new HashSet<NodeInfoImpl>();
        for (NodeInfoImpl n : this.nodes.values()) {
            Object v = n.get(propertyName);
            if (v != value && (v == null || !v.equals(value))) continue;
            ns.add(n);
        }
        return Collections.unmodifiableSet(ns);
    }

    protected abstract boolean isMe(NodeInfoImpl var1);

    private void nodeAdded(String nodeName) {
        LOG.info("New node added: {}", (Object)nodeName);
        NodeInfoImpl node = this.createNodeInfo(nodeName, true);
        this.nodes.put(nodeName, node);
        LOG.debug("nodes: {}", this.nodes);
        if (this.leaders.contains(nodeName)) {
            this.finishLeaderAdded(node);
        }
    }

    private void nodeRemoved(String nodeName) {
        LOG.info("Node removed: {}", (Object)nodeName);
        NodeInfoImpl node = this.nodes.get(nodeName);
        if (this.isMe(node)) {
            this.setOnline(false);
        }
        this.nodes.remove(nodeName);
    }

    private void leaderAdded(String nodeName) {
        this.leaders.add(nodeName);
        LOG.info("New leader added: {}", (Object)nodeName);
        NodeInfoImpl node = this.nodes.get(nodeName);
        if (node == null) {
            LOG.info("Node {} does not have a complete node info in the control tree. Waiting for node data completition", (Object)nodeName);
            return;
        }
        this.finishLeaderAdded(node);
    }

    private void finishLeaderAdded(NodeInfoImpl node) {
        boolean nodeIsServer;
        LOG.info("Finishing leader addition: {}", (Object)node.getName());
        NodeInfoImpl nodesMaster = this.findMaster(node.getNodeId(), null);
        boolean bl = nodeIsServer = node.getNodeId() == 0;
        if (node.getNodeId() == this.myId) {
            if (this.isMe(node)) {
                boolean bl2 = this.master = node == nodesMaster;
                if (!this.master) assert (this.myMaster == nodesMaster);
                LOG.info("=================================");
                LOG.info("GOING ONLINE AS {} {} {}", new Object[]{this.myId, this.master ? "MASTER" : "SLAVE.", this.master ? "" : "MASTER IS " + nodesMaster});
                LOG.info("=================================");
                this.setOnline(true);
            } else if (node == nodesMaster) {
                LOG.info("Node {} is my master.", (Object)node);
                this.myMaster = node;
                this.masters.put(node.getNodeId(), node);
            } else if (this.online && this.master) {
                LOG.info("Node {} is added as slave.", (Object)node);
                this.mySlaves.add(node);
                this.fireSlaveAdded(node);
            }
        } else if (node == nodesMaster) {
            LOG.info("New master for node {} is {}", (Object)node.getNodeId(), (Object)node);
            boolean switchover = this.masters.containsKey(node.getNodeId());
            this.masters.put(node.getNodeId(), node);
            if (nodeIsServer) {
                this.server = node;
            }
            if (switchover) {
                this.fireNodeSwitched(node.getNodeId());
            } else {
                this.activeNodes.add(node.getNodeId());
                this.fireNodeAdded(node.getNodeId());
            }
        } else {
            if (nodeIsServer) {
                this.slaveServers.add(node);
            }
            LOG.info("New slave for {}: {}", (Object)node.getNodeId(), (Object)node);
        }
    }

    private void leaderRemoved(String nodeName) {
        LOG.info("Leader removed: {}", (Object)nodeName);
        NodeInfoImpl node = this.nodes.get(nodeName);
        if (node == null) {
            LOG.info("Leader {} has been removed but it has no valid node info.", (Object)nodeName);
            return;
        }
        boolean nodeIsServer = node.getNodeId() == 0;
        NodeInfoImpl oldMaster = this.masters.get(node.getNodeId());
        if (nodeIsServer) {
            this.slaveServers.remove(node);
        }
        NodeInfoImpl newMaster = this.findMaster(node.getNodeId(), nodeName);
        if (oldMaster != node) {
            if (node.getNodeId() == this.myId && this.master) {
                if (this.mySlaves.remove(node)) {
                    LOG.info("My slave node {} has gone offline.", (Object)node);
                    this.fireSlaveRemoved(node);
                }
            } else {
                LOG.info("Slave node {} has gone offline.", (Object)node);
            }
        } else if (node.getNodeId() == this.myId) {
            if (newMaster == null) {
                LOG.info("No master found for node {}. (I am {})", (Object)node.getNodeId(), (Object)(this.online ? "ONLINE" : "NOT ONLINE"));
                this.setOnline(false);
            } else if (this.isMe(newMaster)) {
                if (!this.master) {
                    LOG.info("=====================");
                    LOG.info("SWITCHING TO MASTER");
                    LOG.info("=====================");
                    this.myMaster = null;
                    this.masters.remove(this.myId);
                    this.setMaster(true);
                }
            } else if (this.master) {
                LOG.error("Switch to slave??? Souldn't happen!!!!");
            } else {
                LOG.info("New master: {}", (Object)newMaster);
                this.masters.put(newMaster.getNodeId(), newMaster);
                this.setMyMaster(newMaster);
            }
        } else {
            if (nodeIsServer) {
                this.server = newMaster;
            }
            if (newMaster == null) {
                if (this.masters.remove(node.getNodeId()) != null) {
                    LOG.info("No master for node {} - it's going offline!", (Object)node.getNodeId());
                    this.activeNodes.remove(node.getNodeId());
                    this.fireNodeRemoved(node.getNodeId());
                }
            } else if (this.masters.put(newMaster.getNodeId(), newMaster) != newMaster) {
                LOG.info("New master for node {} is {}", (Object)node.getNodeId(), (Object)newMaster);
                this.fireNodeSwitched(newMaster.getNodeId());
            }
        }
    }

    private NodeInfoImpl findMaster(short nodeId, String oldMaster) {
        for (String nodeName : this.controlTree.getChildren(LEADERS)) {
            NodeInfoImpl node;
            if (oldMaster != null && oldMaster.equals(nodeName) || (node = this.nodes.get(nodeName)) == null || node.getNodeId() != nodeId) continue;
            return node;
        }
        return null;
    }

    private boolean isSecondSlave() {
        int counter = 0;
        for (String nodeName : this.controlTree.getChildren(LEADERS)) {
            NodeInfoImpl node = this.nodes.get(nodeName);
            if (node == null) continue;
            if (this.isMe(node)) break;
            if (node.getNodeId() != this.getMyNodeId()) continue;
            ++counter;
        }
        return counter > 1;
    }

    private List<NodeInfoImpl> findSlaves(short nodeId) {
        ArrayList<NodeInfoImpl> slaves = new ArrayList<NodeInfoImpl>();
        boolean foundMaster = false;
        for (String nodeName : this.controlTree.getChildren(LEADERS)) {
            NodeInfoImpl node = this.nodes.get(nodeName);
            assert (node != null);
            if (node.getNodeId() != nodeId) continue;
            if (foundMaster) {
                slaves.add(node);
                continue;
            }
            foundMaster = true;
        }
        return slaves;
    }

    protected NodeInfoImpl createNodeInfo(String nodeName, boolean attachToTree) {
        return new NodeInfoImpl(nodeName, attachToTree);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    @Override
    public void addSlaveConfigurationListener(SlaveConfigurationListener listener) {
        this.slaveConfigurationListeners.add(listener);
    }

    @Override
    public void removeSlaveConfigurationListener(SlaveConfigurationListener listener) {
        this.slaveConfigurationListeners.remove(listener);
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener listener) {
        this.nodeChangeListeners.add(listener);
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener listener) {
        this.nodeChangeListeners.remove(listener);
    }

    @Override
    public void addMasterNodePropertyListener(String property, NodePropertyListener listener) {
        this.assertPropertyRegistered(property);
        this.masterNodePropertyListeners.put(property, listener);
    }

    @Override
    public void removeMasterNodePropertyListener(String property, NodePropertyListener listener) {
        this.masterNodePropertyListeners.remove(property, listener);
    }

    @Override
    public void addSlaveNodePropertyListener(String property, NodePropertyListener listener) {
        this.assertPropertyRegistered(property);
        this.slaveNodePropertyListeners.put(property, listener);
    }

    @Override
    public void removeSlaveNodePropertyListener(String property, NodePropertyListener listener) {
        this.slaveNodePropertyListeners.remove(property, listener);
    }

    private void fireJoinedCluster() {
        for (LifecycleListener listener : this.lifecycleListeners) {
            try {
                listener.joinedCluster();
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireOnline() {
        for (LifecycleListener listener : this.lifecycleListeners) {
            try {
                listener.online(this.master);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireOffline() {
        for (LifecycleListener listener : this.lifecycleListeners) {
            try {
                listener.offline();
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireSwitchToMaster() {
        for (LifecycleListener listener : this.lifecycleListeners) {
            try {
                listener.switchToMaster();
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireNodeAdded(short id) {
        if (!this.isJoined()) {
            return;
        }
        for (NodeChangeListener listener : this.nodeChangeListeners) {
            try {
                listener.nodeAdded(id);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception for node " + id, (Throwable)e);
            }
        }
    }

    private void fireNodeSwitched(short id) {
        if (!this.isJoined()) {
            return;
        }
        for (NodeChangeListener listener : this.nodeChangeListeners) {
            try {
                listener.nodeSwitched(id);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireNodeRemoved(short id) {
        if (!this.isJoined()) {
            return;
        }
        for (NodeChangeListener listener : this.nodeChangeListeners) {
            try {
                listener.nodeRemoved(id);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireSlaveAdded(NodeInfo node) {
        if (!this.isOnline()) {
            return;
        }
        for (SlaveConfigurationListener listener : this.slaveConfigurationListeners) {
            try {
                listener.slaveAdded(node);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireSlaveRemoved(NodeInfo node) {
        if (!this.isOnline()) {
            return;
        }
        for (SlaveConfigurationListener listener : this.slaveConfigurationListeners) {
            try {
                listener.slaveRemoved(node);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireNewMaster(NodeInfo node) {
        if (!this.isOnline()) {
            return;
        }
        for (SlaveConfigurationListener listener : this.slaveConfigurationListeners) {
            try {
                listener.newMaster(node);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    void fireNodePropertyChanged(NodeInfoImpl node, String property, Object value) {
        block8: {
            block7: {
                if (node == this.myNodeInfo) {
                    return;
                }
                if (!this.masters.containsValue(node)) break block7;
                for (NodePropertyListener listener : (List)this.masterNodePropertyListeners.get(property)) {
                    try {
                        listener.propertyChanged(node, property, value);
                    }
                    catch (Exception e) {
                        LOG.error("Listener threw an exception.", (Throwable)e);
                    }
                }
                break block8;
            }
            if (!this.mySlaves.contains(node)) break block8;
            for (NodePropertyListener listener : (List)this.slaveNodePropertyListeners.get(property)) {
                try {
                    listener.propertyChanged(node, property, value);
                }
                catch (Exception e) {
                    LOG.error("Listener threw an exception.", (Throwable)e);
                }
            }
        }
    }

    private ReaderWriter assertPropertyRegistered(String property) {
        ReaderWriter rw = this.readerWriters.get(property);
        if (rw == null) {
            throw new RuntimeException("No ReaderWriter set for property " + property);
        }
        return rw;
    }

    protected final Object readProperty(String property, byte[] value) {
        ReaderWriter rw = this.assertPropertyRegistered(property);
        return rw.read(value);
    }

    protected final byte[] writeProperty(String property, Object value) {
        ReaderWriter rw = this.assertPropertyRegistered(property);
        return rw.write(value);
    }

    protected class NodeInfoImpl
    extends DistributedTree.ListenerAdapter
    implements NodeInfo {
        private String name;
        private String treeNodePath;
        private short nodeId = (short)-1;
        private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
        private final boolean attached;

        public NodeInfoImpl() {
            this.attached = false;
        }

        public NodeInfoImpl(String name) {
            this(name, true);
        }

        public NodeInfoImpl(String name, boolean attachToTree) {
            this.setName(name);
            this.attached = attachToTree;
            if (this.attached) {
                AbstractCluster.this.controlTree.addListener(this.treeNodePath, this);
                for (String child : AbstractCluster.this.controlTree.getChildren(this.treeNodePath)) {
                    this.nodeChildUpdated(this.treeNodePath, child);
                }
            }
        }

        private void setName(String name) {
            this.name = name;
            this.treeNodePath = "/co.paralleluniverse.galaxy/nodes/" + name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<String> getProperties() {
            return this.properties.keySet();
        }

        public String getTreeNodePath() {
            return this.treeNodePath;
        }

        @Override
        public short getNodeId() {
            return this.nodeId;
        }

        private void setNodeId(short nodeId) {
            AbstractCluster.this.assertDuringInitialization();
            if (this.attached) {
                throw new IllegalStateException("Node is attached to the tree!");
            }
            this.nodeId = nodeId;
        }

        public void addProperty(String property) {
            AbstractCluster.this.assertInitialized();
            if (this.attached) {
                throw new IllegalStateException("Node is attached to the tree!");
            }
            AbstractCluster.this.controlTree.create(this.treeNodePath + '/' + property, true);
        }

        public synchronized void set(String property, Object value) {
            if (this.attached) {
                throw new IllegalStateException("Node is attached to the tree!");
            }
            if (this.properties.get(property) != null) {
                if (!this.properties.get(property).equals(value)) {
                    throw new IllegalStateException("Property " + property + " has already been set do a different value");
                }
            } else {
                this.properties.put(property, value);
                if (AbstractCluster.this.isInitialized()) {
                    LOG.info("Publishing additional node info: {} = {}", (Object)property, value);
                    AbstractCluster.this.controlTree.set(this.treeNodePath + '/' + property, AbstractCluster.this.writeProperty(property, value));
                }
            }
        }

        @Override
        public Object get(String property) {
            return this.properties.get(property);
        }

        public void writeToTree() {
            AbstractCluster.this.assertDuringInitialization();
            if (this.attached) {
                throw new IllegalStateException("Node is attached to tree -> cannot be written!");
            }
            if (this.name == null || this.nodeId < 0) {
                throw new AssertionError((Object)"Incomplete node data");
            }
            LOG.info("Publishing node info: name = {}, id = {}", (Object)this.name, (Object)this.nodeId);
            AbstractCluster.this.controlTree.create(this.treeNodePath, true);
            AbstractCluster.this.controlTree.create(this.treeNodePath + '/' + "id", true);
            AbstractCluster.this.controlTree.set(this.treeNodePath + '/' + "id", Short.toString(this.nodeId).getBytes(Charsets.UTF_8));
            for (Map.Entry<String, Object> property : this.properties.entrySet()) {
                LOG.info("Publishing node info: {} = {}", (Object)property.getKey(), property.getValue());
                AbstractCluster.this.controlTree.create(this.treeNodePath + '/' + property.getKey(), true);
                AbstractCluster.this.controlTree.set(this.treeNodePath + '/' + property.getKey(), AbstractCluster.this.writeProperty(property.getKey(), property.getValue()));
            }
            AbstractCluster.this.controlTree.flush();
        }

        protected void readChild(String childName, byte[] value) {
            if ("id".equals(childName)) {
                short nodeValue = Short.parseShort(new String(value, Charsets.UTF_8));
                if (this.nodeId >= 0) {
                    if (this.nodeId != nodeValue) {
                        throw new RuntimeException("Id for node " + this.name + " is already set to " + this.nodeId);
                    }
                    return;
                }
                this.nodeId = nodeValue;
            } else {
                if (value == null) {
                    return;
                }
                if (AbstractCluster.this.readerWriters.get(childName) == null) {
                    LOG.warn("No reader set for property {} (found in node {})", (Object)childName, (Object)this.name);
                    return;
                }
                Object currentProperty = this.properties.get(childName);
                Object newValProperty = AbstractCluster.this.readProperty(childName, value);
                if ((AbstractCluster.this.requiredPeerNodeProperties.contains(childName) || AbstractCluster.this.requiredServerProperties.contains(childName)) && currentProperty != null) {
                    if (!currentProperty.equals(newValProperty)) {
                        throw new RuntimeException("Required property " + childName + " for node " + this.name + " is already set to " + this.properties.get(childName));
                    }
                    return;
                }
                this.properties.put(childName, newValProperty);
            }
        }

        @Override
        public void nodeChildAdded(String parentPath, String childName) {
            this.nodeChildUpdated(parentPath, childName);
        }

        @Override
        public final void nodeChildUpdated(String parentPath, String childName) {
            assert (parentPath.equals(this.treeNodePath));
            try {
                this.readChild(childName, AbstractCluster.this.controlTree.get(parentPath + '/' + childName));
                AbstractCluster.this.fireNodePropertyChanged(this, childName, this.properties.get(childName));
            }
            catch (Exception e) {
                LOG.error("Exception while reading control tree value.", (Throwable)e);
            }
        }

        @Override
        public void nodeChildDeleted(String node, String childName) {
            assert (!AbstractCluster.this.requiredPeerNodeProperties.contains(childName) && !AbstractCluster.this.requiredServerProperties.contains(childName));
            this.properties.remove(childName);
            AbstractCluster.this.fireNodePropertyChanged(this, childName, null);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NodeInfo)) {
                return false;
            }
            NodeInfoImpl other = (NodeInfoImpl)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NODE ").append(this.name);
            sb.append(" id: ").append(this.nodeId);
            for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(this.properties).entrySet()) {
                sb.append(' ').append(entry.getKey()).append(": ").append(entry.getValue());
            }
            return sb.toString();
        }
    }
}

