/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeAddressResolver;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.core.Cache;
import co.paralleluniverse.galaxy.core.ClusterService;
import co.paralleluniverse.galaxy.core.Comm;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.MessageReceiver;
import co.paralleluniverse.galaxy.core.NodeNotFoundException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComm<Address>
extends ClusterService
implements Comm,
NodeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComm.class);
    protected final NodeAddressResolver<Address> addressResolver;
    private final AtomicLong nextMessageId = new AtomicLong(1L);
    private final Cluster cluster;
    private MessageReceiver receiver;
    private long timeout = 200L;
    protected boolean sendToServerInsteadOfMulticast;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public AbstractComm(String name, Cluster cluster, NodeAddressResolver<Address> addressResolver) {
        super(name, cluster);
        this.addressResolver = addressResolver;
        this.cluster = cluster;
        cluster.addNodeChangeListener(this);
    }

    public void setSendToServerInsteadOfMulticast(boolean value) {
        this.assertDuringInitialization();
        this.sendToServerInsteadOfMulticast = value;
    }

    public boolean isSendToServerInsteadOfMulticast() {
        return this.sendToServerInsteadOfMulticast;
    }

    public void setTimeout(long milliseconds) {
        this.assertDuringInitialization();
        this.timeout = milliseconds;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setReceiver(MessageReceiver receiver) {
        this.assertDuringInitialization();
        this.receiver = receiver;
    }

    protected short getNode(Address address) {
        return this.addressResolver.getNodeId(address);
    }

    protected Address getNodeAddress(short node) {
        return this.addressResolver.getNodeAddress(node);
    }

    protected long nextMessageId() {
        return this.nextMessageId.getAndIncrement();
    }

    protected ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public void send(final Message message) throws NodeNotFoundException {
        assert (message.getMessageId() <= 0L ^ message.isResponse());
        message.setTimestamp(System.nanoTime());
        assert (message.isBroadcast() ^ message.getNode() >= 0);
        if (message.getNode() == this.cluster.getMyNodeId()) {
            this.scheduler.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractComm.this.receive(message);
                }
            });
            return;
        }
        if (this.getCluster().hasServer() && message.isBroadcast() && (this.sendToServerInsteadOfMulticast || message instanceof Message.LineMessage && Cache.isReserved(((Message.LineMessage)message).getLine()))) {
            message.setNode((short)0);
        }
        if (message.getNode() == 0) {
            this.sendToServer(message);
        } else if (message.getNode() >= 0) {
            this.sendToNode(message, message.getNode());
        } else {
            this.broadcast(message);
        }
    }

    protected void assignMessageId(Message message) {
        if (message.getMessageId() < 0L) {
            message.setMessageId(this.nextMessageId());
        }
    }

    protected void sendToServer(Message message) {
        this.assignMessageId(message);
        LOG.debug("Sending to server: {}", (Object)message);
    }

    protected void sendToNode(Message message, short node) throws NodeNotFoundException {
        Address address;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending to node {}: {}", (Object)node, (Object)message);
        }
        if ((address = this.getNodeAddress(node)) == null) {
            LOG.warn("Address not found for node {} while sending {}!", (Object)node, (Object)message);
            throw new NodeNotFoundException(node);
        }
        this.sendToNode(message, node, address);
    }

    protected abstract void sendToNode(Message var1, short var2, Address var3);

    protected abstract void broadcast(Message var1);

    protected final void receive(Message message) {
        if (this.getCluster().isMaster()) {
            this.receiver.receive(message);
        }
    }

    @Override
    public void nodeAdded(short id) {
    }

    @Override
    public void nodeSwitched(short id) {
    }

    @Override
    public void nodeRemoved(short id) {
    }
}

