/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.core.Backup;
import co.paralleluniverse.galaxy.core.Cache;
import co.paralleluniverse.galaxy.core.ClusterService;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.ServerComm;
import co.paralleluniverse.galaxy.core.SlaveComm;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Iterator;

public class BackupNullImpl
extends ClusterService
implements Backup {
    private Cache cache;

    @ConstructorProperties(value={"name", "cluster", "serverComm", "slaveComm"})
    public BackupNullImpl(String name, Cluster cluster, ServerComm serverComm, SlaveComm slaveComm) {
        super(name, cluster);
        if (slaveComm != null) {
            slaveComm.setBackup(this);
        }
    }

    @Override
    protected void postInit() throws Exception {
        this.setReady(true);
        super.postInit();
    }

    @Override
    protected void start(boolean master) {
    }

    @Override
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean inv(long id, short owner) {
        return true;
    }

    @Override
    public Iterator<Message.BACKUP> iterOwned() {
        return Collections.EMPTY_SET.iterator();
    }

    @Override
    public boolean startBackup() {
        return false;
    }

    @Override
    public void backup(long id, long version) {
        this.cache.receive(Message.BACKUPACK((short)0, id, version).setIncoming());
    }

    @Override
    public void endBackup(boolean locked) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void receive(Message message) {
    }

    @Override
    public void slavesAck(long id) {
    }

    @Override
    public void slavesInvAck(long id) {
    }
}

