/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.MonitoringType;
import co.paralleluniverse.common.io.Checksum;
import co.paralleluniverse.common.io.HashFunctionChecksum;
import co.paralleluniverse.common.io.Persistable;
import co.paralleluniverse.common.io.Persistables;
import co.paralleluniverse.common.io.VersionedPersistable;
import co.paralleluniverse.common.logging.LoggingUtils;
import co.paralleluniverse.common.util.DegenerateInvocationHandler;
import co.paralleluniverse.common.util.Enums;
import co.paralleluniverse.galaxy.CacheListener;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.ItemState;
import co.paralleluniverse.galaxy.LineFunction;
import co.paralleluniverse.galaxy.RefNotFoundException;
import co.paralleluniverse.galaxy.TimeoutException;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.core.AbstractComm;
import co.paralleluniverse.galaxy.core.Backup;
import co.paralleluniverse.galaxy.core.CacheMonitor;
import co.paralleluniverse.galaxy.core.CacheStorage;
import co.paralleluniverse.galaxy.core.ClusterService;
import co.paralleluniverse.galaxy.core.Comm;
import co.paralleluniverse.galaxy.core.CommThread;
import co.paralleluniverse.galaxy.core.IdAllocator;
import co.paralleluniverse.galaxy.core.JMXCacheMonitor;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.MessageReceiver;
import co.paralleluniverse.galaxy.core.MetricsCacheMonitor;
import co.paralleluniverse.galaxy.core.NodeNotFoundException;
import co.paralleluniverse.galaxy.core.Op;
import co.paralleluniverse.galaxy.core.RefAllocator;
import co.paralleluniverse.galaxy.core.ServerRefAllocator;
import co.paralleluniverse.galaxy.core.Transaction;
import com.google.common.base.Throwables;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import gnu.trove.TShortCollection;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.set.hash.TShortHashSet;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;

public class Cache
extends ClusterService
implements MessageReceiver,
NodeChangeListener,
co.paralleluniverse.galaxy.Cache {
    static final long MAX_RESERVED_REF_ID = 0xFFFFFFFFL;
    private static final boolean STALE_READS = true;
    private static final int SHARER_SET_DEFAULT_SIZE = 10;
    private static final Logger LOG = LoggerFactory.getLogger(Cache.class);
    private long timeout = 200000L;
    private int maxItemSize = 1024;
    private boolean compareBeforeWrite = true;
    private final Comm comm;
    private final Backup backup;
    private final CacheStorage storage;
    private final CacheMonitor monitor;
    private MessageReceiver receiver;
    private final boolean hasServer;
    private final NonBlockingHashMapLong<CacheLine> owned;
    private final ConcurrentMap<Long, CacheLine> shared;
    private final NonBlockingHashMapLong<ArrayList<Op>> pendingOps;
    private final NonBlockingHashMapLong<LinkedHashSet<Message.LineMessage>> pendingMessages;
    private ConcurrentLinkedDeque<CacheLine> freeLineList;
    private ConcurrentLinkedDeque<TShortHashSet> freeSharerSetList;
    private final ThreadLocal<Queue<Message>> shortCircuitMessage = new ThreadLocal();
    private boolean reuseLines = true;
    private boolean reuseSharerSets = false;
    private boolean broadcastsRoutedToServer;
    private boolean rollbackSupported = true;
    private boolean synchronous = false;
    private final Set<NodeEvent> nodeEvents = new CopyOnWriteArraySet<NodeEvent>();
    private long maxStaleReadMillis = 500L;
    private final IdAllocator idAllocator;
    private final NonBlockingHashMapLong<OwnerClock> ownerClocks;
    private final OwnerClock globalOwnerClock;
    private final AtomicLong clock = new AtomicLong();
    private final ThreadLocal<Boolean> recursive = new ThreadLocal();
    private final ThreadLocal<Boolean> inNodeEventHandler = new ThreadLocal();
    private final List<CacheListener> listeners = new CopyOnWriteArrayList<CacheListener>();
    static final Object PENDING = new Object(){

        public String toString() {
            return "PENDING";
        }
    };
    static final Object DIDNT_HANDLE = new Object();
    private static final int LINE_NO_CHANGE = 0;
    private static final int LINE_STATE_CHANGED = 1;
    private static final int LINE_OWNER_CHANGED = 2;
    private static final int LINE_MODIFIED_CHANGED = 4;
    private static final int LINE_EVERYTHING_CHANGED = -1;
    private static final long HIT_OR_MISS_OPS = Enums.setOf(Op.Type.GET, Op.Type.GETS, Op.Type.GETX, Op.Type.SET, Op.Type.DEL);
    private static final long FAST_TRACK_OPS = Enums.setOf(Op.Type.GET, Op.Type.GETS, Op.Type.GETX, Op.Type.SET, Op.Type.DEL, Op.Type.INVOKE, Op.Type.LSTN);
    private static final long LOCKING_OPS = Enums.setOf(Op.Type.GETS, Op.Type.GETX, Op.Type.SET, Op.Type.DEL);
    private static final long PUSH_OPS = Enums.setOf(Op.Type.PUSH, Op.Type.PUSHX);
    private static final long MESSAGES_BLOCKED_BY_LOCK = Enums.setOf(Message.Type.GET, Message.Type.GETX, Message.Type.INV, Message.Type.PUT, Message.Type.PUTX, Message.Type.INVOKE);
    private static final long MESSAGES_WITH_FAST_REPLY = Enums.setOf(Message.Type.GET, Message.Type.GETX, Message.Type.INVOKE);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final IrrelevantStateException IRRELEVANT_STATE = new IrrelevantStateException();
    static final Persistable NULL_PERSISTABLE = new Persistable(){

        @Override
        public int size() {
            throw new NullPointerException();
        }

        @Override
        public void write(ByteBuffer buffer) {
            throw new NullPointerException();
        }

        @Override
        public void read(ByteBuffer buffer) {
            throw new NullPointerException();
        }
    };
    private static final ClassValue<Boolean> isVoidLineFunction = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> type) {
            boolean res = Cache.isVoidLineFunction(type);
            return res;
        }
    };

    @ConstructorProperties(value={"name", "cluster", "comm", "storage", "backup", "monitoringType", "maxCapacity"})
    public Cache(String name, Cluster cluster, Comm comm, CacheStorage storage, Backup backup, MonitoringType monitoringType, long maxCapacity) {
        this(name, cluster, comm, storage, backup, Cache.createMonitor(monitoringType, name), maxCapacity);
    }

    Cache(String name, Cluster cluster, Comm comm, CacheStorage storage, Backup backup, CacheMonitor monitor, long maxCapacity) {
        super(name, cluster);
        this.comm = comm;
        this.storage = storage;
        this.hasServer = cluster.hasServer();
        this.monitor = monitor;
        this.backup = backup;
        this.idAllocator = new IdAllocator(this, this.hasServer ? new ServerRefAllocator(comm) : (RefAllocator)((Object)cluster));
        this.ownerClocks = new NonBlockingHashMapLong();
        this.globalOwnerClock = this.getOwnerClock((short)-1);
        this.monitor.setMonitoredObject(this);
        this.getCluster().addNodeChangeListener(this);
        this.comm.setReceiver(this);
        this.backup.setCache(this);
        this.owned = new NonBlockingHashMapLong();
        this.shared = this.buildSharedCache(maxCapacity);
        this.pendingOps = new NonBlockingHashMapLong();
        this.pendingMessages = new NonBlockingHashMapLong();
    }

    private ConcurrentMap<Long, CacheLine> buildSharedCache(long maxCapacity) {
        return new ConcurrentLinkedHashMap.Builder().initialCapacity(1000).maximumWeightedCapacity(maxCapacity).weigher((Weigher)new Weigher<CacheLine>(){

            public int weightOf(CacheLine line) {
                return 1 + line.size();
            }
        }).listener((EvictionListener)new EvictionListener<Long, CacheLine>(){

            public void onEviction(Long id, CacheLine line) {
                Cache.this.evictLine(line, true);
            }
        }).build();
    }

    static CacheMonitor createMonitor(MonitoringType monitoringType, String name) {
        if (monitoringType == null) {
            return (CacheMonitor)Proxy.newProxyInstance(Cache.class.getClassLoader(), new Class[]{CacheMonitor.class}, (InvocationHandler)DegenerateInvocationHandler.INSTANCE);
        }
        switch (monitoringType) {
            case JMX: {
                return new JMXCacheMonitor(name);
            }
            case METRICS: {
                return new MetricsCacheMonitor();
            }
        }
        throw new IllegalArgumentException("Unknown MonitoringType " + (Object)((Object)monitoringType));
    }

    public void setCompareBeforeWrite(boolean value) {
        this.assertDuringInitialization();
        this.compareBeforeWrite = value;
    }

    @ManagedAttribute
    public boolean isCompareBeforeWrite() {
        return this.compareBeforeWrite;
    }

    public void setMaxItemSize(int maxItemSize) {
        this.assertDuringInitialization();
        this.maxItemSize = maxItemSize;
    }

    @ManagedAttribute
    public int getMaxItemSize() {
        return this.maxItemSize;
    }

    public void setTimeout(long timeout) {
        this.assertDuringInitialization();
        this.timeout = timeout;
    }

    @ManagedAttribute
    public long getTimeout() {
        return this.timeout;
    }

    public void setReuseLines(boolean value) {
        this.assertDuringInitialization();
        this.reuseLines = value;
    }

    @ManagedAttribute
    public boolean isReuseLines() {
        return this.reuseLines;
    }

    public void setReuseSharerSets(boolean value) {
        this.assertDuringInitialization();
        this.reuseSharerSets = value;
    }

    @ManagedAttribute
    public boolean isReuseSharerSets() {
        return this.reuseSharerSets;
    }

    public void setRollbackSupported(boolean value) {
        this.assertDuringInitialization();
        this.rollbackSupported = value;
    }

    public void setSynchronous(boolean value) {
        this.assertDuringInitialization();
        this.synchronous = value;
    }

    @ManagedAttribute
    public boolean isRollbackSupported() {
        return this.rollbackSupported;
    }

    private Checksum getChecksum() {
        assert (this.compareBeforeWrite);
        return new HashFunctionChecksum(Hashing.murmur3_128());
    }

    public long getMaxStaleReadMillis() {
        this.assertDuringInitialization();
        return this.maxStaleReadMillis;
    }

    @ManagedAttribute
    public void setMaxStaleReadMillis(long maxStaleReadMillis) {
        this.maxStaleReadMillis = maxStaleReadMillis;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.synchronous) {
            throw new RuntimeException("Synchronous mode has not been implemented yet.");
        }
        this.freeLineList = this.reuseLines ? new ConcurrentLinkedDeque() : null;
        this.freeSharerSetList = this.reuseSharerSets ? new ConcurrentLinkedDeque() : null;
        this.broadcastsRoutedToServer = this.hasServer && ((AbstractComm)this.comm).isSendToServerInsteadOfMulticast();
    }

    void allocatorReady() {
        LOG.info("Id allocator is ready");
        if (this.getCluster().isOnline() && this.getCluster().isMaster()) {
            this.setReady(true);
        }
    }

    @Override
    protected void start(boolean master) {
        if (this.idAllocator.isReady()) {
            this.setReady(true);
        }
    }

    @Override
    public void awaitAvailable() throws InterruptedException {
        super.awaitAvailable();
    }

    public void setReceiver(MessageReceiver receiver) {
        this.assertDuringInitialization();
        this.receiver = receiver;
    }

    public boolean hasServer() {
        return this.hasServer;
    }

    public void addCacheListener(CacheListener listener) {
        this.listeners.add(listener);
    }

    public void removeCacheListener(CacheListener listener) {
        this.listeners.remove(listener);
    }

    Iterator<CacheLine> ownedIterator() {
        return this.owned.values().iterator();
    }

    RefAllocator getRefAllocator() {
        return this.idAllocator.getRefAllocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryLock(long id, ItemState state, Transaction txn) {
        CacheLine line = this.getLine(id);
        if (line == null) {
            return false;
        }
        CacheLine cacheLine = line;
        synchronized (cacheLine) {
            if (state == ItemState.OWNED & line.getState() == State.E | state == ItemState.SHARED & !line.getState().isLessThan(State.S)) {
                this.lockLine(line, txn);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(long id) {
        CacheLine line = this.getLine(id);
        if (line == null) {
            return false;
        }
        CacheLine cacheLine = line;
        synchronized (cacheLine) {
            return line.isLocked();
        }
    }

    State getState(long id) {
        CacheLine line = this.getLine(id);
        if (line == null) {
            return null;
        }
        return line.getState();
    }

    public long getVersion(long id) {
        CacheLine line = this.getLine(id);
        if (line == null) {
            return -1L;
        }
        return line.getVersion();
    }

    private CacheListener setListener(long id, CacheListener listener, boolean ifAbsent) {
        try {
            return (CacheListener)this.doOp(Op.Type.LSTN, id, ifAbsent, listener, null);
        }
        catch (TimeoutException e) {
            throw new AssertionError();
        }
    }

    @Override
    public CacheListener setListenerIfAbsent(long id, CacheListener listener) {
        return this.setListener(id, listener, true);
    }

    @Override
    public void setListener(long id, CacheListener listener) {
        this.setListener(id, listener, false);
    }

    @Override
    public CacheListener getListener(long id) {
        CacheLine line = this.getLine(id);
        if (line == null) {
            return null;
        }
        return line.getListener();
    }

    public Object doOp(Op.Type type, long id, Object data, Object extra, Transaction txn) throws TimeoutException {
        Object result;
        if (!this.getCluster().isMaster() && type != Op.Type.LSTN) {
            throw new IllegalStateException("Node is a slave. Cannot run grid operations");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Run(fast): Op.{}(line:{}{}{})", new Object[]{type, LoggingUtils.hex(id), data != null ? ", data:" + data : "", extra != null ? ", extra:" + extra : ""});
        }
        if ((result = this.runFastTrack(id, type, data, extra, txn)) instanceof Op) {
            return this.doOp((Op)result);
        }
        if (result == PENDING) {
            if (Thread.currentThread() instanceof CommThread) {
                throw new RuntimeException("This operation blocks a comm thread.");
            }
            return this.doOp(new Op(type, id, data, extra, txn));
        }
        return result;
    }

    public ListenableFuture<Object> doOpAsync(Op.Type type, long id, Object data, Object extra, Transaction txn) {
        Object result;
        if (!this.getCluster().isMaster()) {
            throw new IllegalStateException("Node is a slave. Cannot run grid operations");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Run(fast): Op.{}(line:{}{}{})", new Object[]{type, LoggingUtils.hex(id), data != null ? ", data:" + data : "", extra != null ? ", extra:" + extra : ""});
        }
        if ((result = this.runFastTrack(id, type, data, extra, txn)) instanceof Op) {
            return this.doOpAsync((Op)result);
        }
        if (result == PENDING) {
            return this.doOpAsync(new Op(type, id, data, extra, txn));
        }
        return Futures.immediateFuture((Object)result);
    }

    private Object doOp(Op op) throws TimeoutException {
        try {
            Object result;
            if (op.txn != null) {
                op.txn.add(op);
            }
            if ((result = this.runOp(op)) == PENDING) {
                return op.getResult(this.timeout, TimeUnit.MILLISECONDS);
            }
            if (result == null && op.isCancelled()) {
                throw new CancellationException();
            }
            return result;
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            Throwable ex = e.getCause();
            if (ex instanceof TimeoutException) {
                throw (TimeoutException)ex;
            }
            Throwables.propagateIfPossible((Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private ListenableFuture<Object> doOpAsync(Op op) {
        Object result;
        if (op.txn != null) {
            op.txn.add(op);
        }
        if ((result = this.runOp(op)) == PENDING) {
            return op.getFuture();
        }
        return Futures.immediateFuture((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runFastTrack(long id, Op.Type type, Object data, Object extra, Transaction txn) {
        Object res;
        if (!type.isOf(FAST_TRACK_OPS)) {
            return PENDING;
        }
        CacheLine line = this.getLine(id);
        if (line == null) {
            res = this.handleOpNoLine(type, id, extra);
            if (res != DIDNT_HANDLE) {
                return res;
            }
            line = this.createNewCacheLine(id);
        }
        CacheLine cacheLine = line;
        synchronized (cacheLine) {
            res = this.handleOp(line, type, data, extra, txn, false, -1, null);
        }
        if (res != PENDING) {
            this.monitor.addOp(type, 0L);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object runOp(Op op) {
        LOG.debug("Run: {}", (Object)op);
        this.recursive.set(Boolean.TRUE);
        try {
            Object res;
            if (op.type == Op.Type.PUT || op.type == Op.Type.ALLOC) {
                Object object = this.execOp(op, null);
                return object;
            }
            long id = op.line;
            CacheLine line = this.getLine(id);
            if (line == null) {
                res = this.handleOpNoLine(op.type, op.line, op.getExtra());
                if (res != DIDNT_HANDLE) {
                    Object object = res;
                    return object;
                }
                line = this.createNewCacheLine(op);
            }
            Object object = line;
            synchronized (object) {
                res = this.execOp(op, line);
            }
            this.receiveShortCircuit();
            if (res instanceof Op) {
                object = this.runOp((Op)res);
                return object;
            }
            object = res;
            return object;
        }
        finally {
            this.recursive.remove();
        }
    }

    private Object execOp(Op op, CacheLine line) {
        Object res;
        try {
            res = this.handleOp(line, op, false, -1);
        }
        catch (Throwable t) {
            if (op.hasFuture()) {
                op.setException(t);
                return null;
            }
            return Throwables.propagate((Throwable)t);
        }
        if (res == PENDING) {
            op.setStartTime(System.nanoTime());
            LOG.debug("Adding op to pending {} on line {}", (Object)op, (Object)line);
            this.addPendingOp(line, op);
        }
        return res;
    }

    private Object handleOp(CacheLine line, Op op, boolean pending, int lineChange) {
        LOG.debug("handleOp: {} line: {}", (Object)op, (Object)line);
        if (op.isCancelled()) {
            LOG.debug("handleOp: {} line: {}: CANCELLED", (Object)op, (Object)line);
            return null;
        }
        try {
            Object res;
            switch (op.type) {
                case PUT: {
                    res = this.handleOpPut(op, line);
                    break;
                }
                case ALLOC: {
                    res = this.handleOpAlloc(op, line);
                    break;
                }
                default: {
                    res = this.handleOp(line, op.type, op.data, op.getExtra(), op.txn, pending, lineChange, op);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleOp: {} -> {} line: {}", new Object[]{op, res instanceof byte[] ? "(" + ((byte[])res).length + " bytes)" : res, line});
            }
            if (res == PENDING) {
                return res;
            }
            if (res instanceof Op) {
                return res;
            }
            this.completeOp(line, op, res, pending);
            return res;
        }
        catch (Exception e) {
            this.opException(line, op, e, pending);
            return null;
        }
    }

    private Object handleOp(CacheLine line, Op.Type type, Object data, Object extra, Transaction txn, boolean pending, int lineChange, Op op) {
        assert (line != null || type == Op.Type.PUT || type == Op.Type.ALLOC);
        this.handleNodeEvents(line);
        Object res = null;
        if (line != null && this.shouldHoldOp(line, type)) {
            res = PENDING;
        } else {
            switch (type) {
                case GET: 
                case GETS: {
                    res = this.handleOpGet(line, type, data, Cache.nodeHint(extra), txn, lineChange);
                    break;
                }
                case GETX: {
                    res = this.handleOpGetX(line, data, Cache.nodeHint(extra), txn, lineChange, pending);
                    break;
                }
                case GET_FROM_OWNER: {
                    res = this.handleOpGetFromOwner(line, extra);
                    break;
                }
                case SET: {
                    res = this.handleOpSet(line, data, Cache.nodeHint(extra), txn, lineChange);
                    break;
                }
                case DEL: {
                    res = this.handleOpDel(line, Cache.nodeHint(extra), txn, lineChange);
                    break;
                }
                case SEND: {
                    res = this.handleOpSend(line, extra, lineChange);
                    break;
                }
                case PUSH: {
                    res = this.handleOpPush(line, extra, lineChange);
                    break;
                }
                case PUSHX: {
                    res = this.handleOpPushX(line, extra, lineChange);
                    break;
                }
                case LSTN: {
                    res = this.handleOpListen(line, data, extra);
                    break;
                }
                case INVOKE: {
                    res = this.handleOpInvoke(line, data, op, extra, txn, lineChange);
                }
            }
            this.accessLine(line);
        }
        if (!pending && type.isOf(HIT_OR_MISS_OPS) && res != PENDING) {
            if (line.getState() == State.I) {
                this.monitor.addStaleHit();
            } else {
                this.monitor.addHit();
            }
        }
        return res;
    }

    private void completeOp(CacheLine line, Op op, Object res, boolean pending) {
        long duration = 0L;
        if (pending) {
            assert (op.getStartTime() != 0L);
            duration = (System.nanoTime() - op.getStartTime()) / 1000L;
        }
        if (op.hasFuture()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("completeOp: {} -> {} line: {}", new Object[]{op, res instanceof byte[] ? "(" + ((byte[])res).length + " bytes)" : res, line});
            }
            op.setResult(res);
        }
        this.monitor.addOp(op.type, duration);
    }

    private void opException(CacheLine line, Op op, Throwable t, boolean pending) {
        if (pending) {
            if (!op.hasFuture()) {
                op.createFuture();
            }
        } else {
            throw Throwables.propagate((Throwable)t);
        }
        op.setException(t);
    }

    protected Object handleOpNoLine(Op.Type type, long id, Object extra) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Line {} not found.", (Object)LoggingUtils.hex(id));
        }
        switch (type) {
            case GET_FROM_OWNER: {
                return extra;
            }
            case PUSH: 
            case PUSHX: {
                LOG.info("Attempt to push line {}, but line is not in cache. ", (Object)LoggingUtils.hex(id));
                return null;
            }
        }
        return DIDNT_HANDLE;
    }

    private boolean shouldHoldOp(CacheLine line, Op.Type op) {
        return this.hasPendingBlockingMessages(line) && op.isOf(LOCKING_OPS) && !line.isLocked() && (line.getState() == State.E || line.getNextState() != State.E) || line.is((byte)2) && op.isOf(PUSH_OPS);
    }

    private void handlePendingOps(CacheLine line, int change) {
        if (line == null) {
            return;
        }
        Iterator<Op> it = this.getPendingOps(line).iterator();
        while (it.hasNext()) {
            Op op = it.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Handling pending op {}, change = {}", (Object)op, (Object)change);
            }
            if (this.handleOp(line, op, true, change) == PENDING) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message message) {
        if (this.recursive.get() != Boolean.TRUE) {
            this.recursive.set(Boolean.TRUE);
            try {
                LOG.debug("Received: {}", (Object)message);
                this.receive1(message);
                this.receiveShortCircuit();
            }
            finally {
                this.recursive.remove();
            }
        } else {
            LOG.debug("Received short-circuit: {}", (Object)message);
            Queue<Message> ms = this.shortCircuitMessage.get();
            if (ms == null) {
                ms = new ArrayDeque<Message>();
                this.shortCircuitMessage.set(ms);
            }
            ms.add(message);
        }
    }

    private void receive1(Message message) {
        switch (message.getType()) {
            case MSG: {
                if (!this.handleMessageMessengerMsg((Message.MSG)message)) break;
                return;
            }
            case MSGACK: {
                if (((Message.LineMessage)message).getLine() != -1L) break;
                if (this.receiver != null) {
                    this.receiver.receive(message);
                }
                return;
            }
            case BACKUP_PACKETACK: {
                this.backup.receive(message);
                return;
            }
            case ALLOCED_REF: {
                if (!(this.idAllocator.getRefAllocator() instanceof MessageReceiver)) break;
                ((MessageReceiver)((Object)this.idAllocator.getRefAllocator())).receive(message);
                return;
            }
        }
        this.runMessage((Message.LineMessage)message);
        this.monitor.addMessageReceived(message.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMessage(Message.LineMessage message) {
        long id = message.getLine();
        CacheLine line = this.getLine(id);
        if (LOG.isDebugEnabled()) {
            LOG.debug("runMessage: {} {} {}", new Object[]{line, LoggingUtils.hex(id), message});
        }
        if (line == null) {
            if (this.handleMessageNoLine(message)) {
                return;
            }
            line = this.createNewCacheLine(message);
        }
        CacheLine cacheLine = line;
        synchronized (cacheLine) {
            this.handleMessage(message, line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMessageMessengerMsg(Message.MSG message) {
        if (!message.isMessenger()) {
            return false;
        }
        if (this.receiver == null) {
            return true;
        }
        this.setOwnerClockPut(message);
        if (message.getLine() == -1L) {
            this.receiver.receive(message);
            if (message.isReplyRequired()) {
                this.send(Message.MSGACK(message));
            }
            return true;
        }
        CacheLine line = this.getLine(message.getLine());
        if (line == null) {
            boolean res = this.handleMessageNoLine(message);
            assert (res);
            return true;
        }
        CacheLine cacheLine = line;
        synchronized (cacheLine) {
            if (this.handleNotOwner(message, line)) {
                return true;
            }
            this.receiver.receive(message);
        }
        if (message.isReplyRequired()) {
            this.send(Message.MSGACK(message));
        }
        return true;
    }

    private void handleMessage(Message.LineMessage message, CacheLine line) {
        assert (line != null);
        this.handleNodeEvents(line);
        int change = this.handleMessage1(message, line);
        this.handlePendingOps(line, change);
        this.handlePendingMessagesAfterMessage(line, change);
    }

    private int handleMessage1(Message.LineMessage message, CacheLine line) {
        if (this.shouldHoldMessage(line, message)) {
            if (message.isBroadcast() && this.quickReplyToBroadcast(line, message)) {
                LOG.debug("quickReplyToBroadcast {}", (Object)message);
            } else {
                LOG.debug("Adding message to pending {} on line {}", (Object)message, (Object)line);
                this.addPendingMessage(line, message);
            }
            if (line.is((byte)2)) {
                this.backup.flush();
            }
            return 0;
        }
        this.accessLine(line);
        try {
            switch (message.getType()) {
                case PUT: {
                    return this.handleMessagePut((Message.PUT)message, line);
                }
                case PUTX: {
                    return this.handleMessagePutX((Message.PUTX)message, line);
                }
                case GET: {
                    return this.handleMessageGet((Message.GET)message, line);
                }
                case GETX: {
                    return this.handleMessageGetX((Message.GET)message, line);
                }
                case INV: {
                    return this.handleMessageInvalidate((Message.INV)message, line);
                }
                case INVACK: {
                    return this.handleMessageInvalidateAck(message, line);
                }
                case NOT_FOUND: {
                    return this.handleMessageNotFound(message, line);
                }
                case CHNGD_OWNR: {
                    return this.handleMessageChngdOwnr((Message.CHNGD_OWNR)message, line);
                }
                case MSG: {
                    return this.handleMessageMsg((Message.MSG)message, line);
                }
                case MSGACK: {
                    return this.handleMessageMsgAck(message, line);
                }
                case BACKUP: {
                    return this.handleMessageBackup((Message.PUT)message, line);
                }
                case BACKUPACK: {
                    return this.handleMessageBackupAck((Message.BACKUPACK)message, line);
                }
                case TIMEOUT: {
                    return this.handleMessageTimeout(message, line);
                }
                case INVOKE: {
                    return this.handleMessageInvoke((Message.INVOKE)message, line);
                }
                case INVRES: {
                    return this.handleMessageInvRes((Message.INVRES)message, line);
                }
            }
            LOG.warn("Unhandled message {}", (Object)message);
            return 0;
        }
        catch (IrrelevantStateException e) {
            if (message.getType() != Message.Type.CHNGD_OWNR) {
                LOG.warn("Got message {} when at irrelevant state {}", (Object)message, (Object)line.state);
            }
            return 0;
        }
    }

    protected boolean handleMessageNoLine(Message.LineMessage message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Line {} not found.", (Object)LoggingUtils.hex(message.getLine()));
        }
        switch (message.getType()) {
            case INV: {
                this.send(Message.INVACK((Message.INV)message));
                return true;
            }
            case INVACK: {
                return true;
            }
            case MSG: 
            case GET: 
            case GETX: {
                this.handleNotOwner(message, null);
                return true;
            }
        }
        return false;
    }

    private boolean handleNotOwner(Message.LineMessage msg, CacheLine line) {
        if (line != null && line.is((byte)8)) {
            this.send(Message.NOT_FOUND(msg));
            return true;
        }
        if (line == null || line.state == State.I || line.state == State.S) {
            boolean certain;
            short owner;
            long id;
            if (line == null) {
                id = msg.getLine();
                owner = -1;
                certain = false;
            } else {
                id = line.getId();
                owner = line.getOwner();
                boolean bl = certain = line.state == State.S;
            }
            if (certain || !msg.isBroadcast()) {
                this.send(Message.CHNGD_OWNR(msg, id, owner, certain));
            } else if (msg.isBroadcast()) {
                this.send(Message.ACK(msg));
            }
            return true;
        }
        return false;
    }

    private int handlePendingMessages(CacheLine line, CacheMonitor.MessageDelayReason reason) {
        Iterator it;
        int change = 0;
        long now = System.nanoTime();
        int messageCount = 0;
        long totalDelay = 0L;
        Set<Message.LineMessage> pending = this.getPendingMessages(line);
        int n = pending.size();
        for (int i = 0; i < n && (it = pending.iterator()).hasNext(); ++i) {
            Message.LineMessage msg = (Message.LineMessage)it.next();
            it.remove();
            LOG.debug("Handling pending message {}", (Object)msg);
            change |= this.handleMessage1(msg, line);
            ++messageCount;
            totalDelay += now - msg.getTimestamp();
        }
        if (messageCount > 0) {
            this.monitor.addMessageHandlingDelay(messageCount, totalDelay, reason);
        }
        if (change != 0) {
            this.handlePendingOps(line, change);
            this.handlePendingMessagesAfterMessage(line, change);
        }
        return change;
    }

    private boolean shouldHoldMessage(CacheLine line, Message message) {
        boolean res;
        boolean bl = res = message.getType().isOf(MESSAGES_BLOCKED_BY_LOCK) && (line.isLocked() || line.is((byte)2) || line.isIncomplete() || line.getState() != State.E && line.getNextState() == State.E);
        if (res && message.getType() == Message.Type.INV && !line.isLocked() && !line.is((byte)2)) {
            return false;
        }
        return res;
    }

    private boolean quickReplyToBroadcast(CacheLine line, Message.LineMessage msg) {
        assert (msg.isBroadcast());
        if (!msg.getType().isOf(MESSAGES_WITH_FAST_REPLY)) {
            return false;
        }
        if (line.state == State.O || line.state == State.E) {
            this.send(Message.CHNGD_OWNR(msg, line.getId(), this.myNodeId(), true));
            return true;
        }
        return false;
    }

    private void handlePendingMessagesAfterMessage(CacheLine line, int change) {
        if (!line.isLocked() && !line.is((byte)2)) {
            CacheMonitor.MessageDelayReason reason = null;
            if ((change & 4) != 0) {
                reason = CacheMonitor.MessageDelayReason.BACKUP;
            } else if ((change & 1) != 0) {
                reason = CacheMonitor.MessageDelayReason.OTHER;
            }
            if (reason != null) {
                this.handlePendingMessages(line, reason);
            }
        }
    }

    public void send(Message.MSG message) {
        this.send((Message)message);
        this.monitor.addOp(Op.Type.SEND, 0L);
    }

    public Transaction beginTransaction() {
        Transaction txn = new Transaction(this.rollbackSupported);
        LOG.debug("Starting transaction: {}", (Object)txn);
        return txn;
    }

    public void rollback(Transaction txn) {
        if (!this.rollbackSupported) {
            throw new IllegalStateException("Cache nconfigured to not support rollbacks");
        }
        txn.forEachRollback(new TLongObjectProcedure<Transaction.RollbackInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(long id, Transaction.RollbackInfo r) {
                CacheLine line;
                CacheLine cacheLine = line = Cache.this.getLine(id);
                synchronized (cacheLine) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Rolling back line {} to version {}. Modified = {}", new Object[]{LoggingUtils.hex(line.getId()), r.version, r.modified});
                    }
                    line.version = r.version;
                    line.set((byte)2, r.modified);
                    Cache.this.writeData(line, r.data);
                    return true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTransaction(Transaction txn, boolean abort) throws InterruptedException {
        LOG.debug("Ending transaction: {} {}", (Object)txn, (Object)(abort ? "ABORT" : "COMMIT"));
        Throwable ex = null;
        for (Op op : txn.getOps()) {
            try {
                if (!op.hasFuture()) continue;
                op.getResult();
            }
            catch (Throwable e) {
                LOG.debug("Error in op: " + op, e);
                if (ex != null) continue;
                ex = e;
            }
        }
        boolean flush = false;
        ArrayList<CacheLine> unmodified = new ArrayList<CacheLine>();
        boolean locked = this.backup.startBackup();
        try {
            for (long id : txn.getLines()) {
                CacheLine line = this.getLine(id);
                LOG.debug("Ending transaction: {}, line {}", (Object)txn, (Object)line);
                CacheLine cacheLine = line;
                synchronized (cacheLine) {
                    if (this.unlockLine(line, txn)) {
                        if (!line.is((byte)2)) {
                            unmodified.add(line);
                        } else {
                            line.set((byte)4, true);
                            this.backup.backup(line.getId(), line.getVersion());
                            if (this.hasPendingMessages(line)) {
                                flush = true;
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.backup.endBackup(locked);
        }
        if (flush) {
            this.backup.flush();
        }
        Iterator i$ = unmodified.iterator();
        while (i$.hasNext()) {
            CacheLine line;
            CacheLine cacheLine = line = (CacheLine)i$.next();
            synchronized (cacheLine) {
                this.handlePendingMessages(line, CacheMonitor.MessageDelayReason.LOCK);
            }
        }
        if (!abort && ex != null) {
            if (ex instanceof ExecutionException) {
                ex = ex.getCause();
            }
            Throwables.propagateIfPossible((Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long id) {
        CacheLine line = this.getLine(id);
        boolean bckp = false;
        boolean locked = this.backup.startBackup();
        try {
            CacheLine cacheLine = line;
            synchronized (cacheLine) {
                if (this.unlockLine(line, null)) {
                    if (!line.is((byte)2)) {
                        this.handlePendingMessages(line, CacheMonitor.MessageDelayReason.LOCK);
                    } else {
                        bckp = true;
                        this.backupLine(line);
                    }
                }
            }
        }
        finally {
            this.backup.endBackup(locked);
        }
        if (bckp && this.hasPendingMessages(line)) {
            this.backup.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelOp(Op op) {
        CacheLine line = this.getLine(op.line);
        if (line == null) {
            return false;
        }
        CacheLine cacheLine = line;
        synchronized (cacheLine) {
            boolean completed = op.isCompleted();
            if (!completed) {
                op.setCancelled();
                this.removePendingOp(line, op);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelling op {} on line {}: {}", new Object[]{op, line, completed ? "FAILED" : "SUCCESS"});
            }
            return !completed;
        }
    }

    private void backupLine(CacheLine line) {
        line.set((byte)4, true);
        this.backup.backup(line.getId(), line.getVersion());
    }

    private Object handleOpGet(CacheLine line, Op.Type type, Object data, short nodeHint, Transaction txn, int change) {
        if ((change & (3 | (this.synchronous ? 4 : 0))) == 0) {
            return PENDING;
        }
        if (line.is((byte)8)) {
            this.handleDeleted(line);
        }
        if (!this.transitionToS(line, nodeHint)) {
            if (type != Op.Type.GETS && line.version > 0L && !this.isPossibleInconsistencies(line)) {
                if (data != null) {
                    this.readData(line, (Persistable)data);
                    return null;
                }
                return this.readData(line);
            }
            return PENDING;
        }
        if (type == Op.Type.GETS) {
            this.lockLine(line, txn);
        }
        if (data != null) {
            this.readData(line, (Persistable)data);
            return null;
        }
        return this.readData(line);
    }

    private Object handleOpGetX(CacheLine line, Object data, short nodeHint, Transaction txn, int change, boolean pending) {
        if ((change & 3) == 0) {
            return PENDING;
        }
        if (line.is((byte)8)) {
            this.handleDeleted(line);
        }
        if (!pending) {
            this.verifyNoUpgrade(line);
        }
        if (!this.transitionToE(line, nodeHint)) {
            return PENDING;
        }
        this.lockLine(line, txn);
        if (data != null) {
            this.readData(line, (Persistable)data);
            return null;
        }
        return this.readData(line);
    }

    private boolean verifyNoUpgrade(CacheLine line) {
        if (line.isLocked() && line.getState() == State.S) {
            IllegalStateException e = new IllegalStateException("Can't upgrade to X. Line " + line + " is pinned S");
            LOG.error("Attempt to upgrade line " + line + " from S to X. Line is pinned S.", (Throwable)e);
            throw e;
        }
        if (this.hasPendingOp(line, Op.Type.GETS)) {
            IllegalStateException e = new IllegalStateException("Can't upgrade to X. Line " + line + " has a pending gets operation.");
            LOG.error("Attempt to upgrade line " + line + " from S to X. Line is pinned S.", (Throwable)e);
            throw e;
        }
        return true;
    }

    private Object handleOpGetFromOwner(CacheLine line, Object extra) {
        Op get = (Op)extra;
        short owner = line.getOwner();
        if (owner >= 0) {
            get.setExtra(owner);
        }
        return get;
    }

    private boolean transitionToS(CacheLine line, short nodeHint) {
        if (line.state.isLessThan(State.S)) {
            if (this.setNextState(line, State.S)) {
                this.send(Message.GET(Cache.getTarget(line, nodeHint), line.id));
            }
            return false;
        }
        return true;
    }

    private boolean transitionToO(CacheLine line, short nodeHint) {
        if (line.state.isLessThan(State.O)) {
            if (this.setNextState(line, State.O)) {
                this.send(Message.GETX(Cache.getTarget(line, nodeHint), line.id));
            }
            return false;
        }
        return true;
    }

    private boolean transitionToE(CacheLine line, short nodeHint) {
        boolean res;
        if (!this.transitionToO(line, nodeHint)) {
            return false;
        }
        assert (!line.state.isLessThan(State.O));
        if (line.state.isLessThan(State.E)) {
            if (this.setNextState(line, State.E)) {
                assert (!line.sharers.isEmpty());
                for (short sharer : line.sharers) {
                    if (sharer == 0) continue;
                    this.send(Message.INV(sharer, line.getId(), line.getOwner()));
                }
            }
            res = false;
        } else {
            res = true;
        }
        if (res) {
            line.set((byte)2, true);
        }
        return res;
    }

    private Object handleOpSet(CacheLine line, Object data, short nodeHint, Transaction txn, int change) {
        if ((change & 3) == 0) {
            return PENDING;
        }
        if (line.is((byte)8)) {
            this.handleDeleted(line);
        }
        if (!this.transitionToE(line, nodeHint)) {
            return PENDING;
        }
        this.setData(line, data, txn);
        if (txn == null && !line.isLocked()) {
            this.backupLine(line);
        }
        return null;
    }

    private void handleDeleted(CacheLine line) {
        if (!Cache.isReserved(line.getId())) {
            throw new RefNotFoundException(line.getId());
        }
        line.set((byte)8, false);
        this.setState(line, State.E);
    }

    private Object handleOpPut(Op op, CacheLine line) {
        assert (line == null);
        long id = this.idAllocator.allocateIds(op, 1);
        if (id == -1L) {
            return PENDING;
        }
        line = this.allocateCacheLine();
        line.id = id;
        this.setState(line, State.E);
        this.setOwner(line, this.myNodeId());
        this.setData(line, op.data, op.txn);
        this.lockLine(line, op.txn);
        this.putLine(id, line, 0, line.size());
        return id;
    }

    private Object handleOpAlloc(Op op, CacheLine line) {
        assert (line == null);
        int count = (Integer)op.getExtra();
        long id = this.idAllocator.allocateIds(op, count);
        if (id == -1L) {
            return PENDING;
        }
        for (int i = 0; i < count; ++i) {
            line = this.allocateCacheLine();
            line.id = id + (long)i;
            this.setState(line, State.E);
            this.setOwner(line, this.myNodeId());
            this.setData(line, null, op.txn);
            this.lockLine(line, op.txn);
            this.putLine(id + (long)i, line, 0, line.size());
        }
        return id;
    }

    private Object handleOpDel(CacheLine line, short nodeHint, Transaction txn, int change) {
        if ((change & 3) == 0) {
            return PENDING;
        }
        if (!this.transitionToE(line, nodeHint)) {
            return PENDING;
        }
        long id = line.getId();
        line.set((byte)8, true);
        if (this.hasServer()) {
            if (line.state == State.E) {
                this.setState(line, State.O);
            }
            line.sharers.add((short)0);
            this.send(Message.DEL((short)0, id));
        } else {
            this.setState(line, State.I);
        }
        this.deallocateStorage(id, line.data);
        this.fireLineEvicted(line);
        return null;
    }

    private Object handleOpSend(CacheLine line, Object extra, int change) {
        if (line.is((byte)8)) {
            this.handleDeleted(line);
        }
        if ((change & 2) == 0) {
            return PENDING;
        }
        Message.MSG msg = (Message.MSG)extra;
        if (msg.getNode() != -1 && msg.getNode() == line.getOwner()) {
            return PENDING;
        }
        if (!line.getState().isLessThan(State.O)) {
            msg.setNode(this.myNodeId());
            msg.setReplyRequired(false);
            msg.setIncoming();
            this.receive(msg);
            return null;
        }
        Message.MSG msg1 = Message.MSG(line.getOwner(), msg.getLine(), msg.isMessenger(), msg.getData());
        this.send((Message)msg1);
        assert (msg1.getMessageId() > 0L);
        msg.setMessageId(msg1.getMessageId());
        return PENDING;
    }

    private Object handleOpPush(CacheLine line, Object extra, int change) {
        if ((change & 4) == 0) {
            assert (line.is((byte)2));
            return PENDING;
        }
        if (line.getState().isLessThan(State.O)) {
            LOG.info("Attempt to push line {} while state is only {}", (Object)LoggingUtils.hex(line.getId()), (Object)line.getState());
            return null;
        }
        this.setState(line, State.O);
        short[] toNodes = (short[])extra;
        line.sharers.addAll(toNodes);
        for (short node : toNodes) {
            this.send(Message.PUT(node, line.id, line.version, Cache.readOnly(line.data)));
            line.rewind();
        }
        return null;
    }

    private Object handleOpPushX(CacheLine line, Object extra, int change) {
        if ((change & 4) == 0) {
            assert (line.is((byte)2));
            return PENDING;
        }
        if (line.getState().isLessThan(State.E)) {
            LOG.info("Attempt to push line {} while state is only {}", (Object)line.getId(), (Object)line.getState());
            return null;
        }
        short toNode = (Short)extra;
        this.setOwner(line, toNode);
        short[] sharers = line.sharers.toArray();
        this.setState(line, State.I);
        List<Message.MSG> pendingMSGs = this.getAndClearPendingMSGs(line);
        this.send(Message.PUTX(toNode, line.id, sharers, pendingMSGs.size(), line.version, Cache.readOnly(line.data)));
        line.rewind();
        for (Message.MSG m : this.getAndClearPendingMSGs(line)) {
            m = Cache.toOutgoing(m, toNode);
            m.setPending(true);
            m.setReplyRequired(false);
            this.send(m);
        }
        this.fireLineInvalidated(line);
        return null;
    }

    private CacheListener handleOpListen(CacheLine line, Object data, Object listener) {
        boolean ifAbsent = (Boolean)(data != null ? data : Boolean.valueOf(false));
        CacheListener lst = line.setListener((CacheListener)listener, ifAbsent);
        if (lst != null && lst == listener) {
            for (Message.MSG msg : this.getAndClearPendingMSGs(line)) {
                this.handleMessageMsg(msg, line);
            }
        }
        return lst;
    }

    private List<Message.MSG> getAndClearPendingMSGs(CacheLine line) {
        ArrayList<Message.MSG> ms = new ArrayList<Message.MSG>();
        Set<Message.LineMessage> msgs = this.getPendingMessages(line);
        Iterator it = msgs.iterator();
        while (it.hasNext()) {
            Message.LineMessage msg = (Message.LineMessage)it.next();
            if (msg.getType() != Message.Type.MSG) continue;
            ms.add((Message.MSG)msg);
            it.remove();
        }
        return ms;
    }

    private Object handleOpInvoke(CacheLine line, Object function, Op op, Object extra, Transaction txn, int lineChange) {
        if ((lineChange & 3) == 0) {
            return PENDING;
        }
        if (line.is((byte)8)) {
            this.handleDeleted(line);
        }
        LineFunction f = (LineFunction)function;
        if (line.state.isLessThan(State.O)) {
            if (op != null) {
                short nodeHint = extra instanceof Short ? (short)Cache.nodeHint(extra) : (short)-1;
                Message.INVOKE msg = Message.INVOKE(Cache.getTarget(line, nodeHint), line.id, f);
                this.send(msg);
                assert (msg.getMessageId() > 0L);
                op.setExtra(msg);
            }
            return PENDING;
        }
        if (!this.transitionToE(line, (short)-1)) {
            return PENDING;
        }
        Object res = this.execInvoke(line, f);
        if (txn == null && !line.isLocked()) {
            this.backupLine(line);
        }
        return res;
    }

    private static short nodeHint(Object obj) {
        return obj != null ? (Short)obj : (short)-1;
    }

    private static short getTarget(CacheLine line, short nodeHint) {
        short target = line.getOwner();
        if (target < 0) {
            target = nodeHint;
        }
        return target;
    }

    private void setData(CacheLine line, Object data, Transaction txn) {
        assert (!line.state.isLessThan(State.O));
        if (txn != null && this.rollbackSupported && !txn.isRecorded(line.getId())) {
            txn.recordRollback(line.getId(), line.getVersion(), line.is((byte)2), line.getData() != null ? Persistables.toByteArray(line.getData()) : null);
        }
        if (this.writeData(line, data) || line.version == 0L) {
            line.version++;
            line.set((byte)2, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Line {} now has a new version {}. Setting to modified.", (Object)LoggingUtils.hex(line.getId()), (Object)line.getVersion());
            }
        }
    }

    private int handleMessageGet(Message.GET msg, CacheLine line) throws IrrelevantStateException {
        if (this.handleNotOwner(msg, line)) {
            return 0;
        }
        this.relevantStates(line, State.E, State.O);
        int change = 0;
        int n = this.setState(line, State.O) ? 1 : 0;
        line.sharers.add(msg.getNode());
        this.send(Message.PUT(msg, line.id, line.version, Cache.readOnly(line.data)));
        line.rewind();
        return change |= n;
    }

    private int handleMessageGetX(Message.GET msg, CacheLine line) throws IrrelevantStateException {
        if (this.handleNotOwner(msg, line)) {
            return 0;
        }
        this.relevantStates(line, State.E, State.O);
        if (line.is((byte)4) && this.backup.inv(line.getId(), msg.getNode())) {
            line.set((byte)4, false);
        }
        if (!this.hasServer && line.is((byte)4)) {
            line.sharers.add(this.myNodeId());
        }
        short[] sharers = line.sharers.toArray();
        int change = 0;
        change |= this.setState(line, this.hasServer | !line.is((byte)4) ? State.I : State.S) ? 1 : 0;
        change |= this.setOwner(line, msg.getNode()) ? 2 : 0;
        List<Message.MSG> pendingMSGs = this.getAndClearPendingMSGs(line);
        this.send(Message.PUTX(msg, line.id, sharers, pendingMSGs.size(), line.version, Cache.readOnly(line.data)));
        line.rewind();
        for (Message.MSG m : pendingMSGs) {
            m = Cache.toOutgoing(m, msg.getNode());
            m.setPending(true);
            m.setReplyRequired(false);
            this.send(m);
        }
        if (line.getState() == State.I && !line.is((byte)8)) {
            this.fireLineInvalidated(line);
        }
        return change;
    }

    private static <M extends Message> M toOutgoing(M m, short node) {
        m.setOutgoing();
        m.setMessageId(-1L);
        m.setNode(node);
        return m;
    }

    private int handleMessagePut(Message.PUT msg, CacheLine line) throws IrrelevantStateException {
        this.relevantStates(line, State.I, State.S);
        if (line.version > msg.getVersion()) {
            return 0;
        }
        this.setOwnerClock(line, msg);
        int change = 0;
        change |= this.setState(line, State.S) ? 1 : 0;
        change |= this.setOwner(line, msg.getNode()) ? 2 : 0;
        line.version = msg.getVersion();
        this.writeData(line, msg.getData());
        this.fireLineReceived(line);
        return change;
    }

    private int handleMessagePutX(Message.PUTX msg, CacheLine line) throws IrrelevantStateException {
        this.relevantStates(line, State.I, State.S);
        if (line.version > msg.getVersion()) {
            LOG.warn("Got PUTX with version {} which is older than current version {}", (Object)msg.getVersion(), (Object)line.version);
            return 0;
        }
        TShortHashSet sharers = new TShortHashSet((msg.getSharers() != null ? msg.getSharers().length : 0) + 1);
        if (msg.getSharers() != null) {
            sharers.addAll(msg.getSharers());
        }
        if (this.hasServer && msg.getNode() != 0) {
            sharers.add((short)0);
        }
        sharers.remove(this.myNodeId());
        int change = 0;
        change |= line.getState().isLessThan(State.O) ? 2 : 0;
        change |= this.setState(line, sharers.isEmpty() ? State.E : State.O) ? 1 : 0;
        if (sharers.isEmpty()) {
            change |= this.setOwner(line, this.myNodeId()) ? 2 : 0;
        } else {
            this.setOwner(line, msg.getNode());
        }
        line.sharers.addAll((TShortCollection)sharers);
        line.version = msg.getVersion();
        this.writeData(line, (Object)msg.getData());
        line.parts = (short)msg.getMessages();
        this.setOwnerClock(line, msg);
        this.fireLineReceived(line);
        if (this.hasServer && msg.getNode() != 0) {
            this.send(Message.INV((short)0, line.id, msg.getNode()));
        }
        return change;
    }

    private int handleMessageInvalidate(Message.INV msg, CacheLine line) throws IrrelevantStateException {
        if (this.getCluster().isMaster()) {
            this.relevantStates(line, State.S, State.I, State.O);
        } else {
            this.relevantStates(line, State.I, State.E);
        }
        assert (line.getState().isLessThan(State.O) || msg.getNode() == 0 || !this.getCluster().isMaster());
        short owner = msg.getNode() == 0 || msg.getNode() == this.getCluster().getMyNodeId() ? msg.getPreviousOwner() : msg.getNode();
        int change = 0;
        this.setNextState(line, null);
        change |= this.setState(line, State.I) ? 1 : 0;
        change |= this.setOwner(line, owner) ? 2 : 0;
        this.setOwnerClock(line, msg);
        if (this.getCluster().isMaster()) {
            if (line.is((byte)4) && this.backup.inv(line.getId(), owner)) {
                line.set((byte)4, false);
            }
            if (line.is((byte)4)) {
                this.addPendingMessage(line, msg);
            } else if (msg.getNode() != 0) {
                this.send(Message.INVACK(msg));
            }
        }
        if (line.getState() == State.I && !line.is((byte)8)) {
            this.fireLineInvalidated(line);
        }
        return change;
    }

    private int handleMessageInvalidateAck(Message.LineMessage msg, CacheLine line) throws IrrelevantStateException {
        if (msg.getNode() == this.myNodeId()) {
            assert (line.is((byte)4));
            if (line.isLocked()) {
                this.addPendingMessage(line, msg);
                return 0;
            }
            this.relevantStates(line, State.I, State.S);
            line.set((byte)4, false);
            int change = 4;
            if (line.getState() == State.S) {
                this.setNextState(line, null);
                change |= this.setState(line, State.I) ? 1 : 0;
                this.setOwnerClock(line, msg);
                this.send(Message.INVACK(line.getOwner(), line.getId()));
                if (line.getState() == State.I && !line.is((byte)8)) {
                    this.fireLineInvalidated(line);
                }
            }
            return change;
        }
        this.relevantStates(line, State.O);
        int change = 0;
        line.sharers.remove(msg.getNode());
        if (line.sharers.isEmpty()) {
            change |= this.setState(line, line.is((byte)8) ? State.I : State.E) ? 1 : 0;
            change |= this.setOwner(line, this.myNodeId()) ? 2 : 0;
            change |= 1;
        } else if (this.broadcastsRoutedToServer && msg.getNode() == 0 || !this.hasServer && msg.getNode() == line.getOwner()) {
            change |= 1;
        }
        if (!msg.isResponse()) {
            this.send(Message.ACK(msg));
        }
        return change;
    }

    private int handleMessageNotFound(Message.LineMessage msg, CacheLine line) throws IrrelevantStateException {
        this.relevantStates(line, State.I);
        if (msg.getNode() == 0 || !this.hasServer) {
            line.set((byte)8, true);
            return 1;
        }
        this.setOwner(line, (short)0);
        this.setNextState(line, null);
        return 2;
    }

    private int handleMessageChngdOwnr(Message.CHNGD_OWNR msg, CacheLine line) throws IrrelevantStateException {
        this.relevantStates(line, State.I, State.S);
        if (msg.getNewOwner() != -1 && this.getCluster().getMaster(msg.getNewOwner()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not changing owner of {} to {} because node is not in the cluster.", (Object)LoggingUtils.hex(line.getId()), (Object)msg.getNewOwner());
            }
            this.setNextState(line, null);
            return 2;
        }
        if (this.setOwner(line, msg.getNewOwner())) {
            int change = 2;
            if (msg.getNode() == 0 && msg.getNewOwner() == this.myNodeId()) {
                this.setState(line, State.E);
                change |= 1;
            }
            this.setNextState(line, null);
            return change;
        }
        return 0;
    }

    private int handleMessageMsg(Message.MSG msg, CacheLine line) {
        this.setOwnerClock(line, msg);
        int change = 0;
        if (msg.isPending()) {
            CacheLine.access$910(line);
            if (line.parts == 0) {
                change |= 1;
            }
            msg.setPending(false);
        }
        if (line.getListener() != null) {
            try {
                line.getListener().messageReceived(msg.getData());
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception on messageReceived.", (Throwable)e);
            }
        } else {
            this.addPendingMessage(line, msg);
        }
        if (msg.isReplyRequired()) {
            this.send(Message.MSGACK(msg));
        }
        return change;
    }

    private int handleMessageMsgAck(Message.LineMessage ack, CacheLine line) throws IrrelevantStateException {
        Op sendOp = null;
        int change = 0;
        change |= this.setOwner(line, ack.getNode()) ? 2 : 0;
        Collection<Op> pending = this.getPendingOps(line);
        for (Op op : pending) {
            Message.MSG msg;
            if (op.type != Op.Type.SEND || (msg = (Message.MSG)op.getExtra()).getMessageId() != ack.getMessageId()) continue;
            sendOp = op;
            break;
        }
        if (sendOp != null) {
            this.completeOp(line, sendOp, null, true);
            this.removePendingOp(line, sendOp);
        }
        return change;
    }

    private int handleMessageTimeout(Message.LineMessage msg, CacheLine line) throws IrrelevantStateException {
        Iterator<Op> it = this.getPendingOps(line).iterator();
        while (it.hasNext()) {
            Op op = it.next();
            if (!op.hasFuture()) {
                op.createFuture();
            }
            LOG.warn("TIMEOUT: {}", (Object)op);
            op.setException(new TimeoutException("Timeout while processing op " + op + ": " + msg));
            it.remove();
        }
        line.nextState = null;
        return 1;
    }

    private int handleMessageBackup(Message.PUT msg, CacheLine line) throws IrrelevantStateException {
        if (this.getCluster().isMaster()) {
            LOG.warn("Received backup message while master (ignoring): {}", (Object)msg);
            return 0;
        }
        assert (!this.getCluster().isMaster());
        assert (msg.getNode() == this.myNodeId());
        if (line.version > msg.getVersion()) {
            return 0;
        }
        int change = 0;
        change |= this.setState(line, State.E) ? 1 : 0;
        change |= this.setOwner(line, msg.getNode()) ? 2 : 0;
        line.version = msg.getVersion();
        this.writeData(line, msg.getData());
        this.fireLineReceived(line);
        return change;
    }

    private int handleMessageBackupAck(Message.BACKUPACK msg, CacheLine line) throws IrrelevantStateException {
        if (line.is((byte)8)) {
            this.relevantStates(line, State.I);
        } else {
            this.relevantStates(line, State.O, State.E);
        }
        assert (line.is((byte)2));
        assert (line.getVersion() >= msg.getVersion());
        int change = 0;
        if (line.is((byte)2) && line.getVersion() == msg.getVersion()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Backup of line {} version {} done. Setting to unmodified.", (Object)LoggingUtils.hex(line.getId()), (Object)line.getVersion());
            }
            line.set((byte)2, false);
            change |= 4;
        }
        return change;
    }

    private int handleMessageInvoke(Message.INVOKE msg, CacheLine line) throws IrrelevantStateException {
        if (this.handleNotOwner(msg, line)) {
            return 0;
        }
        this.relevantStates(line, State.E, State.O);
        if (!this.transitionToE(line, (short)-1)) {
            this.addPendingMessage(line, msg);
            return 0;
        }
        Object invokeRes = this.execInvoke(line, msg.getFunction());
        this.backupLine(line);
        this.fireLineReceived(line);
        this.send(Message.INVRES(msg, line.id, invokeRes));
        return -1;
    }

    private int handleMessageInvRes(Message.INVRES res, CacheLine line) {
        Op invokeOp = null;
        Collection<Op> pending = this.getPendingOps(line);
        for (Op op : pending) {
            Message.INVOKE msg;
            if (op.type != Op.Type.INVOKE || (msg = (Message.INVOKE)op.getExtra()).getMessageId() != res.getMessageId()) continue;
            invokeOp = op;
            break;
        }
        if (invokeOp != null) {
            this.completeOp(line, invokeOp, res.getResult(), true);
            this.removePendingOp(line, invokeOp);
        }
        return 0;
    }

    private boolean isPossibleInconsistencies(CacheLine line) {
        assert (line.getState() == State.I);
        short owner = line.getOwner();
        if (System.currentTimeMillis() - line.timeAccessed > this.maxStaleReadMillis) {
            return true;
        }
        if (owner == -1) {
            return false;
        }
        OwnerClock oc = this.ownerClocks.get(owner);
        if (oc == null) {
            return false;
        }
        long lastPut = Math.max(oc.lastPut.get(), this.globalOwnerClock.lastPut.get());
        return line.getOwnerClock() <= lastPut;
    }

    private void setOwnerClock(CacheLine line, Message msg) {
        long _clock = this.clock.incrementAndGet();
        line.setOwnerClock(_clock);
        switch (msg.getType()) {
            case INV: {
                short owner = msg.getNode();
                this.getOwnerClock((short)owner).invCounter.incrementAndGet();
                break;
            }
            case MSG: 
            case PUT: 
            case PUTX: {
                short owner = line.getOwner();
                this.setOwnerClockPut(owner, this.getOwnerClock(owner), _clock);
                break;
            }
        }
    }

    private void setOwnerClockPut(Message msg) {
        short owner = msg.getNode();
        OwnerClock oc = this.getOwnerClock(owner);
        long _clock = this.clock.incrementAndGet();
        this.setOwnerClockPut(owner, oc, _clock);
    }

    private void setOwnerClockPut(short owner, OwnerClock oc, long clock) {
        long current;
        while (clock > (current = oc.lastPut.get())) {
            if (!oc.lastPut.compareAndSet(current, clock)) continue;
            if (owner >= 0) {
                this.monitor.addStalePurge(oc.invCounter.get());
                oc.invCounter.set(0);
                break;
            }
            int count = 0;
            for (OwnerClock oc1 : this.ownerClocks.values()) {
                count += oc1.invCounter.get();
                oc1.invCounter.set(0);
            }
            this.monitor.addStalePurge(count);
            break;
        }
    }

    private OwnerClock getOwnerClock(short owner) {
        OwnerClock tmp;
        OwnerClock oc = this.ownerClocks.get(owner);
        if (oc == null && (tmp = this.ownerClocks.putIfAbsent(owner, oc = new OwnerClock())) != null) {
            oc = tmp;
        }
        return oc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeRemoved(final short node) {
        LOG.info("Node {} removed.", (Object)node);
        final short newOwner = this.hasServer ? (short)0 : -1;
        NodeEvent event = new NodeEvent(node, newOwner);
        this.inNodeEventHandler.set(Boolean.TRUE);
        this.nodeEvents.add(event);
        try {
            this.processLines(new LinePredicate(){

                @Override
                public boolean processLine(CacheLine line) {
                    Iterator it = Cache.this.getPendingMessages(line).iterator();
                    while (it.hasNext()) {
                        Message.LineMessage message = (Message.LineMessage)it.next();
                        if (message.getNode() != node) continue;
                        it.remove();
                    }
                    Cache.this.processLineOnNodeEvent(line, node, newOwner);
                    return true;
                }
            });
        }
        finally {
            this.nodeEvents.remove(event);
            this.inNodeEventHandler.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeSwitched(final short node) {
        NodeEvent event = new NodeEvent(node, node);
        this.inNodeEventHandler.set(Boolean.TRUE);
        this.nodeEvents.add(event);
        try {
            this.processLines(new LinePredicate(){

                @Override
                public boolean processLine(CacheLine line) {
                    Cache.this.processLineOnNodeEvent(line, node, node);
                    return true;
                }
            });
        }
        finally {
            this.nodeEvents.remove(event);
            this.inNodeEventHandler.remove();
        }
    }

    @Override
    public void nodeAdded(short node) {
    }

    private void handleNodeEvents(CacheLine line) {
        if (this.inNodeEventHandler.get() == Boolean.TRUE) {
            return;
        }
        for (NodeEvent event : this.nodeEvents) {
            this.processLineOnNodeEvent(line, event.node, event.newOwner);
        }
    }

    private void processLineOnNodeEvent(CacheLine line, short node, short newOwner) {
        if (line.getState().isLessThan(State.O) && line.getOwner() == node) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node {} switched/removed - owned line {}. Setting to I and owner to {}", new Object[]{node, line, newOwner});
            }
            int change = 0;
            change |= this.setState(line, State.I) ? 1 : 0;
            this.setNextState(line, null);
            if (node != newOwner) {
                change |= this.setOwner(line, newOwner) ? 2 : 0;
                this.fireLineKilled(line);
            }
            line.setOwnerClock(0L);
            boolean stop = false;
            do {
                try {
                    this.handlePendingOps(line, change);
                    stop = true;
                }
                catch (ConcurrentModificationException e) {
                    LOG.debug("processLineOnNodeEvent: OOPS. CME. Retrying");
                }
            } while (!stop);
        } else if (line.getState() == State.O && line.sharers.remove(node)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node {} switched/removed - removing from sharers of line {}", (Object)node, (Object)line);
            }
            if (line.sharers.isEmpty()) {
                this.setState(line, State.E);
                this.handlePendingOps(line, 1);
            }
        }
    }

    private boolean setNextState(CacheLine line, State nextState) {
        if (line.nextState == nextState) {
            return false;
        }
        if (line.nextState == null || nextState == null || line.nextState.isLessThan(nextState)) {
            line.nextState = nextState;
            if (nextState == State.S | nextState == State.O) {
                this.monitor.addMiss();
            }
            if (nextState == State.E) {
                this.monitor.addInvalidate(line.sharers.size());
            }
            return true;
        }
        return false;
    }

    private boolean setState(CacheLine line, State state) {
        if (line.nextState != null && (line.nextState == state || line.nextState.isLessThan(state))) {
            line.nextState = null;
        }
        if (line.state != state) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set state {} {} -> {}", new Object[]{LoggingUtils.hex(line.getId()), line.state, state});
            }
            if (!state.isLessThan(State.O) && line.getState().isLessThan(State.O)) {
                this.owned.put(line.getId(), line);
                this.shared.remove(line.getId());
            } else if (state.isLessThan(State.O) && !line.getState().isLessThan(State.O)) {
                this.shared.put(line.getId(), line);
                this.owned.remove(line.getId());
            }
            line.state = state;
            if (line.sharers == null || !state.isLessThan(State.O)) {
                line.sharers = this.allocateSharerSet(10);
            } else if (line.sharers != null || state.isLessThan(State.O)) {
                this.deallocateSharerSet(line.id, line.sharers);
                line.sharers = null;
            }
            return true;
        }
        return false;
    }

    private boolean setOwner(CacheLine line, short owner) {
        short oldOwner = line.owner;
        if (owner != oldOwner) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set owner {} {} -> {}", new Object[]{LoggingUtils.hex(line.getId()), line.owner, owner});
            }
            line.owner = owner;
            return true;
        }
        return false;
    }

    private void accessLine(CacheLine line) {
        if (line != null && line.getState().isLessThan(State.O)) {
            line.timeAccessed = System.currentTimeMillis();
        }
    }

    private boolean writeData(CacheLine line, Object data) {
        if (data == null) {
            return this.writeNull(line);
        }
        if (data instanceof Persistable) {
            return this.writeData(line, (Persistable)data);
        }
        if (data instanceof ByteBuffer) {
            return this.writeData(line, (ByteBuffer)data);
        }
        return this.writeData(line, (byte[])data);
    }

    private boolean writeData(CacheLine line, byte[] data) {
        if (data.length > this.maxItemSize) {
            throw new IllegalArgumentException("Data size is " + data.length + " bytes and exceeds the limit of " + this.maxItemSize + " bytes.");
        }
        if (this.compareBeforeWrite && line.data != null && data.length == line.data.remaining()) {
            int p = line.data.position();
            boolean modified = false;
            for (int i = 0; i < data.length; ++i) {
                if (line.data.get(p + i) == data[i]) continue;
                modified = true;
                break;
            }
            if (!modified) {
                return false;
            }
        }
        this.allocateLineData(line, data.length);
        line.data.put(data);
        line.data.flip();
        return true;
    }

    private boolean writeData(CacheLine line, ByteBuffer data) {
        if (data.remaining() > this.maxItemSize) {
            throw new IllegalArgumentException("Data size is " + data.remaining() + " bytes and exceeds the limit of " + this.maxItemSize + " bytes.");
        }
        if (this.compareBeforeWrite && line.data != null && data.remaining() == line.data.remaining()) {
            int p1 = line.data.position();
            int p2 = data.position();
            boolean modified = false;
            for (int i = 0; i < data.remaining(); ++i) {
                if (line.data.get(p1 + i) == data.get(p2 + i)) continue;
                modified = true;
                break;
            }
            if (!modified) {
                return false;
            }
        }
        this.allocateLineData(line, data.remaining());
        line.data.put(data);
        line.data.flip();
        return true;
    }

    private boolean writeData(CacheLine line, Persistable object) {
        if (object.size() > this.maxItemSize) {
            throw new IllegalArgumentException("Object size is " + object.size() + " bytes and exceeds the limit of " + this.maxItemSize + " bytes: " + object);
        }
        if (this.compareBeforeWrite) {
            Checksum chksm = this.getChecksum();
            if (line.data != null && object.size() == line.data.remaining()) {
                int n = line.data.remaining();
                chksm.update(line.data);
                line.data.rewind();
                byte[] hash = chksm.getChecksum();
                object.write(line.data);
                line.data.flip();
                chksm.reset();
                chksm.update(line.data);
                line.data.rewind();
                return !Arrays.equals(hash, chksm.getChecksum());
            }
        }
        this.allocateLineData(line, object.size());
        object.write(line.data);
        line.data.flip();
        return true;
    }

    private boolean writeNull(CacheLine line) {
        if (line.data == null) {
            return false;
        }
        int oldSize = line.size();
        this.deallocateStorage(line.id, line.data);
        line.data = null;
        if (line.getState().isLessThan(State.O)) {
            this.putLine(line.id, line, oldSize, 0);
        }
        return true;
    }

    private Object execInvoke(CacheLine line, LineFunction f) {
        LineAccess la = new LineAccess(line);
        Object res = f.invoke(la);
        if (la.flip) {
            line.data.flip();
        } else {
            line.data.rewind();
        }
        return res;
    }

    private void allocateLineData(CacheLine line, int size) {
        int oldSize = line.size();
        if (line.data != null) {
            if (line.data.capacity() >= size && line.data.capacity() < size * 4) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reusing (clearing) storage for line {}. Storage: {} bytes. Data: {} bytes", new Object[]{LoggingUtils.hex(line.getId()), line.data.capacity(), size});
                }
                line.data.clear();
            } else {
                this.deallocateStorage(line.id, line.data);
                line.data = null;
            }
        }
        boolean resized = false;
        if (line.data == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Allocating storage ({} bytes) for line {}", (Object)size, (Object)LoggingUtils.hex(line.getId()));
            }
            line.data = this.allocateStorage(size);
            resized = true;
        }
        line.data.limit(size);
        if (resized && line.getState().isLessThan(State.O)) {
            this.putLine(line.id, line, oldSize, line.size());
        }
    }

    private byte[] readData(CacheLine line) {
        this.accessLine(line);
        if (line.data == null) {
            return null;
        }
        byte[] data = new byte[line.data.remaining()];
        line.data.get(data);
        line.data.rewind();
        return data;
    }

    private void readData(CacheLine line, Persistable object) {
        ByteBuffer buffer;
        if (object == null | object == NULL_PERSISTABLE) {
            return;
        }
        this.accessLine(line);
        ByteBuffer byteBuffer = buffer = line.data != null ? line.data : EMPTY_BUFFER;
        if (object instanceof VersionedPersistable) {
            ((VersionedPersistable)object).read(line.getVersion(), buffer);
        } else {
            object.read(buffer);
        }
        line.rewind();
    }

    private CacheLine createNewCacheLine(long id) {
        CacheLine line = this.allocateCacheLine();
        line.id = id;
        return this.putLine(id, line, 0, 0);
    }

    private CacheLine createNewCacheLine(Op op) {
        return this.createNewCacheLine(op.line);
    }

    private CacheLine createNewCacheLine(Message message) {
        return this.createNewCacheLine(((Message.LineMessage)message).getLine());
    }

    void evictLine(CacheLine line, boolean invack) {
        long id = line.getId();
        int oldSize = line.size();
        this.discardLine(line, invack);
        this.removeLine(id, line, oldSize);
    }

    private void discardLine(CacheLine line, boolean invack) {
        LOG.debug("Evicted {}", (Object)line);
        this.fireLineEvicted(line);
        long id = line.getId();
        this.deallocateStorage(id, line.data);
        if (invack && line.getState() == State.S) {
            this.send(Message.INVACK(line.getOwner(), line.getId()));
        }
        this.clearLine(line);
        this.deallocateCacheLine(id, line);
    }

    private void clearLine(CacheLine line) {
        if (line.sharers != null) {
            this.deallocateSharerSet(line.id, line.sharers);
        }
        line.id = 0L;
        line.clearFlags();
        line.state = State.I;
        line.nextState = null;
        line.owner = (short)-1;
        line.sharers = null;
        line.version = 0L;
        line.data = null;
    }

    void lockLine(CacheLine line, Transaction txn) {
        LOG.debug("Locking line {}", (Object)line);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Locked:", new Throwable());
        }
        line.lock();
        if (txn != null) {
            txn.add(line.getId());
        }
    }

    boolean unlockLine(CacheLine line, Transaction txn) {
        LOG.debug("Unlocking line {}", (Object)line);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Unlocked:", new Throwable());
        }
        assert (txn == null || txn.contains(line.getId()));
        return line.unlock();
    }

    void send(Message message) {
        block2: {
            LOG.debug("Sending: {}", (Object)message);
            try {
                this.comm.send(message);
            }
            catch (NodeNotFoundException e) {
                Message response = this.genResponse(message);
                LOG.debug("Auto response: {} (to: {})", (Object)response, (Object)message);
                if (response == null) break block2;
                this.receive(this.shortCircuitMessage(message.getNode(), response));
            }
        }
        LOG.debug("Sent: {}", (Object)message);
        this.monitor.addMessageSent(message.getType());
    }

    private void receiveShortCircuit() {
        Queue<Message> ms = this.shortCircuitMessage.get();
        if (ms != null) {
            while (!ms.isEmpty()) {
                Message m = ms.remove();
                this.receive1(m);
            }
        }
        this.shortCircuitMessage.remove();
    }

    private Message genResponse(Message message) {
        switch (message.getType()) {
            case INV: {
                return Message.INVACK((Message.INV)message);
            }
            case GET: 
            case GETX: {
                return Message.CHNGD_OWNR((Message.LineMessage)message, ((Message.LineMessage)message).getLine(), (short)-1, false);
            }
        }
        return null;
    }

    private Message shortCircuitMessage(short node, Message message) {
        message.setIncoming();
        message.setNode(node);
        return message;
    }

    CacheLine getLine(long id) {
        CacheLine line = this.owned.get(id);
        if (line == null) {
            line = (CacheLine)this.shared.get(id);
        }
        return line;
    }

    private CacheLine putLine(long id, CacheLine line, int oldSize, int newSize) {
        if (line.getState().isLessThan(State.O)) {
            CacheLine old = this.shared.put(id, line);
            if (old != null && old != line) {
                this.evictLine(old, false);
            }
            return line;
        }
        CacheLine old = this.owned.putIfAbsent(id, line);
        if (old != null && old != line) {
            this.evictLine(line, false);
            return old;
        }
        return line;
    }

    void removeLine(long id, CacheLine line, int oldSize) {
        if (this.owned.remove(id) == null) {
            this.shared.remove(id);
        }
    }

    private void addPendingOp(CacheLine line, Op op) {
        if (op.hasFuture()) {
            return;
        }
        op.createFuture();
        ArrayList<Op> ops = this.pendingOps.get(op.line);
        if (ops == null) {
            ops = new ArrayList();
            this.pendingOps.put(op.line, ops);
        }
        ops.add(op);
    }

    private Collection<Op> getPendingOps(CacheLine line) {
        ArrayList<Op> ops = this.pendingOps.get(line.getId());
        return ops != null ? ops : Collections.EMPTY_LIST;
    }

    private void removePendingOp(CacheLine line, Op op) {
        ArrayList<Op> ops = this.pendingOps.get(op.line);
        if (ops == null) {
            return;
        }
        ops.remove(op);
        if (ops.isEmpty()) {
            this.pendingOps.remove(op.line);
        }
    }

    private boolean hasPendingOp(CacheLine line, Op.Type opType) {
        for (Op op : this.getPendingOps(line)) {
            if (op.type != opType) continue;
            return true;
        }
        return false;
    }

    private void addPendingMessage(CacheLine line, Message.LineMessage message) {
        LinkedHashSet<Message.LineMessage> msgs = this.pendingMessages.get(line.getId());
        if (msgs == null) {
            msgs = new LinkedHashSet();
            this.pendingMessages.put(line.getId(), msgs);
        }
        msgs.add(message);
        if (LOG.isDebugEnabled()) {
            LOG.debug("addPendingMessage {} to line {}", (Object)message, (Object)line);
        }
    }

    private boolean hasPendingMessages(CacheLine line) {
        Collection msgs = this.pendingMessages.get(line.getId());
        return msgs != null && !msgs.isEmpty();
    }

    private boolean hasPendingBlockingMessages(CacheLine line) {
        Collection msgs = this.pendingMessages.get(line.getId());
        if (msgs == null || msgs.isEmpty()) {
            return false;
        }
        for (Message.LineMessage m : msgs) {
            if (m instanceof Message.MSG) continue;
            return true;
        }
        return false;
    }

    private Set<Message.LineMessage> getAndClearPendingMessages(CacheLine line) {
        Set<Message.LineMessage> msgs = (Set<Message.LineMessage>)this.pendingMessages.remove(line.getId());
        if (msgs == null) {
            msgs = Collections.emptySet();
        }
        return msgs;
    }

    private Set<Message.LineMessage> getPendingMessages(CacheLine line) {
        Set<Message.LineMessage> msgs = (Set<Message.LineMessage>)this.pendingMessages.get(line.getId());
        if (msgs == null) {
            msgs = Collections.emptySet();
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLines(LinePredicate lp) {
        for (ConcurrentMap map : new ConcurrentMap[]{this.owned, this.shared}) {
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                boolean retain;
                CacheLine line;
                CacheLine cacheLine = line = (CacheLine)it.next();
                synchronized (cacheLine) {
                    retain = lp.processLine(line);
                    if (!retain) {
                        this.discardLine(line, false);
                    }
                }
                if (retain) continue;
                it.remove();
            }
        }
    }

    private short myNodeId() {
        return this.getCluster().getMyNodeId();
    }

    private CacheLine allocateCacheLine() {
        CacheLine line;
        if (this.freeLineList == null) {
            line = new CacheLine();
        } else {
            line = this.freeLineList.pollFirst();
            if (line == null) {
                line = new CacheLine();
            }
        }
        this.clearLine(line);
        return line;
    }

    private void deallocateCacheLine(long id, CacheLine line) {
        if (this.freeLineList == null) {
            return;
        }
        this.freeLineList.addFirst(line);
    }

    private TShortHashSet allocateSharerSet(int size) {
        if (this.freeSharerSetList == null) {
            return new TShortHashSet(size);
        }
        TShortHashSet sharers = this.freeSharerSetList.pollFirst();
        if (sharers != null) {
            return sharers;
        }
        return new TShortHashSet(size);
    }

    private void deallocateSharerSet(long id, TShortHashSet sharers) {
        if (this.freeSharerSetList == null) {
            return;
        }
        this.freeSharerSetList.addFirst(sharers);
    }

    ByteBuffer allocateStorage(int length) {
        return this.storage.allocateStorage(length);
    }

    void deallocateStorage(long id, ByteBuffer buffer) {
        if (buffer != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deallocating storage for line {}", (Object)LoggingUtils.hex(id));
            }
            this.storage.deallocateStorage(id, buffer);
        }
    }

    private void fireLineInvalidated(CacheLine line) {
        LOG.debug("fireLineInvalidated {}", (Object)line);
        if (line.getListener() != null) {
            try {
                line.getListener().invalidated(this, line.getId());
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.invalidated(this, line.getId());
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireLineReceived(CacheLine line) {
        LOG.debug("fireLineReceived {}", (Object)line);
        long id = line.getId();
        long version = line.getVersion();
        ByteBuffer data = line.data;
        if (line.getListener() != null) {
            line.rewind();
            try {
                line.getListener().received(this, id, version, data);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
            line.rewind();
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.received(this, id, version, data);
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
            line.rewind();
        }
    }

    private void fireLineEvicted(CacheLine line) {
        LOG.debug("fireLineEviceted {}", (Object)line);
        if (line.getListener() != null) {
            try {
                line.getListener().evicted(this, line.getId());
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.evicted(this, line.getId());
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private void fireLineKilled(CacheLine line) {
        LOG.debug("fireLineEviceted {}", (Object)line);
        if (line.getListener() != null) {
            try {
                line.getListener().killed(this, line.getId());
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.killed(this, line.getId());
            }
            catch (Exception e) {
                LOG.error("Listener threw an exception.", (Throwable)e);
            }
        }
    }

    private static ByteBuffer readOnly(ByteBuffer buffer) {
        return buffer != null ? buffer.asReadOnlyBuffer() : null;
    }

    public static boolean isReserved(long id) {
        return id <= 0xFFFFFFFFL;
    }

    private void relevantStates(CacheLine line, State ... states) throws IrrelevantStateException {
        State state = line.state;
        for (State s : states) {
            if (state != s) continue;
            return;
        }
        throw IRRELEVANT_STATE;
    }

    static boolean isVoidLineFunction(LineFunction<?> function) {
        return isVoidLineFunction.get(function.getClass());
    }

    private static boolean isVoidLineFunction(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        for (Type iface : clazz.getGenericInterfaces()) {
            boolean r;
            if (iface instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)iface;
                if (pt.getRawType() == LineFunction.class) {
                    return pt.getActualTypeArguments()[0] == Void.class;
                }
                boolean r2 = Cache.isVoidLineFunction((Class)pt.getRawType());
                if (r2) {
                    return true;
                }
            } else if (iface == LineFunction.class) {
                return false;
            }
            if (!(r = Cache.isVoidLineFunction((Class)iface))) continue;
            return true;
        }
        return Cache.isVoidLineFunction(clazz.getSuperclass());
    }

    private static class IrrelevantStateException
    extends Exception {
        private IrrelevantStateException() {
        }
    }

    static interface LinePredicate {
        public boolean processLine(CacheLine var1);
    }

    private class LineAccess
    implements LineFunction.LineAccess {
        final CacheLine line;
        boolean flip;

        public LineAccess(CacheLine line) {
            this.line = line;
        }

        @Override
        public ByteBuffer getForRead() {
            return (ByteBuffer)this.line.getData().asReadOnlyBuffer().rewind();
        }

        @Override
        public ByteBuffer getForWrite(int size) {
            if (size >= 0 && this.line.data.capacity() < size) {
                this.extendLineData(size);
            }
            this.line.version++;
            this.line.set((byte)2, true);
            this.flip = size >= 0;
            return (ByteBuffer)this.line.getData().rewind();
        }

        private void extendLineData(int size) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Extend storage to {} bytes for line {}", (Object)size, (Object)LoggingUtils.hex(this.line.getId()));
            }
            ByteBuffer allocated = Cache.this.allocateStorage(size);
            allocated.put((ByteBuffer)this.line.data.rewind());
            allocated.flip();
            Cache.this.deallocateStorage(this.line.id, this.line.data);
            this.line.data = allocated;
        }
    }

    private static final class NodeEvent {
        public final short node;
        public final short newOwner;

        public NodeEvent(short node, short newOwner) {
            this.node = node;
            this.newOwner = newOwner;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NodeEvent)) {
                return false;
            }
            return this.node == ((NodeEvent)obj).node;
        }

        public int hashCode() {
            return this.node;
        }
    }

    private static class OwnerClock {
        public final AtomicLong lastPut = new AtomicLong();
        public final AtomicInteger invCounter = new AtomicInteger();

        private OwnerClock() {
        }
    }

    static class CacheLine {
        private static final byte LOCKED = 1;
        public static final byte MODIFIED = 2;
        public static final byte SLAVE = 4;
        public static final byte DELETED = 8;
        public static final byte INCOMPLETE = 16;
        private long id;
        private byte flags;
        long timeAccessed;
        private volatile State state;
        private State nextState;
        private volatile long version;
        private long ownerClock;
        private ByteBuffer data;
        private short parts;
        private short owner = (short)-1;
        private TShortHashSet sharers;
        private volatile CacheListener listener;

        CacheLine() {
        }

        public long getId() {
            return this.id;
        }

        private void clearFlags() {
            this.flags = 0;
        }

        void lock() {
            this.flags = (byte)(this.flags | 1);
        }

        boolean unlock() {
            if (!this.is(9)) {
                throw new IllegalStateException("Item " + LoggingUtils.hex(this.id) + " has not been pinned!");
            }
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            return true;
        }

        public boolean isLocked() {
            return (this.flags & 1) != 0;
        }

        public boolean isIncomplete() {
            return this.parts > 0;
        }

        public boolean is(byte flag) {
            return (this.flags & flag) != 0;
        }

        public boolean is(int flag) {
            return (this.flags & (byte)flag) != 0;
        }

        private void set(byte flag, boolean value) {
            this.flags = (byte)(value ? this.flags | flag : this.flags & ~flag);
        }

        public State getNextState() {
            return this.nextState;
        }

        public short getOwner() {
            return this.owner;
        }

        public State getState() {
            return this.state;
        }

        public long getVersion() {
            return this.version;
        }

        public long getOwnerClock() {
            return this.ownerClock;
        }

        public void setOwnerClock(long clock) {
            this.ownerClock = clock;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public CacheListener getListener() {
            return this.listener;
        }

        private CacheListener setListener(CacheListener listener, boolean ifAbsent) {
            if (!ifAbsent | this.listener == null) {
                this.listener = listener;
            }
            return this.listener;
        }

        public int size() {
            return this.data != null ? this.data.capacity() : 0;
        }

        public void rewind() {
            if (this.data != null) {
                this.data.rewind();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("LINE: ").append(LoggingUtils.hex(this.id));
            sb.append(" ").append((Object)this.state).append(" ");
            if (this.nextState != null) {
                sb.append("(->").append((Object)this.nextState).append(")");
            }
            sb.append(" OWN: ").append(this.owner);
            sb.append(" SHARE: ").append(this.sharers);
            sb.append(" VER: ").append(this.version);
            sb.append(" DATA: ").append(this.data != null ? "(" + this.size() + " bytes)" : "null");
            if (this.isLocked()) {
                sb.append(" LOCKED");
            }
            if (this.is((byte)2)) {
                sb.append(" MODIFIED");
            }
            if (this.is((byte)4)) {
                sb.append(" SLAVE");
            }
            if (this.is((byte)8)) {
                sb.append(" DELETED");
            }
            return sb.toString();
        }

        static /* synthetic */ short access$910(CacheLine x0) {
            short s = x0.parts;
            x0.parts = (short)(s - 1);
            return s;
        }
    }

    static enum State {
        I,
        S,
        O,
        E;


        public boolean isLessThan(State other) {
            return this.compareTo(other) < 0;
        }
    }
}

