/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.LifecycleListener;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.cluster.NodeInfo;
import co.paralleluniverse.galaxy.cluster.SlaveConfigurationListener;
import co.paralleluniverse.galaxy.monitoring.ClusterMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;

public class ClusterMonitor
extends StandardEmitterMBean
implements ClusterMXBean,
LifecycleListener,
NodeChangeListener,
SlaveConfigurationListener,
NotificationEmitter {
    private final String name;
    private final Cluster cluster;
    private boolean registered;
    private int notificationSequenceNumber;

    public ClusterMonitor(Cluster cluster) {
        super(ClusterMXBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport());
        this.name = "co.paralleluniverse.galaxy:type=Cluster";
        this.cluster = cluster;
        this.registerMBean();
    }

    private void registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.name);
            mbs.registerMBean(this, mxbeanName);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void unregisterMBean() {
        try {
            if (this.registered) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.name));
            }
            this.registered = false;
        }
        catch (InstanceNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public synchronized MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String _name = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, _name, description);
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public SortedMap<String, String> getMyNodeInfo() {
        return this.toMap(this.cluster.getMyNodeInfo());
    }

    @Override
    public boolean isOnline() {
        return this.cluster.isOnline();
    }

    @Override
    public boolean isMaster() {
        return this.cluster.isMaster();
    }

    @Override
    public void shutdown() {
        this.cluster.goOffline();
    }

    @Override
    public boolean hasServer() {
        return this.cluster.hasServer();
    }

    @Override
    public List<SortedMap<String, String>> getNodes() {
        return this.toMapList(this.cluster.getMasters());
    }

    @Override
    public SortedMap<String, String> getMyMaster() {
        return this.toMap(this.cluster.getMyMaster());
    }

    @Override
    public List<SortedMap<String, String>> getMySlaves() {
        return this.toMapList(this.cluster.getMySlaves());
    }

    private List<SortedMap<String, String>> toMapList(Collection<NodeInfo> nis) {
        TreeSet<NodeInfo> nis1 = new TreeSet<NodeInfo>(new Comparator<NodeInfo>(){

            @Override
            public int compare(NodeInfo o1, NodeInfo o2) {
                return o1.getNodeId() - o2.getNodeId();
            }
        });
        nis1.addAll(nis);
        ArrayList<SortedMap<String, String>> list = new ArrayList<SortedMap<String, String>>(nis.size());
        for (NodeInfo ni : nis1) {
            list.add(this.toMap(ni));
        }
        return list;
    }

    private SortedMap<String, String> toMap(NodeInfo ni) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("_id", Short.toString(ni.getNodeId()));
        map.put("_name", ni.getName());
        for (String p : ni.getProperties()) {
            map.put(p, ni.get(p).toString());
        }
        return map;
    }

    private void notifyAttributeChange(String message, String attrName) {
        try {
            Object newValue = this.getAttribute(attrName);
            AttributeChangeNotification n = new AttributeChangeNotification(this, this.notificationSequenceNumber++, System.currentTimeMillis(), message, attrName, null, null, newValue);
            this.sendNotification(n);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void joinedCluster() {
        this.notifyAttributeChange("Now joined", "online");
    }

    @Override
    public void offline() {
        this.notifyAttributeChange("Now offline", "online");
    }

    @Override
    public void online(boolean master) {
        this.notifyAttributeChange("Now online as " + (master ? "master" : "slave"), "online");
    }

    @Override
    public void switchToMaster() {
        this.notifyAttributeChange("Switched to master", "master");
    }

    @Override
    public void nodeAdded(short id) {
        this.notifyAttributeChange("Node " + id + " added", "nodes");
    }

    @Override
    public void nodeRemoved(short id) {
        this.notifyAttributeChange("Node " + id + " removed", "nodes");
    }

    @Override
    public void nodeSwitched(short id) {
        this.notifyAttributeChange("Node " + id + " switched", "nodes");
    }

    @Override
    public void newMaster(NodeInfo node) {
        this.notifyAttributeChange("New master", "myMaster");
    }

    @Override
    public void slaveAdded(NodeInfo node) {
        this.notifyAttributeChange("Slave added", "mySlaves");
    }

    @Override
    public void slaveRemoved(NodeInfo node) {
        this.notifyAttributeChange("Slave removed", "mySlaves");
    }
}

