/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.spring.Service;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;

public abstract class ClusterService
extends Service
implements LifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterService.class);
    private final Cluster cluster;
    private final Object lifecycleLock = new Object();
    private volatile boolean online;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterService(String name, Cluster cluster) {
        super(name);
        this.cluster = cluster;
        cluster.addLifecycleListener(this);
        Object object = this.lifecycleLock;
        synchronized (object) {
            this.online = cluster.isOnline();
        }
    }

    @Override
    protected void postInit() throws Exception {
        if (this.online) {
            this.startService();
        }
        super.postInit();
    }

    private void startService() {
        boolean master = this.cluster.isMaster();
        LOG.info("Starting service {} as {}", (Object)this, (Object)(master ? "master" : "slave"));
        this.start(master);
        LOG.info("Service {} started.", (Object)this);
    }

    @ManagedAttribute(currencyTimeLimit=0)
    protected boolean isOnline() {
        return this.online;
    }

    protected boolean isMaster() {
        return this.cluster.isMaster();
    }

    protected abstract void start(boolean var1);

    @Override
    public void joinedCluster() {
        LOG.info("JOINED CLUSTER (Service {})", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void online(boolean master) {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.online) {
                this.online = true;
                if (this.isInitialized()) {
                    this.startService();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void offline() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.online) {
                this.online = false;
                try {
                    LOG.info("Shutting down component {}", (Object)this.getName());
                    this.shutdown();
                    LOG.info("Component {} destroyed", (Object)this.getName());
                }
                catch (RuntimeException e) {
                    LOG.warn("Exception while shutting down " + this.getName(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    @Override
    public void switchToMaster() {
        LOG.info("Switching service {} to master", (Object)this);
    }

    public Cluster getCluster() {
        return this.cluster;
    }
}

