/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import java.beans.ConstructorProperties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConfigurableThreadPool
extends ThreadPoolExecutor {
    @ConstructorProperties(value={"corePoolSize", "maximumPoolSize", "keepAliveMillis", "maxQueueSize"})
    public ConfigurableThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveMillis, int maxQueueSize) {
        super(corePoolSize, maximumPoolSize, keepAliveMillis, TimeUnit.MILLISECONDS, ConfigurableThreadPool.makeQueue(maxQueueSize));
    }

    private static BlockingQueue<Runnable> makeQueue(int maxSize) {
        if (maxSize == 0) {
            return new SynchronousQueue<Runnable>();
        }
        if (maxSize > 0) {
            return new ArrayBlockingQueue<Runnable>(maxSize);
        }
        return new LinkedTransferQueue<Runnable>();
    }
}

