/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.MonitoringType;
import co.paralleluniverse.common.spring.Component;
import co.paralleluniverse.common.util.DegenerateInvocationHandler;
import co.paralleluniverse.galaxy.core.CacheStorage;
import co.paralleluniverse.galaxy.core.JMXLocalStorageMonitor;
import co.paralleluniverse.galaxy.core.LocalStorageMonitor;
import co.paralleluniverse.galaxy.core.MetricsLocalStorageMonitor;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

class HeapLocalStorage
extends Component
implements CacheStorage {
    private final AtomicLong totalSize = new AtomicLong();
    private final LocalStorageMonitor monitor;

    @ConstructorProperties(value={"name", "monitoringType"})
    public HeapLocalStorage(String name, MonitoringType monitoringType) {
        super(name);
        this.monitor = this.createMonitor(monitoringType, name);
    }

    @Override
    public ByteBuffer allocateStorage(int size) {
        this.monitor.allocated(size);
        this.totalSize.addAndGet(size);
        return ByteBuffer.allocate(size);
    }

    @Override
    public void deallocateStorage(long id, ByteBuffer buffer) {
        this.totalSize.addAndGet(-buffer.capacity());
        this.monitor.deallocated(buffer.capacity());
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.totalSize.get();
    }

    private LocalStorageMonitor createMonitor(MonitoringType monitoringType, String name) {
        if (monitoringType == null) {
            return (LocalStorageMonitor)Proxy.newProxyInstance(HeapLocalStorage.class.getClassLoader(), new Class[]{LocalStorageMonitor.class}, (InvocationHandler)DegenerateInvocationHandler.INSTANCE);
        }
        switch (monitoringType) {
            case JMX: {
                return new JMXLocalStorageMonitor(name, this);
            }
            case METRICS: {
                return new MetricsLocalStorageMonitor(name, this);
            }
        }
        throw new IllegalArgumentException("Unknown MonitoringType " + (Object)((Object)monitoringType));
    }
}

