/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.galaxy.core.Cache;
import co.paralleluniverse.galaxy.core.Op;
import co.paralleluniverse.galaxy.core.RefAllocator;
import java.util.ArrayList;
import java.util.List;

class IdAllocator
implements RefAllocator.RefAllocationsListener {
    private final Cache cache;
    private final RefAllocator refAllocator;
    private static final int REFS_TO_ALLOCATE = 10000;
    private List<Op> pendingOps = new ArrayList<Op>();
    private long nextId = -1L;
    private long minId = -1L;
    private long maxId = -1L;
    private boolean requestedMoreIds;
    private volatile long nextMinId = -1L;
    private volatile long nextMaxId = -1L;
    private boolean ready;

    public IdAllocator(Cache cache, RefAllocator refAllocator) {
        this.cache = cache;
        this.refAllocator = refAllocator;
        refAllocator.addRefAllocationsListener(this);
    }

    public RefAllocator getRefAllocator() {
        return this.refAllocator;
    }

    @Override
    public synchronized void counterReady() {
        this.ready = true;
        this.cache.allocatorReady();
    }

    public synchronized boolean isReady() {
        return this.ready;
    }

    private synchronized long allocateIds(int count) {
        long id;
        if (this.nextId + (long)count > this.maxId && this.nextMinId > this.minId) {
            this.minId = this.nextMinId;
            this.maxId = this.nextMaxId;
            this.nextId = this.minId;
        }
        if (this.nextId + (long)count - 1L <= this.maxId) {
            id = this.nextId;
            this.nextId += (long)count;
        } else {
            id = -1L;
        }
        if (!this.requestedMoreIds && (id == -1L || this.shouldAllocateMoreIds())) {
            this.allocateMoreRefs(count);
            this.requestedMoreIds = true;
        }
        return id;
    }

    public synchronized long allocateIds(Op op, int count) {
        long id = this.allocateIds(count);
        if (id == -1L) {
            if (!op.hasFuture()) {
                op.createFuture();
            }
            this.pendingOps.add(op);
        }
        return id;
    }

    private boolean shouldAllocateMoreIds() {
        return this.nextId > this.minId + (this.maxId - this.minId) / 2L;
    }

    void allocateMoreRefs(int count) {
        this.refAllocator.allocateRefs(Math.max(2 * count, 10000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refsAllocated(long start, int num) {
        List<Op> pending;
        IdAllocator idAllocator = this;
        synchronized (idAllocator) {
            assert (start > this.nextId || start == this.minId);
            assert (start + (long)num > this.maxId);
            if (start == this.minId) {
                assert (start + (long)num > this.maxId);
                this.maxId = start + (long)num - 1L;
            } else {
                assert (start > this.nextId);
                this.requestedMoreIds = false;
                this.nextMinId = start;
                this.nextMaxId = start + (long)num - 1L;
            }
            pending = this.pendingOps;
            this.pendingOps = new ArrayList<Op>();
        }
        for (Op op : pending) {
            this.cache.runOp(op);
        }
    }
}

