/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.PeriodicMonitor;
import co.paralleluniverse.galaxy.core.BackupMonitor;
import co.paralleluniverse.galaxy.monitoring.BackupMXBean;
import co.paralleluniverse.galaxy.monitoring.Counter;
import java.util.concurrent.TimeUnit;

public class JMXBackupMonitor
extends PeriodicMonitor
implements BackupMonitor,
BackupMXBean {
    private final Counter replicationBackupsCounter = new Counter();
    private final Counter backupsCounter = new Counter();
    private final Counter backupPacketsCounter = new Counter();
    private final Counter slavesAckTimeCounter = new Counter();
    private final Counter serverAckTimeCounter = new Counter();
    private int replicationBackups;
    private int backups;
    private int backupPackets;
    private long avgSlavesAckTimeMicros;
    private long avgServerAckTimeMicros;

    public JMXBackupMonitor(String name) {
        super(BackupMXBean.class, "co.paralleluniverse.galaxy.core:type=Backup");
    }

    @Override
    protected void collectAndResetCounters() {
        this.replicationBackups = (int)this.replicationBackupsCounter.get();
        this.backupPackets = (int)this.backupPacketsCounter.get();
        this.backups = (int)this.backupsCounter.get();
        long microsSinceLastCollect = TimeUnit.MICROSECONDS.convert(this.getMillisSinceLastCollect(), TimeUnit.MILLISECONDS);
        this.avgSlavesAckTimeMicros = this.slavesAckTimeCounter.get() / microsSinceLastCollect;
        this.avgServerAckTimeMicros = this.serverAckTimeCounter.get() / microsSinceLastCollect;
        this.resetCounters();
    }

    @Override
    protected void resetCounters() {
        this.replicationBackupsCounter.reset();
        this.backupsCounter.reset();
        this.backupPacketsCounter.reset();
        this.slavesAckTimeCounter.reset();
        this.serverAckTimeCounter.reset();
    }

    @Override
    public void addReplicationBackup(int num) {
        this.replicationBackupsCounter.add(num);
    }

    @Override
    public void addBackups(int num) {
        this.backupsCounter.add(num);
    }

    @Override
    public void addBackupPacket() {
        this.backupPacketsCounter.inc();
    }

    @Override
    public void addSlaveAckTime(long nanos) {
        this.slavesAckTimeCounter.add(TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS));
    }

    @Override
    public void addServerAckTime(long nanos) {
        this.serverAckTimeCounter.add(TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS));
    }

    @Override
    public long getAvgServerAckTimeMicros() {
        return this.avgServerAckTimeMicros;
    }

    @Override
    public long getAvgSlavesAckTimeMicros() {
        return this.avgSlavesAckTimeMicros;
    }

    @Override
    public int getBackups() {
        return this.backups;
    }

    @Override
    public int getBackupPackets() {
        return this.backupPackets;
    }

    @Override
    public int getReplicationBackups() {
        return this.replicationBackups;
    }
}

