/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.PeriodicMonitor;
import co.paralleluniverse.galaxy.core.CacheMonitor;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.Op;
import co.paralleluniverse.galaxy.monitoring.CacheMXBean;
import co.paralleluniverse.galaxy.monitoring.Counter;
import java.beans.ConstructorProperties;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class JMXCacheMonitor
extends PeriodicMonitor
implements CacheMonitor,
CacheMXBean {
    private static final long[] histogramBins = new long[]{500L, 1000L, 10000L, 100000L};
    private final EnumMap<Message.Type, MessageMonitor> messageMonitors = new EnumMap(Message.Type.class);
    private final EnumMap<Op.Type, OpMonitor> opMonitors = new EnumMap(Op.Type.class);
    private final EnumMap<CacheMonitor.MessageDelayReason, DelayedMessageMonitor> messageDelayMonitors = new EnumMap(CacheMonitor.MessageDelayReason.class);
    private final Counter hitsCounter = new Counter();
    private final Counter staleHitsCounter = new Counter();
    private final Counter missesCounter = new Counter();
    private final Counter invalidatesCounter = new Counter();
    private final Counter stalePurgesCounter = new Counter();
    private int hits;
    private int staleHits;
    private int misses;
    private int invalidates;
    private int stalePurges;

    @ConstructorProperties(value={"name"})
    public JMXCacheMonitor(String name) {
        super(CacheMXBean.class, "co.paralleluniverse.galaxy.core:type=Cache");
    }

    @Override
    protected void initCounters() {
        for (Op.Type type : Op.Type.values()) {
            this.opMonitors.put(type, new OpMonitor(histogramBins));
        }
        for (Enum enum_ : Message.Type.values()) {
            this.messageMonitors.put((Message.Type)enum_, new MessageMonitor());
        }
        for (Enum enum_ : CacheMonitor.MessageDelayReason.values()) {
            this.messageDelayMonitors.put((CacheMonitor.MessageDelayReason)enum_, new DelayedMessageMonitor());
        }
    }

    @Override
    protected void collectAndResetCounters() {
        for (MessageMonitor mm : this.messageMonitors.values()) {
            mm.collectAndResetCounters();
        }
        for (OpMonitor om : this.opMonitors.values()) {
            om.collectAndResetCounters();
        }
        for (DelayedMessageMonitor dm : this.messageDelayMonitors.values()) {
            dm.collectAndResetCounters();
        }
        this.hits = (int)this.hitsCounter.get();
        this.staleHits = (int)this.staleHitsCounter.get();
        this.misses = (int)this.missesCounter.get();
        this.invalidates = (int)this.invalidatesCounter.get();
        this.stalePurges = (int)this.stalePurgesCounter.get();
        this.hitsCounter.reset();
        this.staleHitsCounter.reset();
        this.missesCounter.reset();
        this.invalidatesCounter.reset();
        this.stalePurgesCounter.reset();
    }

    @Override
    protected void resetCounters() {
        for (MessageMonitor mm : this.messageMonitors.values()) {
            mm.reset();
        }
        for (OpMonitor om : this.opMonitors.values()) {
            om.reset();
        }
        for (DelayedMessageMonitor dm : this.messageDelayMonitors.values()) {
            dm.reset();
        }
        this.hitsCounter.reset();
        this.staleHitsCounter.reset();
        this.missesCounter.reset();
        this.invalidatesCounter.reset();
        this.stalePurgesCounter.reset();
    }

    @Override
    public void addHit() {
        this.hitsCounter.inc();
    }

    @Override
    public void addStaleHit() {
        this.staleHitsCounter.inc();
    }

    @Override
    public void addMiss() {
        this.missesCounter.inc();
    }

    @Override
    public void addInvalidate(int num) {
        this.invalidatesCounter.add(num);
    }

    @Override
    public void addMessageSent(Message.Type msg) {
        this.messageMonitors.get((Object)msg).addSent();
    }

    @Override
    public void addMessageReceived(Message.Type msg) {
        this.messageMonitors.get((Object)msg).addReceived();
    }

    @Override
    public void addOp(Op.Type type, long durationMicroSeconds) {
        if (durationMicroSeconds > 0L) {
            this.opMonitors.get((Object)type).addOp(durationMicroSeconds);
        }
    }

    @Override
    public void addMessageHandlingDelay(int numDelayed, long totalDelayNanos, CacheMonitor.MessageDelayReason reason) {
        DelayedMessageMonitor m = this.messageDelayMonitors.get((Object)reason);
        m.addMessages(numDelayed);
        m.addDelay(totalDelayNanos);
    }

    @Override
    public void addStalePurge(int num) {
        this.stalePurgesCounter.add(num);
    }

    private int getNumOp(Op.Type ot) {
        return this.opMonitors.get((Object)ot).getNumOps();
    }

    private float[] getOpHistogram(Op.Type ot) {
        return this.opMonitors.get((Object)ot).getHistogram();
    }

    private int getNumMessagesReceived(Message.Type mt) {
        return this.messageMonitors.get((Object)mt).getReceived();
    }

    private int getNumMessagesSent(Message.Type mt) {
        return this.messageMonitors.get((Object)mt).getSent();
    }

    @Override
    public int getNumOpGet() {
        return this.getNumOp(Op.Type.GET);
    }

    @Override
    public float[] getOpHistogramGet() {
        return this.getOpHistogram(Op.Type.GET);
    }

    @Override
    public int getNumOpGetS() {
        return this.getNumOp(Op.Type.GETS);
    }

    @Override
    public float[] getOpHistogramGetS() {
        return this.getOpHistogram(Op.Type.GETS);
    }

    @Override
    public int getNumOpGetX() {
        return this.getNumOp(Op.Type.GETX);
    }

    @Override
    public float[] getOpHistogramGetX() {
        return this.getOpHistogram(Op.Type.GETX);
    }

    @Override
    public int getNumOpSet() {
        return this.getNumOp(Op.Type.SET);
    }

    @Override
    public float[] getOpHistogramSet() {
        return this.getOpHistogram(Op.Type.SET);
    }

    @Override
    public int getNumOpPut() {
        return this.getNumOp(Op.Type.PUT);
    }

    @Override
    public int getNumOpDel() {
        return this.getNumOp(Op.Type.DEL);
    }

    @Override
    public int getNumOpSend() {
        return this.getNumOp(Op.Type.SEND);
    }

    @Override
    public int getNumMessagesReceivedGET() {
        return this.getNumMessagesReceived(Message.Type.GET);
    }

    @Override
    public int getNumMessagesSentGET() {
        return this.getNumMessagesSent(Message.Type.GET);
    }

    @Override
    public int getNumMessagesReceivedGETX() {
        return this.getNumMessagesReceived(Message.Type.GETX);
    }

    @Override
    public int getNumMessagesSentGETX() {
        return this.getNumMessagesSent(Message.Type.GETX);
    }

    @Override
    public int getNumMessagesReceivedPUT() {
        return this.getNumMessagesReceived(Message.Type.PUT);
    }

    @Override
    public int getNumMessagesSentPUT() {
        return this.getNumMessagesSent(Message.Type.PUT);
    }

    @Override
    public int getNumMessagesReceivedPUTX() {
        return this.getNumMessagesReceived(Message.Type.PUTX);
    }

    @Override
    public int getNumMessagesSentPUTX() {
        return this.getNumMessagesSent(Message.Type.PUTX);
    }

    @Override
    public int getNumMessagesReceivedINV() {
        return this.getNumMessagesReceived(Message.Type.INV);
    }

    @Override
    public int getNumMessagesSentINV() {
        return this.getNumMessagesSent(Message.Type.INV);
    }

    @Override
    public int getNumMessagesReceivedINVACK() {
        return this.getNumMessagesReceived(Message.Type.INVACK);
    }

    @Override
    public int getNumMessagesSentINVACK() {
        return this.getNumMessagesSent(Message.Type.INVACK);
    }

    @Override
    public int getNumMessagesReceivedCHNGD_OWNR() {
        return this.getNumMessagesReceived(Message.Type.CHNGD_OWNR);
    }

    @Override
    public int getNumMessagesSentCHNGD_OWNR() {
        return this.getNumMessagesSent(Message.Type.CHNGD_OWNR);
    }

    @Override
    public int getNumMessagesReceivedMSG() {
        return this.getNumMessagesReceived(Message.Type.MSG);
    }

    @Override
    public int getNumMessagesSentMSG() {
        return this.getNumMessagesSent(Message.Type.MSG);
    }

    @Override
    public int getNumMessagesReceivedMSGACK() {
        return this.getNumMessagesReceived(Message.Type.MSGACK);
    }

    @Override
    public int getNumMessagesSentMSGACK() {
        return this.getNumMessagesSent(Message.Type.MSGACK);
    }

    @Override
    public int getNumMessagesDelayedDueLock() {
        return this.messageDelayMonitors.get((Object)CacheMonitor.MessageDelayReason.LOCK).getMessages();
    }

    @Override
    public long getTotalMicrosecondDelayPerSecondDueLock() {
        return this.messageDelayMonitors.get((Object)CacheMonitor.MessageDelayReason.LOCK).getTotalMicrosecondDelayPerSecond();
    }

    @Override
    public int getNumMessagesDelayedDueBackup() {
        return this.messageDelayMonitors.get((Object)CacheMonitor.MessageDelayReason.BACKUP).getMessages();
    }

    @Override
    public long getTotalMicrosecondDelayPerSecondDueBackup() {
        return this.messageDelayMonitors.get((Object)CacheMonitor.MessageDelayReason.BACKUP).getTotalMicrosecondDelayPerSecond();
    }

    @Override
    public int getNumMessagesDelayedDueOther() {
        return this.messageDelayMonitors.get((Object)CacheMonitor.MessageDelayReason.OTHER).getMessages();
    }

    @Override
    public long getTotalMicrosecondDelayPerSecondDueOther() {
        return this.messageDelayMonitors.get((Object)CacheMonitor.MessageDelayReason.OTHER).getTotalMicrosecondDelayPerSecond();
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public int getStaleHits() {
        return this.staleHits;
    }

    @Override
    public int getMisses() {
        return this.misses;
    }

    @Override
    public int getInvalidates() {
        return this.invalidates;
    }

    private class DelayedMessageMonitor {
        private final Counter messagesCounter = new Counter();
        private final Counter delayCounter = new Counter();
        private int messages;
        private long totalDelay;

        private DelayedMessageMonitor() {
        }

        void addDelay(long nanos) {
            this.delayCounter.add(TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS));
        }

        void addMessages(int num) {
            this.messagesCounter.add(num);
        }

        int getMessages() {
            return this.messages;
        }

        long getTotalMicrosecondDelayPerSecond() {
            return this.totalDelay;
        }

        void collectAndResetCounters() {
            this.collect();
            this.reset();
        }

        void collect() {
            this.messages = (int)this.messagesCounter.get();
            double secondsSinceLast = (double)JMXCacheMonitor.this.getMillisSinceLastCollect() / 1000.0;
            this.totalDelay = (long)((double)this.delayCounter.get() / secondsSinceLast);
        }

        void reset() {
            this.messagesCounter.reset();
            this.messagesCounter.reset();
        }
    }

    private static class OpMonitor {
        private final Counter numOpsCounter = new Counter();
        private final AtomicLong maxTimeCounter = new AtomicLong();
        private final long[] histogramBins;
        private final Counter[] histogramCounters;
        private int numOps;
        private long maxTime;
        private final long[] rawHistogram;
        private final float[] histogram;

        OpMonitor(long ... histogramBins) {
            this.histogramBins = histogramBins;
            this.histogramCounters = new Counter[histogramBins.length + 1];
            this.rawHistogram = new long[this.histogramCounters.length];
            this.histogram = new float[this.histogramCounters.length];
            for (int i = 0; i < this.histogramCounters.length; ++i) {
                this.histogramCounters[i] = new Counter();
            }
        }

        int getNumOps() {
            return this.numOps;
        }

        synchronized long getMaxTime() {
            return this.maxTime;
        }

        synchronized float[] getHistogram() {
            return this.histogram;
        }

        void addOp(long duration) {
            long currentMax;
            this.numOpsCounter.inc();
            if (duration == 0L) {
                this.histogramCounters[0].inc();
                return;
            }
            while (duration > (currentMax = this.maxTimeCounter.get()) && !this.maxTimeCounter.compareAndSet(currentMax, duration)) {
            }
            for (int i = 0; i < this.histogramBins.length; ++i) {
                if (duration >= this.histogramBins[i]) continue;
                this.histogramCounters[i].inc();
                return;
            }
            this.histogramCounters[this.histogramBins.length].inc();
        }

        void collectAndResetCounters() {
            this.collect();
            this.reset();
        }

        synchronized void collect() {
            int i;
            this.numOps = (int)this.numOpsCounter.get();
            this.maxTime = this.maxTimeCounter.get();
            long sum = 0L;
            for (i = 0; i < this.rawHistogram.length; ++i) {
                long val = this.histogramCounters[i].get();
                sum += val;
                this.rawHistogram[i] = val;
            }
            for (i = 0; i < this.histogram.length; ++i) {
                this.histogram[i] = (float)((double)this.rawHistogram[i] / (double)sum * 100.0);
            }
        }

        void reset() {
            this.numOpsCounter.reset();
            this.maxTimeCounter.set(0L);
            for (Counter histogramCounter : this.histogramCounters) {
                histogramCounter.reset();
            }
        }
    }

    private static class MessageMonitor {
        private final Counter messagesSentCounter = new Counter();
        private final Counter messagesReceivedCounter = new Counter();
        private int messagesSent;
        private int messagesReceived;

        private MessageMonitor() {
        }

        void addSent() {
            this.messagesSentCounter.inc();
        }

        void addReceived() {
            this.messagesReceivedCounter.inc();
        }

        int getSent() {
            return this.messagesSent;
        }

        int getReceived() {
            return this.messagesReceived;
        }

        void collectAndResetCounters() {
            this.collect();
            this.reset();
        }

        void collect() {
            this.messagesSent = (int)this.messagesSentCounter.get();
            this.messagesReceived = (int)this.messagesReceivedCounter.get();
        }

        void reset() {
            this.messagesSentCounter.reset();
            this.messagesReceivedCounter.reset();
        }
    }
}

