/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.PeriodicMonitor;
import co.paralleluniverse.galaxy.core.CacheStorage;
import co.paralleluniverse.galaxy.core.LocalStorageMonitor;
import co.paralleluniverse.galaxy.monitoring.Counter;
import co.paralleluniverse.galaxy.monitoring.LocalStorageMXBean;
import java.lang.ref.WeakReference;

class JMXLocalStorageMonitor
extends PeriodicMonitor
implements LocalStorageMonitor,
LocalStorageMXBean {
    private final WeakReference<CacheStorage> localStorage;
    private final Counter allocatedCounter = new Counter();
    private final Counter deallocatedCounter = new Counter();
    private int allocated;
    private int deallocated;

    public JMXLocalStorageMonitor(String name, CacheStorage localStorage) {
        this(LocalStorageMXBean.class, name, localStorage);
    }

    protected JMXLocalStorageMonitor(Class mbean, String name, CacheStorage localStorage) {
        super(mbean, "co.paralleluniverse.galaxy.core:type=LocalStorage");
        this.localStorage = new WeakReference<CacheStorage>(localStorage);
        this.setMonitoredObject(localStorage);
    }

    @Override
    protected void initCounters() {
    }

    @Override
    protected void collectAndResetCounters() {
        this.allocated = (int)this.allocatedCounter.get();
        this.deallocated = (int)this.deallocatedCounter.get();
        this.allocatedCounter.reset();
        this.deallocatedCounter.reset();
    }

    @Override
    protected void resetCounters() {
        this.allocatedCounter.reset();
        this.deallocatedCounter.reset();
    }

    @Override
    public void allocated(int size) {
        this.allocatedCounter.add(size);
    }

    @Override
    public void deallocated(int size) {
        this.deallocatedCounter.add(size);
    }

    @Override
    public int getAllocated() {
        return this.allocated;
    }

    @Override
    public int getDeallocated() {
        return this.deallocated;
    }

    @Override
    public long getTotalMemory() {
        CacheStorage _localStorage = (CacheStorage)this.localStorage.get();
        return _localStorage != null ? _localStorage.getTotalAllocatedSize() : 0L;
    }
}

