/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.PeriodicMonitor;
import co.paralleluniverse.galaxy.core.MainMemoryMonitor;
import co.paralleluniverse.galaxy.monitoring.Counter;
import co.paralleluniverse.galaxy.monitoring.MainMemoryMXBean;
import java.beans.ConstructorProperties;

class JMXMainMemoryMonitor
extends PeriodicMonitor
implements MainMemoryMonitor,
MainMemoryMXBean {
    private final Counter writesCounter = new Counter();
    private final Counter transactionsCounter = new Counter();
    private final Counter objectsServedCounter = new Counter();
    private final Counter ownerWritesCounter = new Counter();
    private final Counter ownersServedCounter = new Counter();
    private final Counter allocationCounter = new Counter();
    private long writes;
    private long transactions;
    private long objectsServed;
    private long ownerWrites;
    private long ownersServed;
    private long allocations;

    @ConstructorProperties(value={"name"})
    public JMXMainMemoryMonitor(String name) {
        super(MainMemoryMXBean.class, "co.paralleluniverse.galaxy.core:type=MainMemory");
    }

    @Override
    protected void collectAndResetCounters() {
        this.writes = this.writesCounter.get();
        this.transactions = this.transactionsCounter.get();
        this.objectsServed = this.objectsServedCounter.get();
        this.ownerWrites = this.ownerWritesCounter.get();
        this.ownersServed = this.ownersServedCounter.get();
        this.allocations = this.allocationCounter.get();
        this.resetCounters();
    }

    @Override
    protected void resetCounters() {
        this.writesCounter.reset();
        this.transactionsCounter.reset();
        this.objectsServedCounter.reset();
        this.ownerWritesCounter.reset();
        this.ownersServedCounter.reset();
        this.allocationCounter.reset();
    }

    @Override
    public void addTransaction(int numWrites) {
        this.transactionsCounter.inc();
        this.writesCounter.add(numWrites);
    }

    @Override
    public void addObjectServed() {
        this.objectsServedCounter.inc();
    }

    @Override
    public void addOwnerWrite() {
        this.ownerWritesCounter.inc();
    }

    @Override
    public void addOwnerServed() {
        this.ownersServedCounter.inc();
    }

    @Override
    public void addAllocation(int count) {
        this.allocationCounter.add(count);
    }

    @Override
    public int getObjectsServed() {
        return (int)this.objectsServed;
    }

    @Override
    public int getOwnerWrites() {
        return (int)this.ownerWrites;
    }

    @Override
    public int getOwnersServed() {
        return (int)this.ownersServed;
    }

    @Override
    public int getTransactions() {
        return (int)this.transactions;
    }

    @Override
    public int getWrites() {
        return (int)this.writes;
    }

    @Override
    public int getAllocations() {
        return (int)this.allocations;
    }
}

