/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.galaxy.core.CacheStorage;
import co.paralleluniverse.galaxy.core.JMXLocalStorageMonitor;
import co.paralleluniverse.galaxy.core.OffHeapLocalStorageMonitor;
import co.paralleluniverse.galaxy.monitoring.Counter;
import co.paralleluniverse.galaxy.monitoring.OffHeapLocalStorageMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

class JMXOffHeapLocalStorageMonitor
extends JMXLocalStorageMonitor
implements OffHeapLocalStorageMonitor,
OffHeapLocalStorageMXBean {
    private final Integer[] bins;
    private final BinCounters[] binCounters;

    public JMXOffHeapLocalStorageMonitor(String name, CacheStorage storage, int[] bins) {
        super(OffHeapLocalStorageMXBean.class, name, storage);
        this.bins = new Integer[bins.length];
        this.binCounters = new BinCounters[bins.length];
        for (int i = 0; i < bins.length; ++i) {
            this.bins[i] = bins[i];
            this.binCounters[i] = new BinCounters();
        }
    }

    @Override
    protected void collectAndResetCounters() {
        super.collectAndResetCounters();
        for (BinCounters bc : this.binCounters) {
            bc.collectAndReset();
        }
    }

    @Override
    protected void resetCounters() {
        super.resetCounters();
        for (BinCounters bc : this.binCounters) {
            bc.reset();
        }
    }

    @Override
    public void allocated(int bin, int size) {
        super.allocated(size);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deallocated(int bin, int size) {
        super.deallocated(size);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<Integer, Integer> getBinsAllocated() {
        HashMap<Integer, Integer> table = new HashMap<Integer, Integer>(this.binCounters.length);
        for (int i = 0; i < this.binCounters.length; ++i) {
            table.put(this.bins[i], this.binCounters[i].allocated);
        }
        return table;
    }

    @Override
    public Map<Integer, Integer> getBinsDeallocated() {
        HashMap<Integer, Integer> table = new HashMap<Integer, Integer>(this.binCounters.length);
        for (int i = 0; i < this.binCounters.length; ++i) {
            table.put(this.bins[i], this.binCounters[i].deallocated);
        }
        return table;
    }

    @Override
    public Map<Integer, Long> getBinsTotalMemory() {
        HashMap<Integer, Long> table = new HashMap<Integer, Long>(this.binCounters.length);
        for (int i = 0; i < this.binCounters.length; ++i) {
            table.put(this.bins[i], this.binCounters[i].totalSize.get());
        }
        return table;
    }

    private static class BinCounters {
        public final AtomicLong totalSize = new AtomicLong();
        public final Counter allocatedCounter = new Counter();
        public final Counter deallocatedCounter = new Counter();
        public int allocated;
        public int deallocated;

        private BinCounters() {
        }

        public void collectAndReset() {
            this.allocated = (int)this.allocatedCounter.get();
            this.deallocated = (int)this.deallocatedCounter.get();
            this.allocatedCounter.reset();
            this.deallocatedCounter.reset();
        }

        public void reset() {
            this.allocatedCounter.reset();
            this.deallocatedCounter.reset();
        }
    }
}

