/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.MonitoringType;
import co.paralleluniverse.common.io.Persistables;
import co.paralleluniverse.common.logging.LoggingUtils;
import co.paralleluniverse.common.util.DegenerateInvocationHandler;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.core.Cache;
import co.paralleluniverse.galaxy.core.ClusterService;
import co.paralleluniverse.galaxy.core.Comm;
import co.paralleluniverse.galaxy.core.JMXMainMemoryMonitor;
import co.paralleluniverse.galaxy.core.MainMemoryMonitor;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.MessageReceiver;
import co.paralleluniverse.galaxy.core.MetricsMainMemoryMonitor;
import co.paralleluniverse.galaxy.core.NodeNotFoundException;
import co.paralleluniverse.galaxy.server.MainMemoryDB;
import co.paralleluniverse.galaxy.server.MainMemoryEntry;
import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMemory
extends ClusterService
implements MessageReceiver,
NodeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(MainMemory.class);
    private static final long INITIAL_REF_ID = 0x100000000L;
    private static final short SERVER = 0;
    private final Comm comm;
    private final MainMemoryDB store;
    private final MainMemoryMonitor monitor;
    private final AtomicLong refCounter = new AtomicLong();

    @ConstructorProperties(value={"name", "cluster", "store", "comm", "monitoringType"})
    public MainMemory(String name, Cluster cluster, MainMemoryDB store, Comm comm, MonitoringType monitoringType) {
        this(name, cluster, store, comm, MainMemory.createMonitor(monitoringType, name));
    }

    MainMemory(String name, Cluster cluster, MainMemoryDB store, Comm comm, MainMemoryMonitor monitor) {
        super(name, cluster);
        this.comm = comm;
        this.store = store;
        this.monitor = monitor;
        monitor.setMonitoredObject(this);
        cluster.addNodeChangeListener(this);
        comm.setReceiver(this);
    }

    @Override
    protected void start(boolean master) {
        if (master) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Performing store dump:");
                this.store.dump(System.err);
            }
            this.refCounter.set(Math.max(0x100000000L, this.store.getMaxId() + 1L));
        }
        this.setReady(true);
    }

    @Override
    public void switchToMaster() {
        super.switchToMaster();
    }

    @Override
    protected void shutdown() {
        this.store.close();
    }

    private static MainMemoryMonitor createMonitor(MonitoringType monitoringType, String name) {
        if (monitoringType == null) {
            return (MainMemoryMonitor)Proxy.newProxyInstance(MainMemory.class.getClassLoader(), new Class[]{MainMemoryMonitor.class}, (InvocationHandler)DegenerateInvocationHandler.INSTANCE);
        }
        switch (monitoringType) {
            case JMX: {
                return new JMXMainMemoryMonitor(name);
            }
            case METRICS: {
                return new MetricsMainMemoryMonitor();
            }
        }
        throw new IllegalArgumentException("Unknown MonitoringType " + (Object)((Object)monitoringType));
    }

    @Override
    public void receive(Message message) {
        LOG.debug("Received: {}", (Object)message);
        switch (message.getType()) {
            case GET: 
            case GETX: {
                this.handleMessageGet((Message.GET)message);
                break;
            }
            case INV: {
                this.handleMessageInvalidate((Message.INV)message);
                break;
            }
            case DEL: {
                this.handleMessageDelete((Message.LineMessage)message);
                break;
            }
            case MSG: {
                this.handleMessageMsg((Message.MSG)message);
                break;
            }
            case BACKUP_PACKET: {
                this.handleMessageBackup((Message.BACKUP_PACKET)message);
                break;
            }
            case INVOKE: {
                this.handleMessageGet((Message.LineMessage)message);
                break;
            }
            case ALLOC_REF: {
                this.handleMessageAllocRef((Message.ALLOC_REF)message);
            }
        }
    }

    void send(Message message) {
        LOG.debug("Sending: {}", (Object)message);
        try {
            this.comm.send(message);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
    }

    private boolean handleMessageGet(Message.LineMessage msg) {
        long id = msg.getLine();
        while (true) {
            if (Cache.isReserved(id) && this.store.casOwner(id, (short)-1, msg.getNode()) == msg.getNode()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Owner of reserved line {} is now node {} (CAS)", (Object)LoggingUtils.hex(id), (Object)msg.getNode());
                }
                this.monitor.addOwnerWrite();
                this.monitor.addObjectServed();
                this.store.write(id, msg.getNode(), 1L, new byte[0], null);
                this.send(Message.PUTX(msg, id, new short[0], 0, 1L, null));
                return true;
            }
            short owner = this.store.casOwner(id, (short)0, msg.getNode());
            if (owner == msg.getNode()) {
                MainMemoryEntry entry = this.store.read(id);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Owner of line {} is now node {} (previously owned by server)", (Object)LoggingUtils.hex(id), (Object)msg.getNode());
                }
                this.monitor.addOwnerWrite();
                this.monitor.addObjectServed();
                this.send(Message.PUTX(msg, id, new short[0], 0, entry.version, ByteBuffer.wrap(entry.data)));
                return true;
            }
            if (owner == -1 && !Cache.isReserved(id)) {
                owner = this.store.findAllocation(id);
            }
            if (owner == -1 && !Cache.isReserved(id)) {
                this.send(Message.NOT_FOUND(msg));
                return false;
            }
            if (owner > 0) {
                this.send(Message.CHNGD_OWNR(msg, id, owner, true));
                this.monitor.addOwnerServed();
                return false;
            }
            LOG.debug("casOwner returned {}", (Object)owner);
        }
    }

    private void handleMessageInvalidate(Message.INV msg) {
        long id = msg.getLine();
        short owner = msg.getNode();
        short previousOwner = msg.getPreviousOwner();
        short currentOwner = this.store.casOwner(id, previousOwner, owner);
        if (currentOwner == owner) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got INV: Owner of line {} is now node {}", (Object)LoggingUtils.hex(id), (Object)msg.getNode());
            }
            this.monitor.addOwnerWrite();
            this.send(Message.INVACK(msg));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got INV of line {} from {}, but different owner ({}) listed so replying INV", new Object[]{LoggingUtils.hex(id), msg.getNode(), currentOwner});
            }
            this.monitor.addOwnerServed();
            this.send(Message.INV(msg, id, currentOwner));
        }
    }

    private void handleMessageDelete(Message.LineMessage msg) {
        long id = msg.getLine();
        short owner = msg.getNode();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Line {} deleted.", (Object)LoggingUtils.hex(id));
        }
        Object txn = this.store.beginTransaction();
        try {
            this.store.delete(id, txn);
            this.store.commit(txn);
            this.send(Message.INVACK(msg));
        }
        catch (Exception e) {
            LOG.error("Exception during delete. Aborting transaction.", (Throwable)e);
            this.store.abort(txn);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void handleMessageMsg(Message.MSG msg) {
        long id = msg.getLine();
        if (this.handleMessageGet(msg)) {
            this.send(Message.MSG(msg.getNode(), id, msg.isMessenger(), msg.getData()));
        }
    }

    private void handleMessageBackup(Message.BACKUP_PACKET msg) {
        Object txn = this.store.beginTransaction();
        try {
            this.monitor.addTransaction(msg.getBackups().size());
            for (Message.BACKUP backup : msg.getBackups()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Backing up version {} of line {} data: {}", new Object[]{backup.getVersion(), LoggingUtils.hex(backup.getLine()), backup.getData() != null ? "(" + backup.getData().remaining() + " bytes)" : "null"});
                }
                this.store.write(backup.getLine(), msg.getNode(), backup.getVersion(), Persistables.toByteArray(backup.getData()), txn);
            }
            this.store.commit(txn);
            this.send(Message.BACKUP_PACKETACK(msg));
        }
        catch (Exception e) {
            LOG.error("Exception during DB operation. Aborting transaction.", (Throwable)e);
            this.store.abort(txn);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void handleMessageAllocRef(Message.ALLOC_REF msg) {
        int num = msg.getNum();
        long end = this.refCounter.addAndGet(num);
        long start = end - (long)num;
        this.store.allocate(msg.getNode(), start, num);
        this.send(Message.ALLOCED_REF(msg, start, num));
        this.monitor.addAllocation(num);
    }

    @Override
    public void nodeRemoved(short node) {
        LOG.info("Node {} removed. Server now owns its lines.", (Object)node);
        this.store.removeOwner(node);
    }

    @Override
    public void nodeAdded(short id) {
    }

    @Override
    public void nodeSwitched(short id) {
    }
}

