/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.io.Persistables;
import co.paralleluniverse.common.io.Streamable;
import co.paralleluniverse.common.io.Streamables;
import co.paralleluniverse.common.util.Enums;
import co.paralleluniverse.galaxy.LineFunction;
import co.paralleluniverse.io.serialization.Serialization;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
implements Streamable,
Externalizable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Message.class);
    private static final byte FLAG_RESPONSE = 1;
    private static final byte FLAG_BROADCAST = 2;
    private static final byte FLAG_REPLY_REQUIRED = 4;
    private Type type;
    private byte flags;
    private long messageId = -1L;
    private transient boolean incoming;
    private transient short node;
    private transient long timestamp;

    public static INVOKE INVOKE(short node, long line, LineFunction data) {
        return new INVOKE(Type.INVOKE, node, line, data);
    }

    public static INVRES INVRES(LineMessage responseTo, long line, Object result) {
        return new INVRES(responseTo, line, result);
    }

    public static GET GET(short node, long line) {
        return new GET(Type.GET, node, line);
    }

    public static GET GETX(short node, long line) {
        return new GET(Type.GETX, node, line);
    }

    public static PUT PUT(LineMessage responseTo, long line, long version, ByteBuffer data) {
        return new PUT(responseTo, line, version, data);
    }

    public static PUT PUT(short node, long line, long version, ByteBuffer data) {
        return new PUT(node, line, version, data);
    }

    public static PUT PUT(short[] nodes, long line, long version, ByteBuffer data) {
        return new PUT(nodes, line, version, data);
    }

    public static PUTX PUTX(LineMessage responseTo, long line, short[] sharers, int messages, long version, ByteBuffer data) {
        return new PUTX(responseTo, line, sharers, messages, version, data);
    }

    public static PUTX PUTX(short node, long line, short[] sharers, int messages, long version, ByteBuffer data) {
        return new PUTX(node, line, sharers, messages, version, data);
    }

    public static LineMessage DEL(short node, long line) {
        return new LineMessage(node, Type.DEL, line);
    }

    public static INV INV(short node, long line, short previousOwner) {
        return new INV(node, line, previousOwner);
    }

    public static INV INV(LineMessage responseTo, long line, short previousOwner) {
        return new INV(responseTo, line, previousOwner);
    }

    public static LineMessage INVACK(LineMessage responseTo) {
        return new LineMessage(responseTo, Type.INVACK, responseTo.getLine());
    }

    public static LineMessage INVACK(short node, long line) {
        return new LineMessage(node, Type.INVACK, line);
    }

    public static CHNGD_OWNR CHNGD_OWNR(short node, long line, short newOwner, boolean certain) {
        return new CHNGD_OWNR(node, line, newOwner, certain);
    }

    public static CHNGD_OWNR CHNGD_OWNR(LineMessage responseTo, long line, short newOwner, boolean certain) {
        return new CHNGD_OWNR(responseTo, line, newOwner, certain);
    }

    public static LineMessage NOT_FOUND(LineMessage responseTo) {
        return new LineMessage(responseTo, Type.NOT_FOUND);
    }

    public static BACKUP BACKUP(long line, long version, ByteBuffer data) {
        return new BACKUP(0, line, version, data);
    }

    public static BACKUPACK BACKUPACK(short node, long line, long version) {
        return new BACKUPACK(node, line, version);
    }

    public static BACKUP_PACKET BACKUP_PACKET(long id, Collection<BACKUP> backups) {
        return new BACKUP_PACKET(id, backups);
    }

    public static BACKUP_PACKETACK BACKUP_PACKETACK(BACKUP_PACKET responseTo) {
        return new BACKUP_PACKETACK(responseTo);
    }

    public static ALLOC_REF ALLOC_REF(short node, int num) {
        return new ALLOC_REF(node, num);
    }

    public static ALLOCED_REF ALLOCED_REF(ALLOC_REF responseTo, long start, int num) {
        return new ALLOCED_REF(responseTo, start, num);
    }

    public static MSG MSG(MSG responseTo, byte[] data) {
        return new MSG(responseTo, data);
    }

    public static MSG MSG(short node, long line, boolean messenger, byte[] data) {
        return new MSG(node, line, messenger, data);
    }

    public static MSG MSG(short[] nodes, long line, boolean messenger, byte[] data) {
        return new MSG(nodes, line, messenger, data);
    }

    public static MSG MSG(short node, long line, boolean messenger, boolean pending, byte[] data) {
        return new MSG(node, line, messenger, pending, data);
    }

    public static MSG MSG(short[] nodes, long line, boolean messenger, boolean pending, byte[] data) {
        return new MSG(nodes, line, messenger, pending, data);
    }

    public static LineMessage MSGACK(MSG responseTo) {
        return new LineMessage(responseTo, Type.MSGACK);
    }

    public static LineMessage TIMEOUT(LineMessage responseTo) {
        return new LineMessage(responseTo, Type.TIMEOUT);
    }

    public static Message ACK(Message responseTo) {
        return new Message(responseTo, Type.ACK);
    }

    public static Message readMessage(DataInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        Message message = Message.newMessage(type);
        message.read(in);
        return message;
    }

    public static Message fromByteArray(byte[] array) {
        Type type = Type.values()[array[0]];
        Message message = Message.newMessage(type);
        message.read(array, 1);
        return message;
    }

    public static Message fromByteBuffer(ByteBuffer buffer) {
        Type type = Type.values()[buffer.get()];
        if (LOG.isDebugEnabled()) {
            LOG.debug("from ByteBuffer type:" + type.name());
        }
        Message message = Message.newMessage(type);
        message.read(buffer);
        return message;
    }

    public static Message newMessage(Type type) {
        switch (type) {
            case INV: {
                return new INV();
            }
            case GET: 
            case GETX: {
                return new GET(type);
            }
            case PUT: {
                return new PUT(type);
            }
            case PUTX: {
                return new PUTX();
            }
            case CHNGD_OWNR: {
                return new CHNGD_OWNR();
            }
            case BACKUP: {
                return new BACKUP();
            }
            case BACKUPACK: {
                return new BACKUPACK();
            }
            case BACKUP_PACKET: {
                return new BACKUP_PACKET();
            }
            case BACKUP_PACKETACK: {
                return new BACKUP_PACKETACK();
            }
            case ALLOC_REF: {
                return new ALLOC_REF();
            }
            case ALLOCED_REF: {
                return new ALLOCED_REF();
            }
            case MSG: {
                return new MSG();
            }
            case ACK: {
                return new Message(type);
            }
            case DEL: 
            case INVACK: 
            case NOT_FOUND: 
            case MSGACK: 
            case TIMEOUT: {
                return new LineMessage(type);
            }
            case INVOKE: {
                return new INVOKE(type);
            }
            case INVRES: {
                return new INVRES(type);
            }
        }
        throw new RuntimeException("Unrecognized message: " + (Object)((Object)type));
    }

    Message(Type type) {
        this.type = type;
        this.incoming = true;
    }

    public Message(Message responseTo, Type type) {
        this.incoming = false;
        this.node = responseTo.getNode();
        this.type = type;
        this.messageId = responseTo.messageId;
        this.flags = 1;
    }

    public Message(short node, Type type) {
        this.incoming = false;
        this.node = node;
        this.type = type;
        this.setBroadcast(node == -1);
        this.setReplyRequired(true);
    }

    public Message(short[] nodes, Type type) {
        this.incoming = false;
        Arrays.sort(nodes);
        this.node = (short)-1;
        this.type = type;
        this.setReplyRequired(true);
    }

    public Message clone() {
        try {
            return (Message)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (this.incoming == other.incoming || this.isResponse() == other.isResponse()) {
            return super.equals(obj);
        }
        if (this.messageId != other.messageId) {
            return false;
        }
        if (this.node >= 0 && other.node >= 0) {
            return this.node == other.node;
        }
        if (this.isBroadcast()) {
            assert (!other.isBroadcast() & !this.isResponse() & other.isResponse());
            return true;
        }
        if (other.isBroadcast()) {
            assert (!this.isBroadcast() & !other.isResponse() & this.isResponse());
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (int)(this.messageId ^ this.messageId >>> 32);
        return hash;
    }

    public final String toString() {
        return this.partialToString() + ']';
    }

    protected String partialToString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append((Object)this.type).append(' ');
        sb.append(this.incoming ? "IN" : "OUT");
        sb.append(" #").append(this.messageId >= 0L ? Long.valueOf(this.messageId) : "_");
        if (this.isResponse()) {
            sb.append('R');
        }
        if (this.incoming && this.isBroadcast()) {
            sb.append(" BCAST");
        }
        sb.append(' ').append(this.incoming ? "FROM " : "TO ");
        sb.append(this.node);
        if (!this.isResponse() && !this.isReplyRequired()) {
            sb.append(' ').append("(NO REP REQ)");
        }
        return sb.toString();
    }

    public short getNode() {
        return this.node;
    }

    public Message setNode(short node) {
        this.node = node;
        if (!this.incoming) {
            this.setBroadcast(node == -1);
        }
        return this;
    }

    public Message setIncoming() {
        this.incoming = true;
        return this;
    }

    public Message setOutgoing() {
        this.incoming = false;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Message setMessageId(long messageId) {
        this.messageId = messageId;
        return this;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public boolean isResponse() {
        return (this.flags & 1) != 0;
    }

    private Message setBroadcast(boolean value) {
        assert (!this.incoming);
        this.flags = (byte)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
        return this;
    }

    public boolean isBroadcast() {
        return (this.flags & 2) != 0;
    }

    public final Message setReplyRequired(boolean value) {
        assert (!this.incoming);
        this.flags = (byte)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
        return this;
    }

    public boolean isReplyRequired() {
        return (this.flags & 4) != 0;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException {
        this.type = Type.values()[in.read()];
        this.read(in);
    }

    private Streamable streamableNoBuffers() {
        return new Streamable(){

            @Override
            public int size() {
                return Message.this.size1();
            }

            @Override
            public void write(DataOutput out) throws IOException {
                Message.this.write1(out);
            }

            @Override
            public void read(DataInput in) throws IOException {
                Message.this.read1(in);
            }
        };
    }

    @Override
    public final int size() {
        int size = this.size1();
        for (int i = 0; i < this.getNumDataBuffers(); ++i) {
            int remaining = this.getDataBuffer(i) == null ? 0 : this.getDataBuffer(i).remaining();
            size += 2 + remaining;
        }
        return size;
    }

    @Override
    public final void write(DataOutput out) throws IOException {
        this.write1(out);
        for (int i = 0; i < this.getNumDataBuffers(); ++i) {
            ByteBuffer buffer = this.getDataBuffer(i);
            out.writeShort(Message.verifyShort(buffer.remaining()));
            Streamables.writeBuffer(out, buffer);
            buffer.rewind();
        }
    }

    @Override
    public final void read(DataInput in) throws IOException {
        this.read1(in);
        for (int i = 0; i < this.getNumDataBuffers(); ++i) {
            int size = in.readUnsignedShort();
            byte[] array = new byte[size];
            in.readFully(array);
            ByteBuffer buffer = ByteBuffer.wrap(array);
            this.setDataBuffer(i, buffer);
        }
    }

    public byte[] toByteArray() {
        return Streamables.toByteArray(this);
    }

    public void read(byte[] array, int offset) {
        Streamables.fromByteArray(this.streamableNoBuffers(), array, offset);
        offset = this.size1();
        for (int i = 0; i < this.getNumDataBuffers(); ++i) {
            int size = Ints.fromBytes((byte)0, (byte)0, (byte)array[offset], (byte)array[offset + 1]);
            ByteBuffer buffer = ByteBuffer.wrap(array, offset += 2, size).slice();
            this.setDataBuffer(i, buffer);
            offset += size;
        }
    }

    public ByteBuffer[] toByteBuffers() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("to bb type " + this.type.name());
        }
        ByteBuffer buffer0 = ByteBuffer.allocate(this.size1() + 2 * this.getNumDataBuffers());
        Persistables.persistable(this.streamableNoBuffers()).write(buffer0);
        for (int i = 0; i < this.getNumDataBuffers(); ++i) {
            buffer0.putShort(this.getDataBuffer(i) != null ? Message.verifyShort(this.getDataBuffer(i).remaining()) : (short)0);
        }
        buffer0.flip();
        ByteBuffer[] buffers = new ByteBuffer[1 + this.getNumDataBuffers()];
        buffers[0] = buffer0;
        for (int i = 0; i < this.getNumDataBuffers(); ++i) {
            buffers[1 + i] = this.getDataBuffer(i);
        }
        return buffers;
    }

    public void read(ByteBuffer buffer) {
        Persistables.persistable(this.streamableNoBuffers()).read(buffer);
        int n = this.getNumDataBuffers();
        int lengthsPosition = buffer.position();
        buffer.position(buffer.position() + 2 * n);
        for (int i = 0; i < n; ++i) {
            int size = buffer.getShort(lengthsPosition) & 0xFFFF;
            lengthsPosition += 2;
            ByteBuffer b1 = Persistables.slice(buffer, size);
            this.setDataBuffer(i, b1);
        }
    }

    public int size1() {
        return 10;
    }

    public void write1(DataOutput out) throws IOException {
        out.writeByte(this.type.ordinal());
        out.writeLong(this.messageId);
        out.writeByte(this.flags);
    }

    public void read1(DataInput in) throws IOException {
        this.messageId = in.readLong();
        this.flags = in.readByte();
    }

    public final Message cloneDataBuffers() {
        for (int i = 0; i < this.getNumDataBuffers(); ++i) {
            ByteBuffer db = this.getDataBuffer(i);
            this.setDataBuffer(i, db == null ? null : Persistables.copyOf(db));
        }
        return this;
    }

    public int getNumDataBuffers() {
        return 0;
    }

    ByteBuffer getDataBuffer(int index) {
        throw new IndexOutOfBoundsException();
    }

    void setDataBuffer(int index, ByteBuffer buffer) {
        throw new IndexOutOfBoundsException();
    }

    private static short verifyShort(int size) {
        if (size >= 131072) {
            throw new RuntimeException("Buffer size (" + size + ") exceeds maximum of " + 131072);
        }
        return (short)size;
    }

    public static class MSG
    extends LineMessage {
        private static final byte MESSENGER = 1;
        private static final byte PENDING = 2;
        private byte[] data;
        private byte flags;

        MSG() {
            super(Type.MSG);
        }

        public MSG(MSG responseTo, byte[] data) {
            super(responseTo, Type.MSG);
            this.flags = 0;
            this.data = data;
        }

        private MSG(short node, long line, boolean messenger, byte[] data) {
            this(node, line, messenger, false, data);
        }

        private MSG(short[] nodes, long line, boolean messenger, byte[] data) {
            this(nodes, line, messenger, false, data);
        }

        private MSG(short node, long line, boolean messenger, boolean pending, byte[] data) {
            super(node, Type.MSG, line);
            this.flags = 0;
            this.flags = (byte)(this.flags | (messenger ? (byte)1 : 0));
            this.flags = (byte)(this.flags | (pending ? 2 : 0));
            this.data = data;
        }

        private MSG(short[] nodes, long line, boolean messenger, boolean pending, byte[] data) {
            super(nodes, Type.MSG, line);
            this.flags = (byte)(this.flags | (messenger ? (byte)1 : 0));
            this.flags = (byte)(this.flags | (pending ? 2 : 0));
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public boolean isMessenger() {
            return (this.flags & 1) != 0;
        }

        public boolean isPending() {
            return (this.flags & 2) != 0;
        }

        public void setPending(boolean value) {
            this.flags = (byte)(this.flags | (value ? 2 : 0));
        }

        @Override
        public int sizeNoHeader() {
            return super.sizeNoHeader() + 2 + 1 + (this.data != null ? this.data.length : 0);
        }

        @Override
        public void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeByte(this.flags);
            out.writeShort(this.data != null ? (int)this.data.length : 0);
            if (this.data != null) {
                out.write(this.data);
            }
        }

        @Override
        public void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            this.flags = in.readByte();
            int dataLen = in.readUnsignedShort();
            if (dataLen == 0) {
                this.data = null;
            } else {
                this.data = new byte[dataLen];
                in.readFully(this.data);
            }
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", messenger: " + this.isMessenger() + ", pending: " + this.isPending() + ", data: " + (this.data == null ? "null" : "(" + this.data.length + " bytes)" + (this.isPending() ? " (pending)" : ""));
        }
    }

    public static class ALLOCED_REF
    extends Message {
        private long start;
        private int num;

        public ALLOCED_REF(ALLOC_REF responseTo, long start, int num) {
            super(responseTo, Type.ALLOCED_REF);
            this.start = start;
            this.num = num;
        }

        public ALLOCED_REF() {
            super(Type.ALLOCED_REF);
        }

        public long getStart() {
            return this.start;
        }

        public int getNum() {
            return this.num;
        }

        @Override
        public int size1() {
            return super.size1() + 8 + 4;
        }

        @Override
        public void write1(DataOutput out) throws IOException {
            super.write1(out);
            out.writeLong(this.start);
            out.writeInt(this.num);
        }

        @Override
        public void read1(DataInput in) throws IOException {
            super.read1(in);
            this.start = in.readLong();
            this.num = in.readInt();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", start: " + Long.toHexString(this.start) + ", num: " + this.num;
        }
    }

    public static class ALLOC_REF
    extends Message {
        private int num;

        public ALLOC_REF(short node, int num) {
            super(node, Type.ALLOC_REF);
            this.num = num;
        }

        public ALLOC_REF() {
            super(Type.ALLOC_REF);
        }

        public int getNum() {
            return this.num;
        }

        @Override
        public int size1() {
            return super.size1() + 4;
        }

        @Override
        public void write1(DataOutput out) throws IOException {
            super.write1(out);
            out.writeInt(this.num);
        }

        @Override
        public void read1(DataInput in) throws IOException {
            super.read1(in);
            this.num = in.readInt();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", num: " + this.num;
        }
    }

    public static class BACKUP_PACKETACK
    extends Message {
        private long id;

        public BACKUP_PACKETACK(BACKUP_PACKET responseTo) {
            super(responseTo, Type.BACKUP_PACKETACK);
            this.id = responseTo.getId();
        }

        public BACKUP_PACKETACK() {
            super(Type.BACKUP_PACKETACK);
        }

        public long getId() {
            return this.id;
        }

        @Override
        public int size1() {
            return super.size1() + 8;
        }

        @Override
        public void write1(DataOutput out) throws IOException {
            super.write1(out);
            out.writeLong(this.id);
        }

        @Override
        public void read1(DataInput in) throws IOException {
            super.read1(in);
            this.id = in.readLong();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", id: " + this.id;
        }
    }

    public static class BACKUP_PACKET
    extends Message {
        private List<BACKUP> backups;
        private long id;

        public BACKUP_PACKET(long id, Collection<BACKUP> backups) {
            super((short)0, Type.BACKUP_PACKET);
            this.backups = ImmutableList.copyOf(backups);
            this.id = id;
        }

        public BACKUP_PACKET() {
            super(Type.BACKUP_PACKET);
        }

        public List<BACKUP> getBackups() {
            return this.backups;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public int getNumDataBuffers() {
            return this.backups.size();
        }

        @Override
        ByteBuffer getDataBuffer(int index) {
            return this.backups.get(index).getData();
        }

        @Override
        void setDataBuffer(int index, ByteBuffer buffer) {
            this.backups.get(index).setData(buffer);
        }

        @Override
        public Message setNode(short node) {
            super.setNode(node);
            for (BACKUP msg : this.backups) {
                msg.setNode(node);
            }
            return this;
        }

        @Override
        public int size1() {
            int size = super.size1() + 8 + 4;
            for (BACKUP msg : this.backups) {
                size += msg.sizeNoHeader();
            }
            return size;
        }

        @Override
        public void write1(DataOutput out) throws IOException {
            super.write1(out);
            out.writeLong(this.id);
            out.writeInt(this.backups.size());
            for (BACKUP msg : this.backups) {
                msg.writeNoHeader(out);
            }
        }

        @Override
        public void read1(DataInput in) throws IOException {
            super.read1(in);
            this.id = in.readLong();
            int num = in.readInt();
            this.backups = new ArrayList<BACKUP>(num);
            for (int i = 0; i < num; ++i) {
                BACKUP backup = new BACKUP();
                backup.readNoHeader(in);
                this.backups.add(backup);
            }
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", id: " + this.id + ", backups: " + this.backups.toString();
        }
    }

    public static class BACKUPACK
    extends LineMessage {
        private long version;

        public BACKUPACK() {
            super(Type.BACKUPACK);
        }

        public BACKUPACK(short node, long line, long version) {
            super(node, Type.BACKUPACK, line);
            this.version = version;
        }

        public long getVersion() {
            return this.version;
        }

        @Override
        public int sizeNoHeader() {
            return super.sizeNoHeader() + 8;
        }

        @Override
        public void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeLong(this.version);
        }

        @Override
        public void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            this.version = in.readLong();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", version: " + this.version;
        }
    }

    public static class BACKUP
    extends PUT {
        public BACKUP() {
            super(Type.BACKUP);
        }

        public BACKUP(short node, long line, long version, ByteBuffer data) {
            super(Type.BACKUP, node, line, version, data);
        }
    }

    public static class CHNGD_OWNR
    extends LineMessage {
        private short newOwner;
        private boolean certain;

        public CHNGD_OWNR() {
            super(Type.CHNGD_OWNR);
        }

        public CHNGD_OWNR(short node, long line, short newOwner, boolean certain) {
            super(node, Type.CHNGD_OWNR, line);
            this.newOwner = newOwner;
            this.certain = certain;
        }

        public CHNGD_OWNR(LineMessage responseTo, long line, short newOwner, boolean certain) {
            super(responseTo, Type.CHNGD_OWNR, line);
            this.newOwner = newOwner;
            this.certain = certain;
        }

        public short getNewOwner() {
            return this.newOwner;
        }

        @Override
        public int sizeNoHeader() {
            return super.sizeNoHeader() + 1 + 2;
        }

        @Override
        public void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeBoolean(this.certain);
            out.writeShort(this.newOwner);
        }

        @Override
        public void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            this.certain = in.readBoolean();
            this.newOwner = in.readShort();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", newOwner: " + this.newOwner + ", certain: " + this.certain;
        }
    }

    public static class PUTX
    extends PUT {
        private int parts;
        private short[] sharers;

        PUTX() {
            super(Type.PUTX);
        }

        public PUTX(LineMessage responseTo, long line, short[] sharers, int parts, long version, ByteBuffer data) {
            super(Type.PUTX, responseTo, line, version, data);
            this.parts = parts;
            this.sharers = sharers;
        }

        public PUTX(short node, long line, short[] sharers, int parts, long version, ByteBuffer data) {
            super(Type.PUTX, node, line, version, data);
            this.parts = parts;
            this.sharers = sharers;
        }

        public short[] getSharers() {
            return this.sharers;
        }

        public int getMessages() {
            return this.parts;
        }

        @Override
        public int sizeNoHeader() {
            return super.sizeNoHeader() + 2 + 2 + 2 * this.sharers.length;
        }

        @Override
        public void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeShort(this.parts);
            out.writeShort(this.sharers.length);
            for (short s : this.sharers) {
                out.writeShort(s);
            }
        }

        @Override
        public void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            this.parts = in.readUnsignedShort();
            int numSharers = in.readUnsignedShort();
            this.sharers = new short[numSharers];
            for (int i = 0; i < numSharers; ++i) {
                this.sharers[i] = in.readShort();
            }
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", sharers: " + Arrays.toString(this.sharers) + ", messages: " + this.parts;
        }
    }

    public static class PUT
    extends LineMessage {
        private long version;
        private ByteBuffer data;

        PUT(Type type) {
            super(type);
        }

        public PUT(LineMessage responseTo, long line, long version, ByteBuffer data) {
            super(responseTo, Type.PUT, line);
            this.data = data;
            this.version = version;
        }

        private PUT(Type type, LineMessage responseTo, long line, long version, ByteBuffer data) {
            super(responseTo, type, line);
            this.data = data;
            this.version = version;
        }

        private PUT(Type type, short node, long line, long version, ByteBuffer data) {
            super(node, type, line);
            this.data = data;
            this.version = version;
        }

        private PUT(Type type, short[] nodes, long line, long version, ByteBuffer data) {
            super(nodes, type, line);
            this.data = data;
            this.version = version;
        }

        public PUT(short node, long line, long version, ByteBuffer data) {
            super(node, Type.PUT, line);
            this.data = data;
            this.version = version;
        }

        public PUT(short[] nodes, long line, long version, ByteBuffer data) {
            super(nodes, Type.PUT, line);
            this.data = data;
            this.version = version;
        }

        public long getVersion() {
            return this.version;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public void setData(ByteBuffer data) {
            this.data = data;
        }

        @Override
        public int getNumDataBuffers() {
            return 1;
        }

        @Override
        ByteBuffer getDataBuffer(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.getData();
        }

        @Override
        void setDataBuffer(int index, ByteBuffer buffer) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.setData(buffer);
        }

        @Override
        int sizeNoHeader() {
            return super.sizeNoHeader() + 8;
        }

        @Override
        void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeLong(this.version);
        }

        @Override
        void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            this.version = in.readLong();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", version: " + this.version + ", data: " + (this.data == null ? "null" : "(" + this.data.limit() + " bytes)");
        }

        @Override
        public PUT clone() {
            PUT clone = (PUT)super.clone();
            clone.data = this.data != null ? Persistables.copyOf(this.data) : null;
            return clone;
        }
    }

    public static class INVRES
    extends LineMessage {
        private byte[] result;

        INVRES(Type type) {
            super(type);
        }

        public INVRES(LineMessage responseTo, long line, Object result) {
            super(responseTo, Type.INVRES, line);
            this.result = Serialization.getInstance().write(result);
        }

        public Object getResult() {
            return Serialization.getInstance().read(this.result);
        }

        @Override
        public int sizeNoHeader() {
            return super.sizeNoHeader() + 2 + (this.result != null ? this.result.length : 0);
        }

        @Override
        public void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeShort(this.result != null ? (int)this.result.length : 0);
            if (this.result != null) {
                out.write(this.result);
            }
        }

        @Override
        public void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            int dataLen = in.readUnsignedShort();
            if (dataLen == 0) {
                this.result = null;
            } else {
                this.result = new byte[dataLen];
                in.readFully(this.result);
            }
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", result: " + this.getResult();
        }
    }

    public static class INVOKE
    extends LineMessage {
        private byte[] function;

        INVOKE(Type type) {
            super(type);
        }

        public INVOKE(Type type, short node, long line, LineFunction function) {
            super(node, type, line);
            this.function = Serialization.getInstance().write(function);
            assert (type == Type.INVOKE);
        }

        public LineFunction getFunction() {
            return (LineFunction)Serialization.getInstance().read(this.function);
        }

        @Override
        public int sizeNoHeader() {
            return super.sizeNoHeader() + 2 + (this.function != null ? this.function.length : 0);
        }

        @Override
        public void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeShort(this.function != null ? (int)this.function.length : 0);
            if (this.function != null) {
                out.write(this.function);
            }
        }

        @Override
        public void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            int dataLen = in.readUnsignedShort();
            if (dataLen == 0) {
                this.function = null;
            } else {
                this.function = new byte[dataLen];
                in.readFully(this.function);
            }
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", function: " + this.getFunction();
        }
    }

    public static class GET
    extends LineMessage {
        GET(Type type) {
            super(type);
        }

        public GET(Type type, short node, long line) {
            super(node, type, line);
            assert (type == Type.GET || type == Type.GETX);
        }
    }

    public static class INV
    extends LineMessage {
        private short previousOwner;

        INV() {
            super(Type.INV);
        }

        public INV(short node, long line, short previousOwner) {
            super(node, Type.INV, line);
            this.previousOwner = previousOwner;
        }

        public INV(LineMessage responseTo, long line, short previousOwner) {
            super(responseTo, Type.INV, line);
            this.previousOwner = previousOwner;
        }

        public short getPreviousOwner() {
            return this.previousOwner;
        }

        @Override
        int sizeNoHeader() {
            return super.sizeNoHeader() + 2;
        }

        @Override
        void writeNoHeader(DataOutput out) throws IOException {
            super.writeNoHeader(out);
            out.writeShort(this.previousOwner);
        }

        @Override
        void readNoHeader(DataInput in) throws IOException {
            super.readNoHeader(in);
            this.previousOwner = in.readShort();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", previousOwner: " + this.previousOwner;
        }
    }

    public static class LineMessage
    extends Message {
        private long line;

        public LineMessage(short[] nodes, Type type, long line) {
            super(nodes, type);
            this.line = line;
        }

        public LineMessage(short node, Type type, long line) {
            super(node, type);
            this.line = line;
        }

        public LineMessage(LineMessage responseTo, Type type) {
            this(responseTo, type, responseTo.getLine());
        }

        public LineMessage(LineMessage responseTo, Type type, long line) {
            super(responseTo, type);
            assert (line == responseTo.line);
            this.line = line;
        }

        public LineMessage(Type type) {
            super(type);
            this.line = -1L;
        }

        @Override
        public LineMessage setMessageId(long messageId) {
            return (LineMessage)super.setMessageId(messageId);
        }

        @Override
        public LineMessage setIncoming() {
            return (LineMessage)super.setIncoming();
        }

        public long getLine() {
            return this.line;
        }

        @Override
        public final int size1() {
            return super.size1() + this.sizeNoHeader();
        }

        @Override
        public final void write1(DataOutput out) throws IOException {
            super.write1(out);
            this.writeNoHeader(out);
        }

        @Override
        public final void read1(DataInput in) throws IOException {
            super.read1(in);
            this.readNoHeader(in);
        }

        int sizeNoHeader() {
            return 8;
        }

        void writeNoHeader(DataOutput out) throws IOException {
            out.writeLong(this.line);
        }

        void readNoHeader(DataInput in) throws IOException {
            this.line = in.readLong();
        }

        @Override
        public String partialToString() {
            return super.partialToString() + ", line: " + Long.toHexString(this.line);
        }

        @Override
        public LineMessage clone() {
            return (LineMessage)super.clone();
        }
    }

    public static enum Type {
        GET,
        GETX,
        INV,
        INVACK,
        PUT,
        PUTX,
        DEL,
        CHNGD_OWNR,
        NOT_FOUND,
        TIMEOUT,
        INVOKE,
        INVRES,
        BACKUP,
        BACKUPACK,
        BACKUP_PACKET,
        BACKUP_PACKETACK,
        ALLOC_REF,
        ALLOCED_REF,
        MSG,
        MSGACK,
        ACK;

        public static final long REQUIRES_RESPONSE;

        public boolean isOf(long set) {
            return Enums.isIn(this, set);
        }

        static {
            REQUIRES_RESPONSE = Enums.setOf(GET, GETX, INV, BACKUP_PACKET, INVOKE);
        }
    }
}

