/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.Metrics;
import co.paralleluniverse.galaxy.core.BackupMonitor;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;

public class MetricsBackupMonitor
implements BackupMonitor {
    private final Meter backups = Metrics.meter(this.metric("backups"));
    private final Meter replicationBackups = Metrics.meter(this.metric("replicationBackups"));
    private final Meter backupPackets = Metrics.meter(this.metric("backupPacketsSent"));
    private final Timer slavesAckTime = Metrics.timer(this.metric("slavesAckTime"));
    private final Timer serverAckTime = Metrics.timer(this.metric("serverAckTime"));

    protected final String metric(String name) {
        return MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "Cache", name});
    }

    @Override
    public void addReplicationBackup(int num) {
        this.replicationBackups.mark((long)num);
    }

    @Override
    public void addBackups(int num) {
        this.backups.mark((long)num);
    }

    @Override
    public void addBackupPacket() {
        this.backupPackets.mark();
    }

    @Override
    public void addSlaveAckTime(long nanos) {
        this.slavesAckTime.update(nanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void addServerAckTime(long nanos) {
        this.serverAckTime.update(nanos, TimeUnit.NANOSECONDS);
    }
}

