/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.Metrics;
import co.paralleluniverse.galaxy.core.CacheMonitor;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.Op;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;

class MetricsCacheMonitor
implements CacheMonitor {
    private final EnumMap<Message.Type, MessageMonitor> messageMonitors = new EnumMap(Message.Type.class);
    private final EnumMap<Op.Type, Timer> opMonitors = new EnumMap(Op.Type.class);
    private final EnumMap<CacheMonitor.MessageDelayReason, DelayedMessageMonitor> messageDelayMonitors = new EnumMap(CacheMonitor.MessageDelayReason.class);
    private final Meter hits = Metrics.meter(this.metric("hits"));
    private final Meter staleHits = Metrics.meter(this.metric("staleHits"));
    private final Meter misses = Metrics.meter(this.metric("misses"));
    private final Meter invalidates = Metrics.meter(this.metric("invalidates"));
    private final Meter stalePurges = Metrics.meter(this.metric("stalePurges"));

    public MetricsCacheMonitor() {
        for (Op.Type type : Op.Type.values()) {
            this.opMonitors.put(type, Metrics.timer(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "Cache", "ops", type.name()})));
        }
        for (Enum enum_ : Message.Type.values()) {
            this.messageMonitors.put((Message.Type)enum_, new MessageMonitor((Message.Type)enum_));
        }
        for (Enum enum_ : CacheMonitor.MessageDelayReason.values()) {
            this.messageDelayMonitors.put((CacheMonitor.MessageDelayReason)enum_, new DelayedMessageMonitor((CacheMonitor.MessageDelayReason)enum_));
        }
    }

    protected final String metric(String name) {
        return MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "Cache", name});
    }

    @Override
    public void setMonitoredObject(Object obj) {
    }

    @Override
    public void addHit() {
        this.hits.mark();
    }

    @Override
    public void addStaleHit() {
        this.staleHits.mark();
    }

    @Override
    public void addMiss() {
        this.misses.mark();
    }

    @Override
    public void addInvalidate(int num) {
        this.invalidates.mark((long)num);
    }

    @Override
    public void addMessageSent(Message.Type msg) {
        this.messageMonitors.get((Object)msg).addSent();
    }

    @Override
    public void addMessageReceived(Message.Type msg) {
        this.messageMonitors.get((Object)msg).addReceived();
    }

    @Override
    public void addOp(Op.Type type, long durationMicroSeconds) {
        this.opMonitors.get((Object)type).update(durationMicroSeconds, TimeUnit.MICROSECONDS);
    }

    @Override
    public void addMessageHandlingDelay(int numDelayed, long totalDelayNanos, CacheMonitor.MessageDelayReason reason) {
        DelayedMessageMonitor m = this.messageDelayMonitors.get((Object)reason);
        m.addMessages(numDelayed);
        m.addDelay(totalDelayNanos);
    }

    @Override
    public void addStalePurge(int num) {
        this.stalePurges.mark((long)num);
    }

    private static class DelayedMessageMonitor {
        private final Meter messages;
        private final Timer delay;

        public DelayedMessageMonitor(CacheMonitor.MessageDelayReason reason) {
            this.messages = Metrics.meter(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "Cache", "messages", "messagesDelayed", reason.name()}));
            this.delay = Metrics.timer(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "Cache", "messages", "delay", reason.name()}));
        }

        void addDelay(long nanos) {
            this.delay.update(nanos, TimeUnit.NANOSECONDS);
        }

        void addMessages(int num) {
            this.messages.mark((long)num);
        }
    }

    private static class MessageMonitor {
        private final Meter messagesSent;
        private final Meter messagesReceived;

        public MessageMonitor(Message.Type type) {
            this.messagesSent = Metrics.meter(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "Cache", "messages", "sent", type.name()}));
            this.messagesReceived = Metrics.meter(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "Cache", "messages", "received", type.name()}));
        }

        void addSent() {
            this.messagesSent.mark();
        }

        void addReceived() {
            this.messagesReceived.mark();
        }
    }
}

