/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.Metrics;
import co.paralleluniverse.galaxy.core.CacheStorage;
import co.paralleluniverse.galaxy.core.LocalStorageMonitor;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import java.lang.ref.WeakReference;

class MetricsLocalStorageMonitor
implements LocalStorageMonitor {
    final Histogram allocated;
    final Histogram deallocated;
    final Gauge<Long> totalSize;

    public MetricsLocalStorageMonitor(String name, CacheStorage localStorage) {
        this.allocated = Metrics.histogram(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "CacheStorage", "allocated", name}));
        this.deallocated = Metrics.histogram(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "CacheStorage", "deallocated", name}));
        final WeakReference<CacheStorage> _localStorage = new WeakReference<CacheStorage>(localStorage);
        this.totalSize = Metrics.register(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "CacheStorage", "totalSize", name}), new Gauge<Long>(){

            public Long getValue() {
                CacheStorage localStorage = (CacheStorage)_localStorage.get();
                return localStorage != null ? localStorage.getTotalAllocatedSize() : 0L;
            }
        });
    }

    @Override
    public void allocated(int size) {
        this.allocated.update(size);
    }

    @Override
    public void deallocated(int size) {
        this.deallocated.update(size);
    }
}

