/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.Metrics;
import co.paralleluniverse.galaxy.core.MainMemoryMonitor;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;

class MetricsMainMemoryMonitor
implements MainMemoryMonitor {
    private final Meter writes = Metrics.meter(this.metric("writes"));
    private final Meter transactions = Metrics.meter(this.metric("transactions"));
    private final Meter objectsServed = Metrics.meter(this.metric("objectsServed"));
    private final Meter ownerWrites = Metrics.meter(this.metric("ownerWrites"));
    private final Meter ownersServed = Metrics.meter(this.metric("ownersServed"));
    private final Meter allocations = Metrics.meter(this.metric("allocations"));

    MetricsMainMemoryMonitor() {
    }

    protected final String metric(String name) {
        return MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "MainMemory", name});
    }

    @Override
    public void setMonitoredObject(Object obj) {
    }

    @Override
    public void addObjectServed() {
        this.objectsServed.mark();
    }

    @Override
    public void addOwnerServed() {
        this.ownersServed.mark();
    }

    @Override
    public void addOwnerWrite() {
        this.ownerWrites.mark();
    }

    @Override
    public void addTransaction(int numWrites) {
        this.transactions.mark();
        this.writes.mark((long)numWrites);
    }

    @Override
    public void addAllocation(int count) {
        this.allocations.mark((long)count);
    }
}

