/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.monitoring.Metrics;
import co.paralleluniverse.galaxy.core.CacheStorage;
import co.paralleluniverse.galaxy.core.MetricsLocalStorageMonitor;
import co.paralleluniverse.galaxy.core.OffHeapLocalStorageMonitor;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;

class MetricsOffHeapLocalStorageMonitor
extends MetricsLocalStorageMonitor
implements OffHeapLocalStorageMonitor {
    private final BinMetrics[] binMetrics;

    public MetricsOffHeapLocalStorageMonitor(String name, CacheStorage storage, int[] bins) {
        super(name, storage);
        this.binMetrics = new BinMetrics[bins.length];
        for (int i = 0; i < bins.length; ++i) {
            this.binMetrics[i] = new BinMetrics(name, bins[i]);
        }
    }

    @Override
    public void allocated(int bin, int size) {
        super.allocated(size);
        this.binMetrics[bin].allocated(size);
    }

    @Override
    public void deallocated(int bin, int size) {
        super.deallocated(size);
        this.binMetrics[bin].deallocated(size);
    }

    private static class BinMetrics {
        private final Counter totalSize;
        private final Meter allocated;
        private final Meter deallocated;

        public BinMetrics(String name, int bin) {
            this.totalSize = Metrics.counter(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "CacheStorage", "totalSize", name + '[' + bin + ']'}));
            this.allocated = Metrics.meter(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "CacheStorage", "allocated", name + '[' + bin + ']'}));
            this.deallocated = Metrics.meter(MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"galaxy", "CacheStorage", "deallocated", name + '[' + bin + ']'}));
        }

        public void allocated(int size) {
            this.totalSize.inc((long)size);
            this.allocated.mark();
        }

        public void deallocated(int size) {
            this.totalSize.dec((long)size);
            this.deallocated.mark();
        }
    }
}

