/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.collection.ConcurrentMapComplex;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.core.Comm;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.MessageReceiver;
import co.paralleluniverse.galaxy.core.NodeNotFoundException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Iterator;
import java.util.Set;

class NodeDeathLayer
implements Comm,
NodeChangeListener,
MessageReceiver {
    private final Comm comm;
    private final Cluster cluster;
    private MessageReceiver cache;
    private final ConcurrentMapComplex<Short, SetMultimap<Long, Message.LineMessage>> pending = new ConcurrentMapComplex<Short, SetMultimap<Long, Message.LineMessage>>(){

        @Override
        protected SetMultimap<Long, Message.LineMessage> allocateElement() {
            HashMultimap mm = HashMultimap.create();
            return Multimaps.synchronizedSetMultimap((SetMultimap)mm);
        }

        @Override
        protected SetMultimap<Long, Message.LineMessage> emptyElement() {
            return ImmutableSetMultimap.of();
        }
    };

    public NodeDeathLayer(Comm comm, Cluster cluster) {
        this.comm = comm;
        this.cluster = cluster;
        comm.setReceiver(this);
        cluster.addNodeChangeListener(this);
    }

    @Override
    public void setReceiver(MessageReceiver receiver) {
        this.cache = receiver;
    }

    public void addPending(Message.LineMessage message) {
        short node = message.getNode();
        if (node != -1) {
            this.pending.getOrAllocate(node).put((Object)message.getLine(), (Object)message);
        }
    }

    public void removePending(Message.LineMessage message) {
        Set msgs = this.pending.get(message.getNode()).get((Object)message.getLine());
        Iterator it = msgs.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            if (message.getType() == Message.Type.INVACK && msg.getType() == Message.Type.INV) {
                it.remove();
                continue;
            }
            if (message.getType() == Message.Type.PUTX && (msg.getType() == Message.Type.GETX || msg.getType() == Message.Type.GET)) {
                it.remove();
                continue;
            }
            if (message.getType() != Message.Type.PUT || msg.getType() != Message.Type.GET) continue;
            it.remove();
        }
    }

    @Override
    public void receive(Message message) {
        this.removePending((Message.LineMessage)message);
        this.cache.receive(message);
    }

    @Override
    public void send(Message message) {
        block2: {
            try {
                this.comm.send(message);
            }
            catch (NodeNotFoundException e) {
                Message response = this.genResponse((Message.LineMessage)message);
                if (response == null) break block2;
                this.cache.receive(this.shortCircuitMessage(message.getNode(), response));
            }
        }
    }

    @Override
    public void nodeRemoved(short node) {
        Multimap mm = (Multimap)this.pending.get(node);
        for (Message.LineMessage m : mm.values()) {
            Message response = this.genResponse(m);
            if (response == null) continue;
            this.cache.receive(this.shortCircuitMessage(m.getNode(), response));
        }
        this.pending.remove(node);
    }

    private Message genResponse(Message message) {
        switch (message.getType()) {
            case INV: {
                return Message.INVACK((Message.INV)message);
            }
            case GET: 
            case GETX: {
                return Message.CHNGD_OWNR((Message.LineMessage)message, ((Message.LineMessage)message).getLine(), (short)-1, false);
            }
        }
        return null;
    }

    @Override
    public void nodeAdded(short node) {
    }

    private Message shortCircuitMessage(short node, Message message) {
        message.setIncoming();
        message.setNode(node);
        return message;
    }

    @Override
    public void nodeSwitched(short id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

