/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.concurrent.OrderedThreadPoolExecutor;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.core.NodeAttached;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.beans.ConstructorProperties;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NodeOrderedThreadPoolExecutor
extends OrderedThreadPoolExecutor {
    private final NodeChangeListener listener = new NodeChangeListener(){

        @Override
        public void nodeRemoved(short id) {
            NodeOrderedThreadPoolExecutor.this.removeChildExecutor(id);
        }

        @Override
        public void nodeAdded(short id) {
        }

        @Override
        public void nodeSwitched(short id) {
        }
    };

    @ConstructorProperties(value={"cluster", "corePoolSize", "maximumPoolSize", "keepAliveTime", "unit", "maxQueueSize"})
    public NodeOrderedThreadPoolExecutor(Cluster cluster, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, maxQueueSize, new ThreadFactoryBuilder().setDaemon(true).build());
        cluster.addNodeChangeListener(this.listener);
    }

    @ConstructorProperties(value={"cluster", "corePoolSize", "maximumPoolSize", "keepAliveTime", "unit", "maxQueueSize", "threadFactory"})
    public NodeOrderedThreadPoolExecutor(Cluster cluster, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, maxQueueSize, threadFactory);
        cluster.addNodeChangeListener(this.listener);
    }

    @ConstructorProperties(value={"cluster", "corePoolSize", "maximumPoolSize", "keepAliveTime", "unit", "maxQueueSize", "handler"})
    public NodeOrderedThreadPoolExecutor(Cluster cluster, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, maxQueueSize, new ThreadFactoryBuilder().setDaemon(true).build(), handler);
        cluster.addNodeChangeListener(this.listener);
    }

    @ConstructorProperties(value={"cluster", "corePoolSize", "maximumPoolSize", "keepAliveTime", "unit", "maxQueueSize", "threadFactory", "handler"})
    public NodeOrderedThreadPoolExecutor(Cluster cluster, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, maxQueueSize, threadFactory, handler);
        cluster.addNodeChangeListener(this.listener);
    }

    @Override
    protected Object getChildExecutorKey(Runnable task) {
        return ((NodeAttached)((Object)task)).getNode();
    }
}

