/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.MonitoringType;
import co.paralleluniverse.common.spring.Component;
import co.paralleluniverse.common.util.DegenerateInvocationHandler;
import co.paralleluniverse.galaxy.core.CacheStorage;
import co.paralleluniverse.galaxy.core.JMXOffHeapLocalStorageMonitor;
import co.paralleluniverse.galaxy.core.MetricsOffHeapLocalStorageMonitor;
import co.paralleluniverse.galaxy.core.OffHeapLocalStorageMonitor;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.DirectBuffer;

class OffHeapLocalStorage
extends Component
implements CacheStorage {
    private static final Logger LOG = LoggerFactory.getLogger(OffHeapLocalStorage.class);
    private static final int MIN_POWER = 3;
    private static final Field VIEWD_BUFFER_FIELD;
    private static final ByteBuffer EMPTY_BUFFER;
    private final int pageSize;
    private final int maxItemSize;
    private final AtomicLong totalSize = new AtomicLong();
    private final PageGroup[] pageGroups;
    private int maxPagesForConcurrency = Runtime.getRuntime().availableProcessors() * 2;
    private final OffHeapLocalStorageMonitor monitor;

    @ConstructorProperties(value={"name", "pageSize", "maxItemSize", "monitoringType"})
    public OffHeapLocalStorage(String name, int pageSize, int maxItemSize, MonitoringType monitoringType) {
        super(name);
        this.pageSize = pageSize;
        this.maxItemSize = OffHeapLocalStorage.nextPowerOfTwo(maxItemSize);
        int numGroups = 0;
        for (int tmpSize = 8; tmpSize <= this.maxItemSize; tmpSize <<= 1) {
            ++numGroups;
        }
        int[] sizes = new int[numGroups];
        this.pageGroups = new PageGroup[numGroups];
        for (int i = 0; i < this.pageGroups.length; ++i) {
            int size = 1 << 3 + i;
            this.pageGroups[i] = new PageGroup(i, size);
            sizes[i] = size;
        }
        this.monitor = this.createMonitor(monitoringType, name, sizes);
    }

    private OffHeapLocalStorageMonitor createMonitor(MonitoringType monitoringType, String name, int[] sizes) {
        if (monitoringType == null) {
            return (OffHeapLocalStorageMonitor)Proxy.newProxyInstance(OffHeapLocalStorage.class.getClassLoader(), new Class[]{OffHeapLocalStorageMonitor.class}, (InvocationHandler)DegenerateInvocationHandler.INSTANCE);
        }
        switch (monitoringType) {
            case JMX: {
                return new JMXOffHeapLocalStorageMonitor(name, this, sizes);
            }
            case METRICS: {
                return new MetricsOffHeapLocalStorageMonitor(name, this, sizes);
            }
        }
        throw new IllegalArgumentException("Unknown MonitoringType " + (Object)((Object)monitoringType));
    }

    public void setMaxPagesForConcurrency(int maxPagesForConcurrency) {
        this.assertDuringInitialization();
        this.maxPagesForConcurrency = maxPagesForConcurrency;
    }

    @Override
    public ByteBuffer allocateStorage(int size) {
        if (size == 0) {
            return EMPTY_BUFFER;
        }
        if (size > this.maxItemSize) {
            throw new IllegalArgumentException("Size " + size + " is larger than maximum size: " + this.maxItemSize);
        }
        int bin = this.getSizeIndex(size);
        size = this.pageGroups[bin].cellSize;
        this.monitor.allocated(bin, size);
        this.totalSize.addAndGet(size);
        ByteBuffer buffer = this.pageGroups[bin].allocate();
        buffer.position(0);
        return buffer;
    }

    @Override
    public void deallocateStorage(long id, ByteBuffer buffer) {
        if (buffer == EMPTY_BUFFER) {
            return;
        }
        Page page = OffHeapLocalStorage.getPage(buffer);
        this.monitor.deallocated(page.getGroup().groupIndex, buffer.limit());
        this.totalSize.addAndGet(-buffer.limit());
        page.deallocate(buffer);
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.totalSize.get();
    }

    private int getSizeIndex(int size) {
        for (int i = 0; i < this.pageGroups.length; ++i) {
            if (size > this.pageGroups[i].cellSize) continue;
            return i;
        }
        throw new RuntimeException("Value " + size + " is too large! Must be smaller than " + this.pageGroups[this.pageGroups.length - 1].cellSize);
    }

    private static int nextPowerOfTwo(int v) {
        assert (v >= 0);
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    private static ByteBuffer slice(ByteBuffer buffer, int start, int length) {
        buffer.limit(start + length);
        buffer.position(start);
        ByteBuffer slice = buffer.slice();
        buffer.clear();
        return slice;
    }

    private static Page getPage(ByteBuffer buffer) {
        return (Page)OffHeapLocalStorage.getViewed((ByteBuffer)OffHeapLocalStorage.getViewed(buffer));
    }

    private static Object getViewed(ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).attachment();
    }

    private static int getOffset(ByteBuffer slice) {
        DirectBuffer _slice = (DirectBuffer)((Object)slice);
        DirectBuffer parent = (DirectBuffer)_slice.attachment();
        return (int)(_slice.address() - parent.address());
    }

    private static void setViewed(ByteBuffer buffer, Object object) {
        try {
            VIEWD_BUFFER_FIELD.set(buffer, object);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static {
        EMPTY_BUFFER = ByteBuffer.allocateDirect(0);
        try {
            VIEWD_BUFFER_FIELD = Class.forName("java.nio.DirectByteBuffer").getDeclaredField("att");
            VIEWD_BUFFER_FIELD.setAccessible(true);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static class Page {
        private final PageGroup group;
        private final int cellSize;
        private final ByteBuffer buffer;
        private int head;
        private int freeCells;
        private final Lock lock = new ReentrantLock();

        public Page(PageGroup group, int bufferKbSize, int cellSize, int power) {
            this.group = group;
            this.buffer = ByteBuffer.allocateDirect(bufferKbSize * 1024);
            this.buffer.order(ByteOrder.nativeOrder());
            OffHeapLocalStorage.setViewed(this.buffer, this);
            this.cellSize = cellSize;
            this.freeCells = bufferKbSize * 1024 >> power;
            int prev = -1;
            for (int i = this.freeCells - 1; i >= 0; --i) {
                int ptr = i << power;
                this.buffer.putInt(ptr, prev);
                prev = ptr;
            }
            this.head = 0;
        }

        public PageGroup getGroup() {
            return this.group;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ByteBuffer allocate(boolean doIt) {
            ByteBuffer slice;
            if (doIt) {
                this.lock.lock();
            } else if (!this.lock.tryLock()) {
                return null;
            }
            try {
                int ptr = this.head;
                if (ptr == -1) {
                    assert (this.freeCells == 0);
                    ByteBuffer byteBuffer = null;
                    return byteBuffer;
                }
                this.head = this.buffer.getInt(ptr);
                --this.freeCells;
                slice = OffHeapLocalStorage.slice(this.buffer, ptr, this.cellSize);
            }
            finally {
                this.lock.unlock();
            }
            slice.putInt(0, 0);
            return slice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deallocate(ByteBuffer slice) {
            assert (OffHeapLocalStorage.getPage(slice) == this);
            int ptr = OffHeapLocalStorage.getOffset(slice);
            this.lock.lock();
            try {
                this.buffer.putInt(ptr, this.head);
                this.head = ptr;
                ++this.freeCells;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class PageGroup {
        public final int groupIndex;
        public final int cellSize;
        private final List<Page> pages = new CopyOnWriteArrayList<Page>();
        private final Lock allocationLock = new ReentrantLock();
        private volatile int numPages = 0;

        public PageGroup(int index, int cellSize) {
            this.groupIndex = index;
            this.cellSize = cellSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ByteBuffer allocate() {
            int threadHash = Thread.currentThread().hashCode();
            ByteBuffer buffer = null;
            if (this.numPages > 0) {
                buffer = this.allocate(threadHash % this.numPages);
            }
            if (buffer == null) {
                this.allocationLock.lock();
                try {
                    if (this.numPages > 0) {
                        buffer = this.allocate(threadHash % this.numPages);
                    }
                    if (buffer == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Allocating a direct-memory page of size {} bytes. (totalSize: {} bytes)", (Object)(OffHeapLocalStorage.this.pageSize * 1024), (Object)OffHeapLocalStorage.this.totalSize.get());
                        }
                        Page newPage = new Page(this, OffHeapLocalStorage.this.pageSize, this.cellSize, 3 + this.groupIndex);
                        buffer = newPage.allocate(true);
                        this.pages.add(newPage);
                        ++this.numPages;
                    }
                }
                finally {
                    this.allocationLock.unlock();
                }
            }
            assert (buffer != null);
            return buffer;
        }

        private ByteBuffer allocate(int start) {
            int _numPages = this.numPages;
            boolean canGrowForConcurrency = _numPages < OffHeapLocalStorage.this.maxPagesForConcurrency;
            for (int i = 0; i < _numPages; ++i) {
                Page page = this.pages.get((start + i) % _numPages);
                ByteBuffer buffer = page.allocate(!canGrowForConcurrency);
                if (buffer == null) continue;
                return buffer;
            }
            return null;
        }
    }
}

