/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.io.Persistable;
import co.paralleluniverse.common.util.Enums;
import co.paralleluniverse.galaxy.Grid;
import co.paralleluniverse.galaxy.core.Cache;
import co.paralleluniverse.galaxy.core.StoreImpl;
import co.paralleluniverse.galaxy.core.Transaction;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class Op {
    private static final byte COMPLETED = 1;
    private static final byte CANCELLED = 2;
    public final Type type;
    public final long line;
    public final Transaction txn;
    public final Object data;
    private Object extra;
    private OpFuture<Object> future;
    private long startTime;
    private byte status;

    Op(Type type, long line, Object data, Object extra, Transaction txn) {
        this.type = type;
        this.line = line;
        if (data != null && data instanceof byte[]) {
            data = Arrays.copyOf((byte[])data, ((byte[])data).length);
        }
        this.data = data;
        this.txn = txn;
        this.extra = extra;
    }

    public Op(Type type, long line, byte[] data, Object extra, Transaction txn) {
        this(type, line, (Object)data, extra, txn);
    }

    public Op(Type type, long line, ByteBuffer data, Object extra, Transaction txn) {
        this(type, line, (Object)data, extra, txn);
    }

    public Op(Type type, long line, Persistable data, Object extra, Transaction txn) {
        this(type, line, (Object)data, extra, txn);
    }

    public Op(Type type, long line, byte[] data, Transaction txn) {
        this(type, line, data, (Object)null, txn);
    }

    public Op(Type type, long line, ByteBuffer data, Transaction txn) {
        this(type, line, data, null, txn);
    }

    public Op(Type type, long line, Persistable data, Transaction txn) {
        this(type, line, data, null, txn);
    }

    public Op(Type type, long line, Object extra, Transaction txn) {
        this(type, line, (Object)null, extra, txn);
    }

    public Op(Type type, long line, Transaction txn) {
        this(type, line, (Object)null, null, txn);
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    void createFuture() {
        assert (this.future == null);
        this.future = new OpFuture(this);
    }

    public boolean hasFuture() {
        return this.future != null;
    }

    public ListenableFuture<Object> getFuture() {
        return this.future;
    }

    public void setResult(Object result) {
        this.setCompleted();
        this.future.set(result);
    }

    public void setException(Throwable t) {
        this.setCompleted();
        this.future.setException(t);
    }

    public Object getResult() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    public Object getResult(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    void setCancelled() {
        assert (this.status == 0);
        this.status = (byte)2;
    }

    private void setCompleted() {
        assert (this.status == 0);
        this.status = 1;
    }

    public boolean isCancelled() {
        return this.status == 2;
    }

    public boolean isCompleted() {
        return this.status == 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Op other = (Op)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (!Objects.equals(this.data, other.data)) {
            return false;
        }
        return Objects.equals(this.extra, other.extra);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 89 * hash + (int)(this.line ^ this.line >>> 32);
        hash = 89 * hash + Objects.hashCode(this.data);
        hash = 89 * hash + Objects.hashCode(this.extra);
        return hash;
    }

    public String toString() {
        return "Op." + (Object)((Object)this.type) + "(line:" + Long.toHexString(this.line) + (this.data != null ? ", data:" + this.data : "") + (this.extra != null ? ", extra:" + this.extra : "") + ')';
    }

    static Cache getCache() {
        try {
            return ((StoreImpl)Grid.getInstance().store()).cache;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class OpFuture<V>
    extends AbstractFuture<V> {
        private final Op op;

        OpFuture(Op op) {
            this.op = op;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!Op.getCache().cancelOp(this.op)) {
                return false;
            }
            assert (this.op.isCancelled());
            return super.cancel(mayInterruptIfRunning);
        }

        public boolean set(V value) {
            return super.set(value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }

    public static enum Type {
        GET,
        INVOKE,
        GETS,
        GETX,
        GET_FROM_OWNER,
        SET,
        PUT,
        ALLOC,
        DEL,
        SEND,
        PUSH,
        PUSHX,
        LSTN;


        public boolean isOf(long set) {
            return Enums.isIn(this, set);
        }
    }
}

