/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.galaxy.core.RefAllocator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class RefAllocatorSupport {
    private final List<RefAllocator.RefAllocationsListener> refAllocationListeners = new CopyOnWriteArrayList<RefAllocator.RefAllocationsListener>();

    public void addRefAllocationsListener(RefAllocator.RefAllocationsListener listener) {
        this.refAllocationListeners.add(listener);
    }

    public void removeRefAllocationsListener(RefAllocator.RefAllocationsListener listener) {
        this.refAllocationListeners.remove(listener);
    }

    public Collection<RefAllocator.RefAllocationsListener> getRefAllocationListeners() {
        return this.refAllocationListeners;
    }

    public void fireCounterReady() {
        for (RefAllocator.RefAllocationsListener listener : this.refAllocationListeners) {
            listener.counterReady();
        }
    }

    public void fireRefsAllocated(long start, int num) {
        for (RefAllocator.RefAllocationsListener listener : this.refAllocationListeners) {
            listener.refsAllocated(start, num);
        }
    }
}

