/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.galaxy.core.Comm;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.MessageReceiver;
import co.paralleluniverse.galaxy.core.NodeNotFoundException;
import co.paralleluniverse.galaxy.core.RefAllocator;
import co.paralleluniverse.galaxy.core.RefAllocatorSupport;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRefAllocator
implements RefAllocator,
MessageReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRefAllocator.class);
    private final Comm comm;
    private final RefAllocatorSupport support = new RefAllocatorSupport();

    public ServerRefAllocator(Comm comm) {
        this.comm = comm;
        this.support.fireCounterReady();
    }

    @Override
    public void allocateRefs(int count) {
        try {
            this.comm.send(Message.ALLOC_REF((short)0, count));
        }
        catch (NodeNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void receive(Message message) {
        if (!(message instanceof Message.ALLOCED_REF)) {
            LOG.error("Unexpected message: {}", (Object)message);
            throw new AssertionError();
        }
        Message.ALLOCED_REF m = (Message.ALLOCED_REF)message;
        this.support.fireRefsAllocated(m.getStart(), m.getNum());
    }

    @Override
    public void addRefAllocationsListener(RefAllocator.RefAllocationsListener listener) {
        listener.counterReady();
        this.support.addRefAllocationsListener(listener);
    }

    @Override
    public void removeRefAllocationsListener(RefAllocator.RefAllocationsListener listener) {
        this.support.removeRefAllocationsListener(listener);
    }

    @Override
    public Collection<RefAllocator.RefAllocationsListener> getRefAllocationsListeners() {
        return this.support.getRefAllocationListeners();
    }
}

