/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.io.Persistable;
import co.paralleluniverse.common.io.Streamable;
import co.paralleluniverse.common.io.Streamables;
import co.paralleluniverse.galaxy.CacheListener;
import co.paralleluniverse.galaxy.ItemState;
import co.paralleluniverse.galaxy.LineFunction;
import co.paralleluniverse.galaxy.Store;
import co.paralleluniverse.galaxy.StoreTransaction;
import co.paralleluniverse.galaxy.TimeoutException;
import co.paralleluniverse.galaxy.core.Cache;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.Op;
import co.paralleluniverse.galaxy.core.StringRootManager;
import co.paralleluniverse.galaxy.core.Transaction;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class StoreImpl
implements Store {
    final Cache cache;
    private final StringRootManager rootManager;

    public StoreImpl(Cache cache) {
        this.cache = cache;
        this.rootManager = new StringRootManager(this, cache.getCluster());
    }

    private static Persistable nonNullPersistable(Persistable object) {
        return object == null ? Cache.NULL_PERSISTABLE : object;
    }

    @Override
    public int getMaxItemSize() {
        return this.cache.getMaxItemSize();
    }

    @Override
    public StoreTransaction beginTransaction() {
        return this.cache.beginTransaction();
    }

    @Override
    public void commit(StoreTransaction txn) throws InterruptedException {
        this.cache.endTransaction((Transaction)txn, false);
    }

    @Override
    public void abort(StoreTransaction txn) {
        try {
            this.cache.endTransaction((Transaction)txn, true);
        }
        catch (InterruptedException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public void rollback(StoreTransaction txn) {
        this.cache.rollback((Transaction)txn);
    }

    @Override
    public void release(long id) {
        this.cache.release(id);
    }

    @Override
    public long getRoot(String root, StoreTransaction txn) throws TimeoutException {
        return this.rootManager.get(root, (Transaction)StoreImpl.verifyNonNull(txn));
    }

    @Override
    public long getRoot(String root, long id, StoreTransaction txn) throws TimeoutException {
        return this.rootManager.get(root, id, (Transaction)StoreImpl.verifyNonNull(txn));
    }

    @Override
    public boolean isRootCreated(long rootId, StoreTransaction txn) {
        return ((Transaction)txn).contains(rootId);
    }

    @Override
    public long alloc(int count, StoreTransaction txn) throws TimeoutException {
        return (Long)this.cache.doOp(Op.Type.ALLOC, -1L, null, count, (Transaction)StoreImpl.verifyNonNull(txn));
    }

    @Override
    public long put(byte[] data, StoreTransaction txn) throws TimeoutException {
        return (Long)this.cache.doOp(Op.Type.PUT, -1L, StoreImpl.copyOf(data), null, (Transaction)txn);
    }

    @Override
    public long put(ByteBuffer data, StoreTransaction txn) throws TimeoutException {
        return (Long)this.cache.doOp(Op.Type.PUT, -1L, data, null, (Transaction)txn);
    }

    @Override
    public long put(Persistable object, StoreTransaction txn) throws TimeoutException {
        return (Long)this.cache.doOp(Op.Type.PUT, -1L, object, null, (Transaction)txn);
    }

    @Override
    public byte[] get(long id) throws TimeoutException {
        return this.get(Op.Type.GET, id, null);
    }

    @Override
    public <T> T invoke(long lineId, LineFunction<T> function) throws TimeoutException {
        return (T)this.cache.doOp(Op.Type.INVOKE, lineId, function, null, null);
    }

    @Override
    public byte[] get(long id, short nodeHint) throws TimeoutException {
        return this.get(Op.Type.GET, id, nodeHint, null);
    }

    @Override
    public byte[] getFromOwner(long id, long ownerOf) throws TimeoutException {
        return this.getFromOwner(Op.Type.GET, id, ownerOf, null);
    }

    @Override
    public void get(long id, Persistable object) throws TimeoutException {
        this.get(Op.Type.GET, id, StoreImpl.nonNullPersistable(object), null);
    }

    @Override
    public void get(long id, short nodeHint, Persistable object) throws TimeoutException {
        this.get(Op.Type.GET, id, nodeHint, StoreImpl.nonNullPersistable(object), null);
    }

    @Override
    public void getFromOwner(long id, long ownerOf, Persistable object) throws TimeoutException {
        this.getFromOwner(Op.Type.GET, id, ownerOf, StoreImpl.nonNullPersistable(object), null);
    }

    @Override
    public byte[] gets(long id, StoreTransaction txn) throws TimeoutException {
        return this.get(Op.Type.GETS, id, txn);
    }

    @Override
    public byte[] gets(long id, short nodeHint, StoreTransaction txn) throws TimeoutException {
        return this.get(Op.Type.GETS, id, nodeHint, txn);
    }

    @Override
    public byte[] getsFromOwner(long id, long ownerOf, StoreTransaction txn) throws TimeoutException {
        return this.getFromOwner(Op.Type.GETS, id, ownerOf, txn);
    }

    @Override
    public void gets(long id, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.get(Op.Type.GETS, id, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public void gets(long id, short nodeHint, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.get(Op.Type.GETS, id, nodeHint, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public void getsFromOwner(long id, long ownerOf, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.getFromOwner(Op.Type.GETS, id, ownerOf, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public byte[] getx(long id, StoreTransaction txn) throws TimeoutException {
        return this.get(Op.Type.GETX, id, txn);
    }

    @Override
    public byte[] getx(long id, short nodeHint, StoreTransaction txn) throws TimeoutException {
        return this.get(Op.Type.GETX, id, nodeHint, txn);
    }

    @Override
    public byte[] getxFromOwner(long id, long ownerOf, StoreTransaction txn) throws TimeoutException {
        return this.getFromOwner(Op.Type.GETX, id, ownerOf, txn);
    }

    @Override
    public void getx(long id, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.get(Op.Type.GETX, id, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public void getx(long id, short nodeHint, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.get(Op.Type.GETX, id, nodeHint, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public void getxFromOwner(long id, long ownerOf, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.getFromOwner(Op.Type.GETX, id, ownerOf, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public void set(long id, byte[] data, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(Op.Type.SET, this.nonReserved(id), StoreImpl.copyOf(data), null, (Transaction)txn);
    }

    @Override
    public void set(long id, ByteBuffer data, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(Op.Type.SET, this.nonReserved(id), data, null, (Transaction)txn);
    }

    @Override
    public void set(long id, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(Op.Type.SET, this.nonReserved(id), object, null, (Transaction)txn);
    }

    @Override
    public void del(long id, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(Op.Type.DEL, this.nonReserved(id), null, null, (Transaction)txn);
    }

    @Override
    public ListenableFuture<Long> allocAsync(int count, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.ALLOC, -1L, null, count, (Transaction)StoreImpl.verifyNonNull(txn));
    }

    @Override
    public ListenableFuture<Long> putAsync(byte[] data, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.PUT, -1L, StoreImpl.copyOf(data), null, (Transaction)txn);
    }

    @Override
    public ListenableFuture<Long> putAsync(ByteBuffer data, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.PUT, -1L, data, null, (Transaction)txn);
    }

    @Override
    public ListenableFuture<Long> putAsync(Persistable object, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.PUT, -1L, object, null, (Transaction)txn);
    }

    @Override
    public ListenableFuture<byte[]> getAsync(long id) {
        return this.getAsync(Op.Type.GET, id, null);
    }

    @Override
    public ListenableFuture<byte[]> getAsync(long id, short nodeHint) {
        return this.getAsync(Op.Type.GET, id, nodeHint, null);
    }

    @Override
    public ListenableFuture<byte[]> getFromOwnerAsync(long id, long ownerOf) {
        return this.getFromOwnerAsync(Op.Type.GET, id, ownerOf, null);
    }

    @Override
    public ListenableFuture<Persistable> getAsync(long id, Persistable object) {
        return this.getAsync(Op.Type.GET, id, StoreImpl.nonNullPersistable(object), null);
    }

    @Override
    public ListenableFuture<Persistable> getAsync(long id, short nodeHint, Persistable object) {
        return this.getAsync(Op.Type.GET, id, nodeHint, StoreImpl.nonNullPersistable(object), null);
    }

    @Override
    public ListenableFuture<Persistable> getFromOwnerAsync(long id, long ownerOf, Persistable object) {
        return this.getFromOwnerAsync(Op.Type.GET, id, ownerOf, StoreImpl.nonNullPersistable(object), null);
    }

    @Override
    public ListenableFuture<byte[]> getsAsync(long id, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETS, id, txn);
    }

    @Override
    public ListenableFuture<byte[]> getsAsync(long id, short nodeHint, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETS, id, nodeHint, txn);
    }

    @Override
    public ListenableFuture<byte[]> getsFromOwnerAsync(long id, long ownerOf, StoreTransaction txn) {
        return this.getFromOwnerAsync(Op.Type.GETS, id, ownerOf, txn);
    }

    @Override
    public ListenableFuture<Persistable> getsAsync(long id, Persistable object, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETS, id, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public ListenableFuture<Persistable> getsAsync(long id, short nodeHint, Persistable object, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETS, id, nodeHint, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public ListenableFuture<Persistable> getsFromOwnerAsync(long id, long ownerOf, Persistable object, StoreTransaction txn) {
        return this.getFromOwnerAsync(Op.Type.GETS, id, ownerOf, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public ListenableFuture<byte[]> getxAsync(long id, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETX, id, txn);
    }

    @Override
    public ListenableFuture<byte[]> getxAsync(long id, short nodeHint, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETX, id, nodeHint, txn);
    }

    @Override
    public ListenableFuture<byte[]> getxFromOwnerAsync(long id, long ownerOf, StoreTransaction txn) {
        return this.getFromOwnerAsync(Op.Type.GETX, id, ownerOf, txn);
    }

    @Override
    public ListenableFuture<Persistable> getxAsync(long id, Persistable object, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETX, id, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public ListenableFuture<Persistable> getxAsync(long id, short nodeHint, Persistable object, StoreTransaction txn) {
        return this.getAsync(Op.Type.GETX, id, nodeHint, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public ListenableFuture<Persistable> getxFromOwnerAsync(long id, long ownerOf, Persistable object, StoreTransaction txn) {
        return this.getFromOwnerAsync(Op.Type.GETX, id, ownerOf, StoreImpl.nonNullPersistable(object), txn);
    }

    @Override
    public ListenableFuture<Void> setAsync(long id, byte[] data, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.SET, this.nonReserved(id), StoreImpl.copyOf(data), null, (Transaction)txn);
    }

    @Override
    public ListenableFuture<Void> setAsync(long id, ByteBuffer data, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.SET, this.nonReserved(id), data, null, (Transaction)txn);
    }

    @Override
    public ListenableFuture<Void> setAsync(long id, Persistable object, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.SET, this.nonReserved(id), object, null, (Transaction)txn);
    }

    @Override
    public <T> ListenableFuture<T> invokeAsync(long id, LineFunction<T> function) {
        ListenableFuture<Object> res = this.cache.doOpAsync(Op.Type.INVOKE, id, function, null, null);
        return res;
    }

    @Override
    public ListenableFuture<Void> delAsync(long id, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.DEL, this.nonReserved(id), null, null, (Transaction)txn);
    }

    @Override
    public CacheListener setListenerIfAbsent(long id, CacheListener listener) {
        return this.cache.setListenerIfAbsent(id, listener);
    }

    @Override
    public void setListener(long id, CacheListener listener) {
        this.cache.setListener(id, listener);
    }

    @Override
    public CacheListener getListener(long id) {
        return this.cache.getListener(id);
    }

    @Override
    public void push(long id, short ... toNodes) {
        try {
            this.cache.doOp(Op.Type.PUSH, id, null, toNodes, null);
        }
        catch (TimeoutException e) {
            // empty catch block
        }
    }

    @Override
    public void pushx(long id, short toNode) {
        try {
            this.cache.doOp(Op.Type.PUSHX, id, null, toNode, null);
        }
        catch (TimeoutException e) {
            // empty catch block
        }
    }

    @Override
    public boolean isPinned(long id) {
        return this.cache.isLocked(id);
    }

    @Override
    public ItemState getState(long id) {
        Cache.State state = this.cache.getState(id);
        if (state == null) {
            return ItemState.INVALID;
        }
        switch (state) {
            case I: {
                return ItemState.INVALID;
            }
            case S: {
                return ItemState.SHARED;
            }
            case O: 
            case E: {
                return ItemState.OWNED;
            }
        }
        throw new AssertionError();
    }

    @Override
    public long getVersion(long id) {
        return this.cache.getVersion(id);
    }

    @Override
    public void send(long id, Streamable msg) throws TimeoutException {
        this.send(id, Streamables.toByteArray(msg));
    }

    @Override
    public void send(long id, byte[] msg) throws TimeoutException {
        Message.MSG message = Message.MSG((short)-1, id, false, msg);
        this.cache.doOp(Op.Type.SEND, id, null, message, null);
    }

    @Override
    public ListenableFuture<Void> sendAsync(long id, Streamable msg) {
        return this.sendAsync(id, Streamables.toByteArray(msg));
    }

    @Override
    public ListenableFuture<Void> sendAsync(long id, byte[] msg) {
        Message.MSG message = Message.MSG((short)-1, id, false, msg);
        return this.cache.doOpAsync(Op.Type.SEND, id, null, message, null);
    }

    void get1(long id, Persistable object) throws TimeoutException {
        this.get1(Op.Type.GET, id, StoreImpl.nonNullPersistable(object), null);
    }

    void get1(long id, short nodeHint, Persistable object) throws TimeoutException {
        this.get1(Op.Type.GET, id, nodeHint, StoreImpl.nonNullPersistable(object), null);
    }

    void getx1(long id, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.get1(Op.Type.GETX, id, StoreImpl.nonNullPersistable(object), txn);
    }

    void getx1(long id, short nodeHint, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.get1(Op.Type.GETX, id, nodeHint, StoreImpl.nonNullPersistable(object), txn);
    }

    void set1(long id, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(Op.Type.SET, id, StoreImpl.nonNullPersistable(object), null, (Transaction)txn);
    }

    private static StoreTransaction verifyNonNull(StoreTransaction txn) {
        if (txn == null) {
            throw new IllegalArgumentException("Transaction may not be null for this operation.");
        }
        return txn;
    }

    private static byte[] copyOf(byte[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    private byte[] get(Op.Type type, long id, StoreTransaction txn) throws TimeoutException {
        return (byte[])this.cache.doOp(type, id, null, null, (Transaction)txn);
    }

    private void get(Op.Type type, long id, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(type, this.nonReserved(id), StoreImpl.nonNullPersistable(object), null, (Transaction)txn);
    }

    private byte[] get(Op.Type type, long id, short nodeHint, StoreTransaction txn) throws TimeoutException {
        return (byte[])this.cache.doOp(type, this.nonReserved(id), null, nodeHint, (Transaction)txn);
    }

    private void get(Op.Type type, long id, short nodeHint, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(type, this.nonReserved(id), StoreImpl.nonNullPersistable(object), nodeHint, (Transaction)txn);
    }

    private byte[] getFromOwner(Op.Type type, long id, long ownerOf, StoreTransaction txn) throws TimeoutException {
        return (byte[])this.cache.doOp(Op.Type.GET_FROM_OWNER, this.nonReserved(ownerOf), null, new Op(type, this.nonReserved(id), (Transaction)txn), (Transaction)txn);
    }

    private void getFromOwner(Op.Type type, long id, long ownerOf, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(Op.Type.GET_FROM_OWNER, this.nonReserved(ownerOf), null, new Op(type, this.nonReserved(id), StoreImpl.nonNullPersistable(object), (Transaction)txn), (Transaction)txn);
    }

    private ListenableFuture<byte[]> getAsync(Op.Type type, long id, StoreTransaction txn) {
        return this.cache.doOpAsync(type, id, null, null, (Transaction)txn);
    }

    private ListenableFuture<Persistable> getAsync(Op.Type type, long id, Persistable object, StoreTransaction txn) {
        return this.cache.doOpAsync(type, this.nonReserved(id), StoreImpl.nonNullPersistable(object), null, (Transaction)txn);
    }

    private ListenableFuture<byte[]> getAsync(Op.Type type, long id, short nodeHint, StoreTransaction txn) {
        return this.cache.doOpAsync(type, this.nonReserved(id), null, nodeHint, (Transaction)txn);
    }

    private ListenableFuture<Persistable> getAsync(Op.Type type, long id, short nodeHint, Persistable object, StoreTransaction txn) {
        return this.cache.doOpAsync(type, this.nonReserved(id), StoreImpl.nonNullPersistable(object), nodeHint, (Transaction)txn);
    }

    private ListenableFuture<byte[]> getFromOwnerAsync(Op.Type type, long id, long ownerOf, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.GET_FROM_OWNER, this.nonReserved(ownerOf), null, new Op(type, this.nonReserved(id), (Transaction)txn), (Transaction)txn);
    }

    private ListenableFuture<Persistable> getFromOwnerAsync(Op.Type type, long id, long ownerOf, Persistable object, StoreTransaction txn) {
        return this.cache.doOpAsync(Op.Type.GET_FROM_OWNER, this.nonReserved(ownerOf), null, new Op(type, this.nonReserved(id), StoreImpl.nonNullPersistable(object), (Transaction)txn), (Transaction)txn);
    }

    private long nonReserved(long id) {
        if (id <= 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal use of reserved id " + id);
        }
        return id;
    }

    private void get1(Op.Type type, long id, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(type, id, StoreImpl.nonNullPersistable(object), null, (Transaction)txn);
    }

    private void get1(Op.Type type, long id, short nodeHint, Persistable object, StoreTransaction txn) throws TimeoutException {
        this.cache.doOp(type, id, StoreImpl.nonNullPersistable(object), nodeHint, (Transaction)txn);
    }

    @Override
    public boolean tryPin(long id, ItemState state, StoreTransaction txn) throws IllegalStateException {
        if (state == ItemState.INVALID) {
            throw new IllegalStateException("state Invalid is not permitted");
        }
        return this.cache.tryLock(id, state, (Transaction)txn);
    }
}

