/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.io.Persistable;
import co.paralleluniverse.common.io.Streamables;
import co.paralleluniverse.common.logging.LoggingUtils;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.TimeoutException;
import co.paralleluniverse.galaxy.core.RootLocker;
import co.paralleluniverse.galaxy.core.StoreImpl;
import co.paralleluniverse.galaxy.core.Transaction;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StringRootManager {
    private static final Logger LOG = LoggerFactory.getLogger(StringRootManager.class);
    private final StoreImpl store;
    private final Cluster cluster;
    private final RootLocker rootLocker;

    public StringRootManager(StoreImpl store, Cluster cluster) {
        this.store = store;
        this.cluster = cluster;
        this.rootLocker = (RootLocker)((Object)cluster);
    }

    public long get(String root, Transaction txn) throws TimeoutException {
        return new StringRootPageHandler(root).find(txn, -1L);
    }

    public long get(String root, long ref, Transaction txn) throws TimeoutException {
        return new StringRootPageHandler(root).find(txn, ref);
    }

    private static class Entry
    implements Comparable<Entry>,
    Persistable {
        String str;
        long ref;

        public Entry(String str, long ref) {
            this.str = str;
            this.ref = ref;
        }

        public Entry() {
            this(null, -1L);
        }

        @Override
        public int compareTo(Entry o) {
            return this.str.compareTo(o.str);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.str, other.str);
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        @Override
        public int size() {
            return 2 + Streamables.calcUtfLength(this.str) + 8;
        }

        @Override
        public void write(ByteBuffer buffer) {
            byte[] chars = this.str.getBytes(Charsets.UTF_8);
            buffer.putShort((short)chars.length);
            buffer.put(chars);
            buffer.putLong(this.ref);
        }

        @Override
        public void read(ByteBuffer buffer) {
            short length = buffer.getShort();
            byte[] chars = new byte[length];
            buffer.get(chars);
            this.str = new String(chars, Charsets.UTF_8);
            this.ref = buffer.getLong();
        }
    }

    private static class StringRootPage
    implements Persistable {
        private final ArrayList<Entry> entries = new ArrayList();
        private long nextRef = -1L;

        private StringRootPage() {
        }

        public synchronized long get(String str) {
            int index = Collections.binarySearch(this.entries, new Entry(str, -1L));
            if (index >= 0) {
                return this.entries.get((int)index).ref;
            }
            return -1L;
        }

        public synchronized void put(String str, long ref) {
            Entry entry = new Entry(str, ref);
            int index = Collections.binarySearch(this.entries, entry);
            if (index < 0) {
                this.entries.add(-index - 1, entry);
            } else assert (this.entries.get((int)index).ref == ref);
        }

        public synchronized void setNextRef(long ref) {
            this.nextRef = ref;
        }

        @Override
        public int size() {
            int size = 10;
            for (Entry entry : this.entries) {
                size += entry.size();
            }
            return size;
        }

        @Override
        public synchronized void write(ByteBuffer buffer) {
            buffer.putLong(this.nextRef);
            buffer.putShort((short)this.entries.size());
            for (Entry entry : this.entries) {
                entry.write(buffer);
            }
        }

        @Override
        public synchronized void read(ByteBuffer buffer) {
            if (buffer == null || buffer.remaining() < 10) {
                this.nextRef = -1L;
                return;
            }
            this.nextRef = buffer.getLong();
            int numEntries = buffer.getShort();
            this.entries.ensureCapacity(numEntries);
            for (int i = 0; i < numEntries; ++i) {
                Entry entry = new Entry();
                entry.read(buffer);
                this.entries.add(entry);
            }
        }
    }

    private class StringRootPageHandler
    implements Persistable {
        private final String str;
        private short size;
        private long ref;
        private long result;

        public StringRootPageHandler(String str) {
            this.str = str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long find(Transaction txn, long rootRef) throws TimeoutException {
            this.ref = this.str.hashCode();
            this.result = -1L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Base is {}", (Object)LoggingUtils.hex(this.ref));
            }
            this.initialGet();
            while (this.result < 0L && this.ref >= 0L) {
                StringRootManager.this.store.get1(this.ref, this);
            }
            if (this.result >= 0L) {
                return this.result;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Root for {} not found. Retrying.", (Object)this.str);
            }
            short mySize = (short)new Entry(this.str, -1L).size();
            this.ref = this.str.hashCode();
            long prevRef = -1L;
            while (this.ref != -1L) {
                long curRef = this.ref;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getx {}.", (Object)LoggingUtils.hex(this.ref));
                }
                try {
                    StringRootManager.this.store.getx1(curRef, this, null);
                }
                finally {
                    if (prevRef >= 0L) {
                        StringRootManager.this.store.release(prevRef);
                    }
                }
                if (this.result >= 0L) {
                    StringRootManager.this.store.release(curRef);
                    return this.result;
                }
                if (this.size + mySize <= StringRootManager.this.store.getMaxItemSize()) {
                    long myRef;
                    long l = myRef = rootRef > 0L ? rootRef : StringRootManager.this.store.put(new byte[0], null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("New root for {} is {}. Writing into base {}.", new Object[]{this.str, LoggingUtils.hex(myRef), LoggingUtils.hex(curRef)});
                    }
                    StringRootPage page = new StringRootPage();
                    StringRootManager.this.store.getx1(curRef, page, null);
                    page.put(this.str, myRef);
                    StringRootManager.this.store.set1(curRef, page, null);
                    StringRootManager.this.store.release(curRef);
                    txn.add(myRef);
                    return myRef;
                }
                prevRef = curRef;
            }
            long myRef = rootRef > 0L ? rootRef : StringRootManager.this.store.put(new byte[0], null);
            StringRootPage page = new StringRootPage();
            page.put(this.str, myRef);
            this.ref = StringRootManager.this.store.put(page, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("New root for {} is {}. Writing into new base {}.", new Object[]{this.str, LoggingUtils.hex(myRef), LoggingUtils.hex(this.ref)});
            }
            if (prevRef >= 0L) {
                StringRootManager.this.store.set1(prevRef, this, null);
                StringRootManager.this.store.release(prevRef);
            }
            StringRootManager.this.store.release(this.ref);
            txn.add(myRef);
            return myRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialGet() throws TimeoutException {
            if (StringRootManager.this.cluster.hasServer()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Getting base ({}) from server.", (Object)LoggingUtils.hex(this.ref));
                }
                StringRootManager.this.store.get1(this.ref, (short)0, this);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Locking base ({}) and broadcasting GET.", (Object)LoggingUtils.hex(this.ref));
                }
                Object lock = StringRootManager.this.rootLocker.lockRoot((int)this.ref);
                try {
                    StringRootManager.this.store.get1(this.ref, this);
                }
                finally {
                    StringRootManager.this.rootLocker.unlockRoot(lock);
                }
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void read(ByteBuffer buffer) {
            if (buffer == null || buffer.remaining() < 10) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Buffer {} is empty.", (Object)LoggingUtils.hex(this.ref));
                }
                this.ref = -1L;
                this.size = 0;
                return;
            }
            long nextRef = buffer.getLong();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Next is {}.", (Object)LoggingUtils.hex(nextRef));
            }
            this.ref = nextRef;
            this.size = (short)buffer.limit();
            int numEntries = buffer.getShort();
            for (int i = 0; i < numEntries; ++i) {
                Entry entry = new Entry();
                entry.read(buffer);
                if (!entry.str.equals(this.str)) continue;
                this.result = entry.ref;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found root for {}: {}", (Object)this.str, (Object)LoggingUtils.hex(this.result));
                }
                return;
            }
        }

        @Override
        public void write(ByteBuffer buffer) {
            buffer.putLong(0, this.ref);
            buffer.position(buffer.limit());
        }
    }
}

