/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.core;

import co.paralleluniverse.common.collection.TLongAbstractCollection;
import co.paralleluniverse.common.collection.TLongCompoundCollection;
import co.paralleluniverse.galaxy.StoreTransaction;
import co.paralleluniverse.galaxy.core.Op;
import gnu.trove.TLongCollection;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Transaction
extends StoreTransaction {
    private TLongCollection lines;
    private TLongHashSet ls;
    private List<Op> ops;
    private final TLongObjectHashMap<RollbackInfo> rollbackLog;

    Transaction(boolean rollback) {
        this.rollbackLog = rollback ? new TLongObjectHashMap() : null;
    }

    synchronized void add(long id) {
        if (this.ls == null) {
            this.ls = new TLongHashSet();
        }
        this.ls.add(id);
        if (this.lines == null) {
            this.lines = this.ls;
        } else if (this.lines != this.ls) {
            ((TLongCompoundCollection)this.lines).addCollection((TLongCollection)this.ls);
        }
    }

    synchronized void add(TLongCollection c) {
        if (this.lines == null) {
            this.lines = new TLongCompoundCollection();
        } else if (this.lines == this.ls) {
            this.lines = new TLongCompoundCollection();
            ((TLongCompoundCollection)this.lines).addCollection((TLongCollection)this.ls);
        }
        ((TLongCompoundCollection)this.lines).addCollection(c);
    }

    synchronized void add(Op op) {
        if (this.ops == null) {
            this.ops = new ArrayList<Op>();
        }
        this.ops.add(op);
    }

    synchronized boolean isRecorded(long id) {
        return this.rollbackLog.contains(id);
    }

    synchronized void recordRollback(long id, long version, boolean modified, byte[] data) {
        RollbackInfo prev = (RollbackInfo)this.rollbackLog.putIfAbsent(id, (Object)new RollbackInfo(version, modified, data));
        assert (prev == null);
    }

    synchronized TLongCollection getLines() {
        return this.lines != null ? this.lines : TLongAbstractCollection.EMPTY_COLLECTION;
    }

    synchronized List<Op> getOps() {
        return this.ops == null ? Collections.emptyList() : this.ops;
    }

    synchronized void forEachRollback(TLongObjectProcedure<RollbackInfo> proc) {
        this.rollbackLog.forEachEntry(proc);
    }

    @Override
    public synchronized Iterator<Long> iterator() {
        if (this.lines == null) {
            return Collections.emptyIterator();
        }
        final TLongIterator it = this.lines.iterator();
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Long next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public synchronized boolean contains(long id) {
        if (this.lines == null) {
            return false;
        }
        return this.lines.contains(id);
    }

    public static class RollbackInfo {
        public final long version;
        public final boolean modified;
        public final byte[] data;

        public RollbackInfo(long version, boolean modified, byte[] data) {
            this.version = version;
            this.modified = modified;
            this.data = data;
        }
    }
}

