/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jdbc;

import co.paralleluniverse.common.logging.LoggingUtils;
import co.paralleluniverse.common.spring.Component;
import co.paralleluniverse.galaxy.server.MainMemoryDB;
import co.paralleluniverse.galaxy.server.MainMemoryEntry;
import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDB
extends Component
implements MainMemoryDB {
    private static final Logger LOG = LoggerFactory.getLogger(SQLDB.class);
    private final DataSource dataSource;
    private String username;
    private String password;
    private String schema = "pugalaxy";
    private String tableName = "memory";
    private String table;
    private String allocationTableName = "allocation";
    private String allocTable;
    private String bigintType;
    private String smallintType;
    private String varbinaryType;
    private int maxItemSize = 1024;
    private boolean useUpdateableCursors = false;
    private Connection conn;
    private PreparedStatement casOwner;
    private PreparedStatement getOwner;
    private PreparedStatement deleteOwner;
    private PreparedStatement insertLine;
    private PreparedStatement setLine;
    private PreparedStatement getLine;
    private PreparedStatement deleteLine;
    private PreparedStatement selectAll;
    private PreparedStatement getMaxId;
    private PreparedStatement addAllocation;
    private PreparedStatement getAllocation;
    private static final Object TRANSACTION = new Object();

    @ConstructorProperties(value={"name", "dataSource"})
    public SQLDB(String name, DataSource dataSource) {
        super(name);
        this.dataSource = dataSource;
    }

    public void setPassword(String password) {
        this.assertDuringInitialization();
        this.password = password;
    }

    public void setUsername(String username) {
        this.assertDuringInitialization();
        this.username = username;
    }

    public void setSchema(String schema) {
        this.assertDuringInitialization();
        this.schema = schema;
    }

    public void setTableName(String tableName) {
        this.assertDuringInitialization();
        this.tableName = tableName;
    }

    public void setAllocationTableName(String tableName) {
        this.assertDuringInitialization();
        this.allocationTableName = tableName;
    }

    public void setMaxItemSize(int maxItemSize) {
        this.assertDuringInitialization();
        this.maxItemSize = maxItemSize;
    }

    public void setUseUpdateableCursors(boolean useUpdateableCursors) {
        this.assertDuringInitialization();
        this.useUpdateableCursors = useUpdateableCursors;
    }

    public void setBigintType(String bigintType) {
        this.assertDuringInitialization();
        this.bigintType = bigintType;
    }

    public void setVarbinaryType(String varbinaryType) {
        this.assertDuringInitialization();
        this.varbinaryType = varbinaryType;
    }

    public void setSmallintType(String smallintType) {
        this.assertDuringInitialization();
        this.smallintType = smallintType;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        LOG.info("Connecting to database {}", (Object)this.dataSource);
        this.conn = this.username != null ? this.dataSource.getConnection(this.username, this.password) : this.dataSource.getConnection();
        LOG.info("Connection successful");
        this.initDbTypes();
        this.table = this.schema + "." + this.tableName;
        this.allocTable = this.schema + "." + this.allocationTableName;
        this.initTable();
        this.initPreparedStatements();
        this.conn.setAutoCommit(false);
        this.conn.setTransactionIsolation(2);
    }

    private void initTable() throws SQLException {
        try (Statement stmt = this.conn.createStatement();){
            String createTable = "CREATE TABLE " + this.table + " " + "(id " + this.bigintType + " PRIMARY KEY, " + "owner " + this.smallintType + " NOT NULL, " + "version " + this.bigintType + " NOT NULL, " + "data " + this.createVarbinary(this.maxItemSize) + ")";
            LOG.debug("Creating table: {}", (Object)createTable);
            stmt.executeUpdate(createTable);
            stmt.executeUpdate("CREATE INDEX owner_index ON " + this.table + "(owner)");
            createTable = "CREATE TABLE " + this.allocTable + " " + "(id " + this.bigintType + " PRIMARY KEY, " + "end " + this.bigintType + " NOT NULL, " + "owner " + this.smallintType + " NOT NULL " + ")";
            LOG.debug("Creating table: {}", (Object)createTable);
            stmt.executeUpdate(createTable);
        }
        catch (SQLException e) {
            LOG.debug("SQLException caught: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    private void initPreparedStatements() throws SQLException {
        this.getMaxId();
        this.dump(null);
        this.insert(0L, (short)0, 0L, null, null);
        this.read(0L);
        this.write(0L, (short)0, 0L, null, null);
        this.delete(0L, null);
        this.removeOwner((short)0);
        if (this.useUpdateableCursors) {
            this.casOwnerUpdateableCursor(0L, (short)0, (short)0);
        } else {
            this.casOwnerUpdate(0L, (short)0, (short)0);
            this.getOwner(0L);
        }
        this.allocate((short)0, 0L, 0);
        this.findAllocation(0L);
    }

    private void initDbTypes() throws SQLException {
        if (this.bigintType == null || this.smallintType == null || this.varbinaryType == null) {
            HashMap<Integer, String> types = new HashMap<Integer, String>();
            DatabaseMetaData dmd = this.conn.getMetaData();
            try (ResultSet rs = dmd.getTypeInfo();){
                while (rs.next()) {
                    int jdbcType = rs.getInt("DATA_TYPE");
                    String typeName = rs.getString("TYPE_NAME");
                    types.put(jdbcType, typeName);
                }
            }
            if (this.bigintType == null) {
                this.bigintType = (String)types.get(-5);
            }
            if (this.smallintType == null) {
                this.smallintType = (String)types.get(5);
            }
            if (this.varbinaryType == null) {
                this.varbinaryType = (String)types.get(-3);
            }
            LOG.debug("BIGINT type is: {}", (Object)this.bigintType);
            LOG.debug("SMALLINT type is: {}", (Object)this.smallintType);
            LOG.debug("VARBINARY type is: {}", (Object)this.varbinaryType);
        }
    }

    private String createVarbinary(int size) {
        if (this.varbinaryType.contains("()")) {
            return this.varbinaryType.replace("()", "(" + size + ")");
        }
        return this.varbinaryType + "(" + size + ")";
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Object beginTransaction() {
        return TRANSACTION;
    }

    @Override
    public void commit(Object txn) {
        try {
            LOG.debug("COMMIT");
            assert (txn == TRANSACTION);
            this.conn.commit();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void abort(Object txn) {
        try {
            LOG.debug("ROLLBACK");
            assert (txn == TRANSACTION);
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void write(long id, short owner, long version, byte[] data, Object txn) {
        if (this.setLine == null) {
            this.setLine = this.prepareStatement("UPDATE " + this.table + " SET version = ?, data = ? WHERE id = ? AND owner = ?");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WRITE " + id + " ver: " + version + " data: (" + data.length + " bytes)");
        }
        if (data.length > this.maxItemSize) {
            LOG.error("Data length is {}, which is bigger than maxItemSize ({})", (Object)data.length, (Object)this.maxItemSize);
            throw new RuntimeException("Data too big.");
        }
        try {
            this.setLine.setLong(3, id);
            this.setLine.setShort(4, owner);
            this.setLine.setLong(1, version);
            this.setLine.setBytes(2, data);
            if (this.setLine.executeUpdate() < 1) {
                LOG.debug("Setting line {} failed. Inserting.", (Object)id);
                this.insert(id, owner, version, data, txn);
            } else if (txn == null) {
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MainMemoryEntry read(long id) {
        if (this.getLine == null) {
            this.getLine = this.prepareStatement("SELECT version, data FROM " + this.table + "  WHERE id = ?");
            return null;
        }
        try {
            this.getLine.setLong(1, id);
            try (ResultSet rs = this.getLine.executeQuery();){
                rs.next();
                long version = rs.getLong(1);
                byte[] data = rs.getBytes(2);
                this.conn.commit();
                MainMemoryEntry mainMemoryEntry = new MainMemoryEntry(version, data);
                return mainMemoryEntry;
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public short casOwner(long id, short oldNode, short newNode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CAS owner of {}: {} -> {}", new Object[]{id, oldNode, newNode});
        }
        try {
            if (oldNode < 0) {
                try {
                    this.insert(id, newNode, -1L, null, null);
                    LOG.debug("CAS owner succeeded (insert).");
                    return newNode;
                }
                catch (SQLException e) {
                    LOG.debug("CAS owner failed (insert).");
                    return this.getOwner(id);
                }
            }
            if (this.useUpdateableCursors) {
                return this.casOwnerUpdateableCursor(id, oldNode, newNode);
            }
            return this.casOwnerUpdate(id, oldNode, newNode);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private short casOwnerUpdateableCursor(long id, short oldNode, short newNode) throws SQLException {
        if (this.casOwner == null) {
            this.casOwner = this.prepareStatement("SELECT owner FROM " + this.table + " WHERE id = ? FOR UPDATE", 1003, 1008);
            return 0;
        }
        this.casOwner.setLong(1, id);
        try (ResultSet rs = this.casOwner.executeQuery();){
            if (rs.next()) {
                short res;
                short currentOwner = rs.getShort(1);
                if (currentOwner != oldNode) {
                    LOG.debug("CAS owner failed (UC).");
                    res = currentOwner;
                } else {
                    rs.updateShort(1, newNode);
                    LOG.debug("CAS owner succeeded (UC).");
                    res = newNode;
                }
                this.conn.commit();
                short s = res;
                return s;
            }
            LOG.debug("CAS owner failed (UC).");
            short s = -1;
            return s;
        }
    }

    private short casOwnerUpdate(long id, short oldNode, short newNode) throws SQLException {
        short res;
        if (this.casOwner == null) {
            this.casOwner = this.prepareStatement("UPDATE " + this.table + " SET owner = ? WHERE id = ? AND owner = ?");
            return 0;
        }
        this.casOwner.setLong(2, id);
        this.casOwner.setShort(3, oldNode);
        this.casOwner.setShort(1, newNode);
        int rows = this.casOwner.executeUpdate();
        if (rows > 0) {
            LOG.debug("CAS owner succeeded.");
            res = newNode;
        } else {
            LOG.debug("CAS owner failed.");
            res = this.getOwner(id);
        }
        this.conn.commit();
        return res;
    }

    private short getOwner(long id) throws SQLException {
        if (this.getOwner == null) {
            this.getOwner = this.conn.prepareStatement("SELECT owner FROM " + this.table + " WHERE id = ?");
            return 0;
        }
        this.getOwner.setLong(1, id);
        try (ResultSet rs = this.getOwner.executeQuery();){
            short res = rs.next() ? (short)rs.getShort(1) : (short)-1;
            this.conn.commit();
            short s = res;
            return s;
        }
    }

    private void insert(long id, short owner, long version, byte[] data, Object txn) throws SQLException {
        if (this.insertLine == null) {
            this.insertLine = this.prepareStatement("INSERT INTO " + this.table + " (id, owner, version, data) VALUES (?, ?, ?, ?)");
            return;
        }
        this.insertLine.setLong(1, id);
        this.insertLine.setShort(2, owner);
        this.insertLine.setLong(3, version);
        this.insertLine.setBytes(4, data);
        this.insertLine.executeUpdate();
        if (txn == null) {
            this.conn.commit();
        }
    }

    @Override
    public void delete(long id, Object txn) {
        if (this.deleteLine == null) {
            this.deleteLine = this.prepareStatement("DELETE FROM " + this.table + " WHERE id = ?");
            return;
        }
        try {
            this.deleteLine.setLong(1, id);
            this.deleteLine.executeUpdate();
            if (txn == null) {
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void removeOwner(short node) {
        if (this.deleteOwner == null) {
            this.deleteOwner = this.prepareStatement("UPDATE " + this.table + " SET owner = 0 WHERE owner = ?");
            return;
        }
        try {
            this.deleteOwner.setShort(1, node);
            this.deleteOwner.executeUpdate();
            this.conn.commit();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void allocate(short owner, long start, int num) {
        if (owner <= 0) {
            this.addAllocation = this.prepareStatement("INSERT INTO " + this.allocTable + " (id, end, owner) VALUES (?, ?, ?)");
            return;
        }
        try {
            this.addAllocation.setLong(1, start);
            this.addAllocation.setLong(2, start + (long)num);
            this.addAllocation.setShort(3, owner);
            this.addAllocation.executeUpdate();
            this.conn.commit();
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public short findAllocation(long ref) {
        if (ref <= 0L) {
            this.getAllocation = this.prepareStatement("SELECT owner FROM " + this.allocTable + " WHERE id <= ? AND end > ?");
            return 0;
        }
        try {
            this.getAllocation.setLong(1, ref);
            this.getAllocation.setLong(2, ref);
            try (ResultSet rs = this.getAllocation.executeQuery();){
                short res = rs.next() ? (short)rs.getShort(1) : (short)-1;
                this.conn.commit();
                short s = res;
                return s;
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getMaxId() {
        if (this.getMaxId == null) {
            this.getMaxId = this.prepareStatement("SELECT MAX(id) FROM " + this.allocTable);
            return 0L;
        }
        try (ResultSet rs = this.getMaxId.executeQuery();){
            long res = rs.next() ? rs.getLong(1) : 0L;
            this.conn.commit();
            long l = res;
            return l;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void dump(PrintStream ps) {
        if (this.selectAll == null) {
            this.selectAll = this.prepareStatement("SELECT * FROM " + this.table);
            return;
        }
        try {
            ps.println("MEMORY");
            ps.println("===========");
            try (ResultSet rs = this.selectAll.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("id");
                    short owner = rs.getShort("owner");
                    long version = rs.getLong("version");
                    byte[] data = rs.getBytes("data");
                    ps.println("Id : " + LoggingUtils.hex(id) + " owner: " + owner + " version: " + version + " data: (" + data.length + " bytes).");
                }
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private PreparedStatement prepareStatement(String sql) {
        try {
            this.assertDuringInitialization();
            return this.conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            LOG.error("Error while preparing statement: " + sql, (Throwable)e);
            throw new Error(e);
        }
    }

    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        try {
            this.assertDuringInitialization();
            return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            LOG.error("Error while preparing statement: " + sql, (Throwable)e);
            throw new Error(e);
        }
    }
}

