/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jgroups;

import co.paralleluniverse.galaxy.jgroups.Channel;
import co.paralleluniverse.galaxy.jgroups.ExtendedChannel;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.UUID;

public class ChannelExtender
implements ExtendedChannel {
    private final Channel channel;

    public ChannelExtender(Channel jchannel) {
        this.channel = jchannel;
    }

    @Override
    public void send(Address dst, byte[] buf, int offset, int length) throws Exception {
        this.send(new Message(dst, null, buf, offset, length));
    }

    @Override
    public void send(Address dst, byte[] buf) throws Exception {
        this.send(new Message(dst, null, buf));
    }

    @Override
    public void send(Address dst, Object obj) throws Exception {
        this.send(new Message(dst, null, obj));
    }

    @Override
    public String getViewAsString() {
        View v = this.getView();
        return v != null ? v.toString() : "n/a";
    }

    @Override
    public String getAddressAsUUID() {
        return this.getAddress() instanceof UUID ? ((UUID)this.getAddress()).toStringLong() : null;
    }

    @Override
    public String getAddressAsString() {
        return this.getAddress() != null ? this.getAddress().toString() : "n/a";
    }

    @Override
    public void setDiscardOwnMessages(boolean flag) {
        this.channel.setDiscardOwnMessages(flag);
    }

    @Override
    public boolean getDiscardOwnMessages() {
        return this.channel.getDiscardOwnMessages();
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        this.channel.removeChannelListener(listener);
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        this.channel.addChannelListener(listener);
    }

    @Override
    public void setReceiver(Receiver r) {
        this.channel.setReceiver(r);
    }

    @Override
    public Receiver getReceiver() {
        return this.channel.getReceiver();
    }

    @Override
    public void send(Message msg) throws Exception {
        this.channel.send(msg);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public View getView() {
        return this.channel.getView();
    }

    @Override
    public void getState(Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        this.channel.getState(target, timeout, useFlushIfPresent);
    }

    public void getState(Address target, long timeout) throws Exception {
        this.getState(target, timeout, true);
    }

    @Override
    public String getName(Address member) {
        return this.channel.getName(member);
    }

    @Override
    public String getName() {
        return this.channel.getName();
    }

    @Override
    public String getClusterName() {
        return this.channel.getClusterName();
    }

    @Override
    public Address getAddress() {
        return this.channel.getAddress();
    }

    @Override
    public <T extends Protocol> boolean hasProtocol(Class<T> protocolType) {
        return this.channel.hasProtocol(protocolType);
    }
}

