/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jgroups;

import co.paralleluniverse.galaxy.jgroups.ExtendedChannel;
import co.paralleluniverse.galaxy.jgroups.JChannelAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.InputStream;
import java.io.OutputStream;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.StateTransferResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlChannel
extends JChannelAdapter
implements ExtendedChannel,
UpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ControlChannel.class);
    private static final short MAGIC_HEADER = 1199;
    private static final ControlHeader CONTROL_MARKER;
    private Receiver receiver;
    private final boolean dataDiscardOwnMessages;
    private boolean discardOwnMessages;

    public ControlChannel(JChannel channel) {
        super(channel);
        this.dataDiscardOwnMessages = channel.getDiscardOwnMessages();
        channel.setDiscardOwnMessages(false);
        channel.setUpHandler((UpHandler)this);
    }

    @Override
    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    @Override
    public void setDiscardOwnMessages(boolean flag) {
        this.discardOwnMessages = flag;
    }

    @Override
    public boolean getDiscardOwnMessages() {
        return this.discardOwnMessages;
    }

    @Override
    public void send(Message msg) throws Exception {
        msg.putHeader((short)1199, (Header)CONTROL_MARKER);
        super.send(msg);
    }

    public Object up(Event evt) {
        Receiver dataReceiver = this.jchannel.getReceiver();
        if (this.receiver != null) {
            switch (evt.getType()) {
                case 1: {
                    Message msg = (Message)evt.getArg();
                    if (msg.getHeader((short)1199) != null) {
                        if (this.discardOwnMessages && this.getAddress() != null && msg.getSrc() != null && this.getAddress().equals(msg.getSrc())) break;
                        this.receiver.receive(msg);
                        break;
                    }
                    if (dataReceiver == null || this.dataDiscardOwnMessages && this.getAddress() != null && msg.getSrc() != null && this.getAddress().equals(msg.getSrc())) break;
                    dataReceiver.receive(msg);
                    break;
                }
                case 6: {
                    this.receiver.viewAccepted((View)evt.getArg());
                    break;
                }
                case 9: {
                    this.receiver.suspect((Address)evt.getArg());
                    break;
                }
                case 20: {
                    StateTransferResult result = (StateTransferResult)evt.getArg();
                    byte[] state = result.getBuffer();
                    if (state == null) break;
                    ByteArrayInputStream input = new ByteArrayInputStream(state);
                    try {
                        this.receiver.setState((InputStream)input);
                        break;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                case 71: {
                    InputStream is = (InputStream)evt.getArg();
                    if (is == null) break;
                    try {
                        this.receiver.setState(is);
                        break;
                    }
                    catch (Throwable t) {
                        LOG.error("Error while setting state", t);
                        throw new RuntimeException("failed calling setState() in state requester", t);
                    }
                }
                case 17: {
                    byte[] tmpState = null;
                    if (this.receiver != null) {
                        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                        try {
                            this.receiver.getState((OutputStream)output);
                            tmpState = output.toByteArray();
                        }
                        catch (Exception e) {
                            LOG.error("Error while getting state", (Throwable)e);
                            throw new RuntimeException(this.getAddress() + ": failed getting state from application", e);
                        }
                    }
                    return new StateTransferInfo(null, 0L, tmpState);
                }
                case 10: {
                    this.receiver.block();
                    if (dataReceiver != null) {
                        dataReceiver.block();
                    }
                    return true;
                }
                case 75: {
                    this.receiver.unblock();
                    if (dataReceiver == null) break;
                    dataReceiver.unblock();
                }
            }
        }
        return null;
    }

    static {
        ClassConfigurator.add((short)1199, ControlHeader.class);
        CONTROL_MARKER = new ControlHeader();
    }

    public static class ControlHeader
    extends Header {
        public int size() {
            return 0;
        }

        public void writeTo(DataOutput out) throws Exception {
        }

        public void readFrom(DataInput in) throws Exception {
        }
    }
}

