/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jgroups;

import co.paralleluniverse.galaxy.cluster.DistributedTree;
import co.paralleluniverse.galaxy.jgroups.ReplicatedTree;
import java.io.PrintStream;
import java.util.List;

class DistributedTreeAdapter
implements DistributedTree {
    private final ReplicatedTree tree;

    public DistributedTreeAdapter(ReplicatedTree tree) {
        this.tree = tree;
    }

    @Override
    public void addListener(String node, DistributedTree.Listener listener) {
        this.tree.addListener(node, new ListenerAdapter(listener));
        List<String> children = this.tree.getChildren(node);
        if (children == null) {
            return;
        }
        for (String child : children) {
            listener.nodeChildAdded(node, child);
        }
    }

    @Override
    public void removeListener(String node, DistributedTree.Listener listener) {
        this.tree.removeListener(node, new ListenerAdapter(listener));
    }

    @Override
    public void create(String node, boolean ephemeral) {
        this.tree.create(node, ephemeral);
    }

    @Override
    public void createEphemeralOrdered(String node) {
        this.tree.create(node, true);
    }

    @Override
    public void set(String node, byte[] data) {
        this.tree.set(node, data);
    }

    @Override
    public void delete(String node) {
        this.tree.remove(node);
    }

    @Override
    public void flush() {
        this.tree.flush();
    }

    @Override
    public boolean exists(String node) {
        return this.tree.exists(node);
    }

    @Override
    public byte[] get(String node) {
        return this.tree.get(node);
    }

    @Override
    public List<String> getChildren(String node) {
        return this.tree.getChildren(node);
    }

    @Override
    public void print(String node, PrintStream out) {
        out.println(this.tree.toString(node));
    }

    private static class ListenerAdapter
    implements ReplicatedTree.ReplicatedTreeListener {
        private final DistributedTree.Listener listener;

        public ListenerAdapter(DistributedTree.Listener listener) {
            this.listener = listener;
        }

        @Override
        public void nodeAdded(String fqn) {
            this.listener.nodeAdded(fqn);
        }

        @Override
        public void nodeRemoved(String fqn) {
            this.listener.nodeDeleted(fqn);
        }

        @Override
        public void nodeUpdated(String fqn) {
            this.listener.nodeUpdated(fqn);
        }

        @Override
        public void nodeChildAdded(String parentFqn, String childName) {
            this.listener.nodeChildAdded(parentFqn, childName);
        }

        @Override
        public void nodeChildRemoved(String parentFqn, String childName) {
            this.listener.nodeChildDeleted(parentFqn, childName);
        }

        @Override
        public void nodeChildUpdated(String parentFqn, String childName) {
            this.listener.nodeChildUpdated(parentFqn, childName);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ListenerAdapter)) {
                return false;
            }
            return this.listener == ((ListenerAdapter)obj).listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

