/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jgroups;

import co.paralleluniverse.galaxy.jgroups.Channel;
import co.paralleluniverse.galaxy.jgroups.ChannelExtender;
import co.paralleluniverse.galaxy.jgroups.ExtendedChannel;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.UUID;

class JChannelAdapter
implements ExtendedChannel {
    protected final JChannel jchannel;

    public static Channel asChannel(JChannel jchannel) {
        return new JChannelAdapter(jchannel);
    }

    public static ChannelExtender asExtendedChannel(JChannel jchannel) {
        return new ChannelExtender(new JChannelAdapter(jchannel));
    }

    public JChannelAdapter(JChannel jchannel) {
        this.jchannel = jchannel;
    }

    @Override
    public void send(Address dst, byte[] buf, int offset, int length) throws Exception {
        this.send(new Message(dst, null, buf, offset, length));
    }

    @Override
    public void send(Address dst, byte[] buf) throws Exception {
        this.send(new Message(dst, null, buf));
    }

    @Override
    public void send(Address dst, Object obj) throws Exception {
        this.send(new Message(dst, null, obj));
    }

    @Override
    public String getViewAsString() {
        View v = this.getView();
        return v != null ? v.toString() : "n/a";
    }

    @Override
    public String getAddressAsUUID() {
        return this.getAddress() instanceof UUID ? ((UUID)this.getAddress()).toStringLong() : null;
    }

    @Override
    public String getAddressAsString() {
        return this.getAddress() != null ? this.getAddress().toString() : "n/a";
    }

    @Override
    public void setDiscardOwnMessages(boolean flag) {
        this.jchannel.setDiscardOwnMessages(flag);
    }

    @Override
    public boolean getDiscardOwnMessages() {
        return this.jchannel.getDiscardOwnMessages();
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        this.jchannel.removeChannelListener(listener);
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        this.jchannel.addChannelListener(listener);
    }

    @Override
    public void setReceiver(Receiver r) {
        this.jchannel.setReceiver(r);
    }

    @Override
    public Receiver getReceiver() {
        return this.jchannel.getReceiver();
    }

    @Override
    public void send(Message msg) throws Exception {
        this.jchannel.send(msg);
    }

    @Override
    public boolean isOpen() {
        return this.jchannel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.jchannel.isConnected();
    }

    @Override
    public View getView() {
        return this.jchannel.getView();
    }

    @Override
    public void getState(Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        this.jchannel.getState(target, timeout, useFlushIfPresent);
    }

    @Override
    public String getName(Address member) {
        return this.jchannel.getName(member);
    }

    @Override
    public String getName() {
        return this.jchannel.getName();
    }

    @Override
    public String getClusterName() {
        return this.jchannel.getClusterName();
    }

    @Override
    public Address getAddress() {
        return this.jchannel.getAddress();
    }

    @Override
    public <T extends Protocol> boolean hasProtocol(Class<T> protocolType) {
        return this.jchannel.getProtocolStack().findProtocol(protocolType) != null;
    }
}

