/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jgroups;

import co.paralleluniverse.common.monitoring.ThreadPoolExecutorMonitor;
import co.paralleluniverse.galaxy.core.AbstractCluster;
import co.paralleluniverse.galaxy.core.CommThread;
import co.paralleluniverse.galaxy.core.RefAllocator;
import co.paralleluniverse.galaxy.core.RefAllocatorSupport;
import co.paralleluniverse.galaxy.core.RootLocker;
import co.paralleluniverse.galaxy.jgroups.Channel;
import co.paralleluniverse.galaxy.jgroups.ControlChannel;
import co.paralleluniverse.galaxy.jgroups.DistributedTreeAdapter;
import co.paralleluniverse.galaxy.jgroups.JChannelAdapter;
import co.paralleluniverse.galaxy.jgroups.JGroupsConstants;
import co.paralleluniverse.galaxy.jgroups.ReplicatedTree;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.blocks.atomic.CounterService;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.protocols.SEQUENCER;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class JGroupsCluster
extends AbstractCluster
implements RootLocker,
RefAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsCluster.class);
    private static final long INITIAL_REF_ID = 0x100000000L;
    private final String jgroupsClusterName;
    private JChannel channel;
    private CounterService counterService;
    private LockService lockService;
    private Counter refIdCounter;
    private Channel controlChannel;
    private Channel dataChannel;
    private String jgroupsConfFile;
    private Element jgroupsConfXML;
    private ThreadPoolExecutor jgroupsThreadPool;
    private final RefAllocatorSupport refAllocatorSupport = new RefAllocatorSupport();
    private final ExecutorService refAllocationExecutor = Executors.newFixedThreadPool(1);
    private volatile boolean counterReady;

    @ConstructorProperties(value={"name", "nodeId", "jgroupsClusterName"})
    public JGroupsCluster(String name, short nodeId, String jgroupsClusterName) throws Exception {
        super(name, nodeId);
        this.jgroupsClusterName = jgroupsClusterName;
    }

    public void setJgroupsConfFile(String jgroupsConfFile) {
        this.assertDuringInitialization();
        this.jgroupsConfFile = jgroupsConfFile;
    }

    public void setJgroupsConf(Element jgroupsConfXML) {
        this.assertDuringInitialization();
        this.jgroupsConfXML = jgroupsConfXML;
    }

    public void setJgroupsThreadPool(ThreadPoolExecutor threadPool) {
        this.assertDuringInitialization();
        this.jgroupsThreadPool = threadPool;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.jgroupsConfXML != null) {
            this.channel = new JChannel(this.jgroupsConfXML);
        } else if (this.jgroupsConfFile != null) {
            this.channel = new JChannel(this.jgroupsConfFile);
        } else {
            throw new IllegalStateException("jgroupsConf or jgroupsConfFile must be set!");
        }
        if (this.jgroupsConfXML != null && this.jgroupsConfFile != null) {
            throw new IllegalStateException("jgroupsConf or jgroupsConfFile cannot both be set!");
        }
        this.controlChannel = new ControlChannel(this.channel);
        if (!this.controlChannel.hasProtocol(SEQUENCER.class)) {
            throw new RuntimeException("JChannel must have the SEQUENCER protocol");
        }
        this.addNodeProperty("jg_addr", true, true, JGroupsConstants.JGROUPS_ADDRESS_READER_WRITER);
        this.channel.addChannelListener(new ChannelListener(){

            public void channelConnected(org.jgroups.Channel channel) {
            }

            public void channelDisconnected(org.jgroups.Channel channel) {
                LOG.warn("JGroups channel disconnected. Going offline!");
                JGroupsCluster.this.goOffline();
            }

            public void channelClosed(org.jgroups.Channel channel) {
                LOG.warn("JGroups channel closed. Going offline!");
                JGroupsCluster.this.goOffline();
            }
        });
        DistributedTreeAdapter tree = new DistributedTreeAdapter(new ReplicatedTree(this.controlChannel, null, 10000L));
        if (this.jgroupsThreadPool == null) {
            throw new RuntimeException("jgroupsThreadPool property not set!");
        }
        this.jgroupsThreadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        this.jgroupsThreadPool.setThreadFactory(new ThreadFactoryBuilder().setNameFormat("jgroups-%d").setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new CommThread(r);
            }
        }).build());
        ThreadPoolExecutorMonitor.register("jgroups", this.jgroupsThreadPool);
        this.channel.getProtocolStack().getTransport().setDefaultThreadPool((Executor)this.jgroupsThreadPool);
        this.channel.connect(this.jgroupsClusterName, null, 10000L);
        this.setName(this.getMyAddress().toString());
        this.setNodeProperty("jg_addr", this.getMyAddress());
        this.initRefIdCounter();
        if (!this.hasServer()) {
            this.lockService = new LockService(this.channel);
        }
        this.dataChannel = new JChannelAdapter(this.channel){

            @Override
            public void send(Message msg) throws Exception {
                msg.setFlag(new Message.Flag[]{Message.NO_TOTAL_ORDER});
                super.send(msg);
            }
        };
        this.setControlTree(tree);
        super.init();
    }

    private void initRefIdCounter() throws Exception {
        this.counterService = new CounterService(this.channel);
        this.refIdCounter = this.counterService.getOrCreateCounter("refIdCounter", 1L);
        if (!this.hasServer()) {
            this.setCounter(0x100000000L);
        }
        this.refAllocationExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                long id;
                LOG.info("Waiting for id counter to be set...");
                while ((id = JGroupsCluster.this.refIdCounter.get()) < 0x100000000L) {
                    Thread.sleep(500L);
                }
                LOG.info("Id counter set: {}", (Object)id);
                JGroupsCluster.this.counterReady = true;
                JGroupsCluster.this.refAllocatorSupport.fireCounterReady();
                return null;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.refAllocationExecutor.shutdownNow();
        this.channel.disconnect();
        this.channel.close();
    }

    @Override
    public Object getUnderlyingResource() {
        return this.channel;
    }

    @Override
    protected boolean isMe(AbstractCluster.NodeInfoImpl node) {
        return node.get("jg_addr").equals(this.getMyAddress());
    }

    protected final Address getMyAddress() {
        return this.channel.getAddress();
    }

    public Channel getDataChannel() {
        return this.dataChannel;
    }

    private boolean setCounter(long initialValue) {
        long id;
        initialValue = Math.max(initialValue, 0x100000000L);
        LOG.info("Setting ref counter to {}", (Object)initialValue);
        do {
            if ((id = this.refIdCounter.get()) < initialValue) continue;
            LOG.info("Id counter set by someone else to {}", (Object)id);
            return false;
        } while (!this.refIdCounter.compareAndSet(id, initialValue));
        LOG.info("Set id counter to {}", (Object)initialValue);
        return true;
    }

    @Override
    public void addRefAllocationsListener(RefAllocator.RefAllocationsListener listener) {
        this.refAllocatorSupport.addRefAllocationsListener(listener);
        if (this.counterReady) {
            listener.counterReady();
        }
    }

    @Override
    public void removeRefAllocationsListener(RefAllocator.RefAllocationsListener listener) {
        this.refAllocatorSupport.addRefAllocationsListener(listener);
    }

    @Override
    public Collection<RefAllocator.RefAllocationsListener> getRefAllocationsListeners() {
        return this.refAllocatorSupport.getRefAllocationListeners();
    }

    @Override
    public void allocateRefs(final int count) {
        this.refAllocationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                long end = JGroupsCluster.this.refIdCounter.addAndGet((long)count);
                JGroupsCluster.this.refAllocatorSupport.fireRefsAllocated(end - (long)count, count);
            }
        });
    }

    @Override
    public Object lockRoot(int id) {
        Lock lock = this.lockService.getLock(Integer.toHexString(id));
        lock.lock();
        return lock;
    }

    @Override
    public void unlockRoot(Object obj) {
        ((Lock)obj).unlock();
    }
}

