/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jgroups;

import co.paralleluniverse.galaxy.cluster.ReaderWriter;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import org.jgroups.Address;
import org.jgroups.util.Util;

final class JGroupsConstants {
    public static final String JGROUPS_ADDRESS = "jg_addr";
    public static final ReaderWriter<Address> JGROUPS_ADDRESS_READER_WRITER = new ReaderWriter<Address>(){

        @Override
        public Address read(byte[] data) {
            try {
                return Util.readAddress((DataInput)new DataInputStream(new ByteArrayInputStream(data)));
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }

        @Override
        public byte[] write(Address value) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                Util.writeAddress((Address)value, (DataOutput)dos);
                dos.flush();
                return baos.toByteArray();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    };

    private JGroupsConstants() {
    }
}

