/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.jgroups;

import co.paralleluniverse.galaxy.jgroups.Channel;
import co.paralleluniverse.galaxy.jgroups.JChannelAdapter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.SEQUENCER;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedTree {
    public static final char SEPARATOR = '/';
    public static final String SSEPARATOR = Character.toString('/');
    private static final int INDENT = 4;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedTree.class);
    private final Channel channel;
    private final Node root = new Node("", SSEPARATOR, null, null, null);
    private final List<Address> members = new ArrayList<Address>();
    private final ConflictResolver conflictResolver;
    private final long getStateTimeout;
    private Address otherAddress;
    private boolean running = true;
    private final Multimap<String, ReplicatedTreeListener> pendingListeners = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Object lock = new Object();
    private final Object updateCondition = new Object();
    private final Receiver myReceiver = new ReceiverAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void receive(Message msg) {
            if (msg == null || msg.getLength() == 0) {
                return;
            }
            try {
                Request req = (Request)msg.getObject();
                String fqn = req.fqn;
                switch (req.type) {
                    case 1: {
                        ReplicatedTree.this._create(fqn, req.ephemeral ? msg.getSrc() : null);
                        return;
                    }
                    case 2: {
                        ReplicatedTree.this._set(fqn, req.data);
                        return;
                    }
                    case 3: {
                        ReplicatedTree.this._remove(fqn);
                        return;
                    }
                    default: {
                        LOG.error("type {} unknown", (Object)req.type);
                        return;
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("failed unmarshalling request", (Throwable)ex);
                return;
            }
            finally {
                Object object = ReplicatedTree.this.updateCondition;
                synchronized (object) {
                    ReplicatedTree.this.updateCondition.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) throws Exception {
            Node node = ReplicatedTree.this.root;
            synchronized (node) {
                LOG.info("State requested");
                Util.objectToStream((Object)ReplicatedTree.this.root, (DataOutput)new DataOutputStream(ostream));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) throws Exception {
            Node node = ReplicatedTree.this.root;
            synchronized (node) {
                LOG.info("State received");
                Node _root = (Node)Util.objectFromStream((DataInput)new DataInputStream(istream));
                ReplicatedTree.this.merge(ReplicatedTree.this.root, _root);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View newView) {
            LOG.info("New view accepted: {}", (Object)newView);
            if (newView instanceof MergeView) {
                LOG.info("Merge view");
                MergeView mergeView = (MergeView)newView;
                List subgroups = mergeView.getSubgroups();
                for (View subgroup : subgroups) {
                    if (subgroup.containsMember(ReplicatedTree.this.channel.getAddress())) continue;
                    try {
                        ReplicatedTree.this.otherAddress = (Address)subgroup.getMembers().get(0);
                        LOG.info("Merging state with {}", (Object)ReplicatedTree.this.otherAddress);
                        ReplicatedTree.this.channel.getState(ReplicatedTree.this.otherAddress, ReplicatedTree.this.getStateTimeout, false);
                    }
                    catch (Exception ex) {
                        LOG.error("Exception while getting state", (Throwable)ex);
                    }
                    finally {
                        ReplicatedTree.this.otherAddress = null;
                    }
                }
                LOG.info("Done merging state.");
            }
            List currentMembers = newView.getMembers();
            HashSet dead = new HashSet(ReplicatedTree.this.members);
            dead.removeAll(currentMembers);
            ReplicatedTree.this.members.clear();
            ReplicatedTree.this.members.addAll(currentMembers);
            LOG.info("Dead members: {}", dead);
            ReplicatedTree.this.removeDeadEphemerals(ReplicatedTree.this.root, dead);
        }

        public void block() {
            ReplicatedTree.this.setRunning(false);
        }

        public void unblock() {
            ReplicatedTree.this.setRunning(true);
        }
    };

    public ReplicatedTree(Channel channel, ConflictResolver conflictResolver, long getStateTimeout) throws Exception {
        if (!channel.hasProtocol(SEQUENCER.class)) {
            throw new RuntimeException("Channel must have SEQUENCER protocol to ensure total ordering needed for replicated tree");
        }
        this.channel = channel;
        this.conflictResolver = conflictResolver;
        this.getStateTimeout = getStateTimeout;
        channel.setReceiver(this.myReceiver);
    }

    public ReplicatedTree(JChannel channel, ConflictResolver conflictResolver, long getStateTimeout) throws Exception {
        this(new JChannelAdapter(channel), conflictResolver, getStateTimeout);
    }

    public void start() throws Exception {
        this.channel.getState(null, this.getStateTimeout, true);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void addListener(String node, ReplicatedTreeListener listener) {
        Node n = this.findNode(node);
        if (n == null) {
            this.pendingListeners.put((Object)node, (Object)listener);
        } else {
            n.addListener(listener);
        }
    }

    public void removeListener(String node, ReplicatedTreeListener listener) {
        Node n = this.findNode(node);
        if (n == null) {
            this.pendingListeners.remove((Object)node, (Object)listener);
        } else {
            n.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String fqn, boolean ephemeral) {
        this.awaitRunning();
        try {
            LOG.trace("Creating {} {}", (Object)fqn, (Object)(ephemeral ? "(ephemeral)" : ""));
            this.channel.send(new Message(null, (Object)new Request(1, fqn, ephemeral)));
            Object object = this.updateCondition;
            synchronized (object) {
                while (!this.exists(fqn)) {
                    this.updateCondition.wait();
                }
            }
        }
        catch (Exception ex) {
            LOG.error("failure bcasting PUT request", (Throwable)ex);
        }
    }

    public void set(String fqn, byte[] data) {
        this.awaitRunning();
        try {
            this.channel.send(new Message(null, (Object)new Request(2, fqn, data)));
        }
        catch (Exception ex) {
            LOG.error("failure bcasting PUT request", (Throwable)ex);
        }
    }

    public void remove(String fqn) {
        this.awaitRunning();
        try {
            this.channel.send(new Message(null, (Object)new Request(3, fqn)));
        }
        catch (Exception ex) {
            LOG.error("failure bcasting REMOVE request", (Throwable)ex);
        }
    }

    public void remove(String parentFqn, String childName) {
        this.remove(parentFqn + '/' + childName);
    }

    public void flush() {
        this.awaitRunning();
        try {
            Message msg = new Message(null, new byte[0]);
            msg.setFlag(new Message.Flag[]{Message.RSVP});
            this.channel.send(msg);
        }
        catch (Exception ex) {
            LOG.error("failure bcasting FLUSH request", (Throwable)ex);
        }
    }

    public boolean exists(String fqn) {
        if (fqn == null) {
            return false;
        }
        return this.findNode(fqn) != null;
    }

    public byte[] get(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        byte[] buffer = n.getData();
        if (buffer == null) {
            return null;
        }
        return Arrays.copyOf(buffer, buffer.length);
    }

    public String print(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.toString();
    }

    public List<String> getChildren(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Set<String> names = n.getChildrenNames();
        return new ArrayList<String>(names);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.root.print(sb, 0);
        return sb.toString();
    }

    public String toString(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        n.print(sb, 0);
        return sb.toString();
    }

    private void _create(String fqn, Address ephemeral) {
        if (fqn == null) {
            return;
        }
        LOG.debug("Adding node {}", (Object)fqn);
        this.findNode(fqn, true, ephemeral);
    }

    private void _set(String fqn, byte[] data) {
        if (fqn == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n != null && (n.getData() == null && data != null || !Arrays.equals(n.getData(), data))) {
            LOG.debug("Modifying data for node {}", (Object)fqn);
            n.setData(data);
        } else {
            LOG.warn("Attempted to modify nonexistent node {}", (Object)fqn);
        }
    }

    private void _remove(String fqn) {
        if (fqn == null) {
            return;
        }
        if (fqn.equals(SSEPARATOR)) {
            LOG.info("Clearing tree");
            this.root.removeAll();
            return;
        }
        Node parent = this.findNode(ReplicatedTree.parent(fqn));
        if (parent == null) {
            LOG.warn("Parent {} of node {} not found.", (Object)ReplicatedTree.parent(fqn), (Object)fqn);
            return;
        }
        LOG.debug("Removing node {}", (Object)fqn);
        parent.removeChild(ReplicatedTree.child(fqn));
    }

    private Node findNode(String fqn, boolean create, Address ephemeral) {
        if (fqn == null || fqn.equals(SSEPARATOR) || "".equals(fqn)) {
            return this.root;
        }
        Scanner scanner = new Scanner(fqn).useDelimiter(SSEPARATOR);
        Node curr = this.root;
        while (scanner.hasNext()) {
            String name = scanner.next();
            Node node = curr.getChild(name);
            if (create) {
                if (node == null) {
                    LOG.debug("Creating node {}", (Object)(curr.fqn + (!curr.fqn.equals(SSEPARATOR) ? Character.valueOf('/') : "") + name));
                    node = curr.createChild(name, ephemeral, null, this.pendingListeners);
                } else if (node.getEphemeralAddress() != null) {
                    if (ephemeral == null) {
                        LOG.debug("Making node {} non-ephemeral.", (Object)node.fqn);
                        node.setNotEphemeral();
                    } else if (!ephemeral.equals(node.getEphemeralAddress())) {
                        LOG.info("Node {} ephemeral conflict {} vs {} - making non-ephemeral.", new Object[]{node.fqn, node.getEphemeralAddress(), ephemeral});
                        node.setNotEphemeral();
                    }
                }
            }
            if (node == null) {
                return null;
            }
            curr = node;
        }
        return curr;
    }

    private Node findNode(String fqn) {
        return this.findNode(fqn, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeadEphemerals(Node node, Set<Address> dead) {
        ArrayList<Node> removedChildren = new ArrayList<Node>();
        ArrayList<Node> nonRemovedChildren = new ArrayList<Node>();
        Node node2 = node;
        synchronized (node2) {
            Iterator<Node> it = node.getChildren().values().iterator();
            while (it.hasNext()) {
                Node child = it.next();
                if (child.getEphemeralAddress() != null && dead.contains(child.getEphemeralAddress())) {
                    LOG.debug("Removing ephemeral node {}, owned by dead member {}", (Object)child.fqn, (Object)child.getEphemeralAddress());
                    it.remove();
                    removedChildren.add(child);
                    continue;
                }
                nonRemovedChildren.add(child);
            }
        }
        for (Node child : removedChildren) {
            child.notifyNodeRemoved();
        }
        for (Node child : nonRemovedChildren) {
            this.removeDeadEphemerals(child, dead);
        }
    }

    private void merge(Node node, Node other) {
        assert (node.fqn.equals(other.fqn));
        if (node.data == null && other.getData() != null || node.data != null && !Arrays.equals(node.data, other.getData())) {
            byte[] newData = null;
            if (this.otherAddress == null) {
                newData = other.getData();
            } else {
                LOG.info("Detected conflict for node {}", (Object)node.fqn);
                if (this.conflictResolver != null) {
                    newData = this.conflictResolver.resolve(node.fqn, node.getData(), other.getData(), this.otherAddress);
                }
            }
            if (node.getData() == null && newData != null || !Arrays.equals(node.data, newData)) {
                LOG.debug("Modifying data for node {}", (Object)node.fqn);
                node.setData(newData);
            }
        }
        for (Node otherChild : other.getChildren().values()) {
            Node child = node.getChild(otherChild.name);
            if (child == null) {
                LOG.debug("Adding node {}", (Object)otherChild.name);
                child = node.createChild(otherChild.name, otherChild.getEphemeralAddress(), otherChild.getData(), this.pendingListeners);
            }
            this.merge(child, otherChild);
        }
    }

    public static String parent(String fqn) {
        int index = fqn.lastIndexOf(47);
        if (index < 0) {
            return null;
        }
        return fqn.substring(0, index);
    }

    public static String child(String fqn) {
        int index = fqn.lastIndexOf(47);
        if (index < 0 || index == fqn.length() - 1) {
            return null;
        }
        return fqn.substring(index + 1, fqn.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunning(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.running = value;
            if (this.running) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitRunning() {
        try {
            Object object = this.lock;
            synchronized (object) {
                while (!this.running) {
                    this.lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class Request
    implements Serializable {
        static final byte CREATE = 1;
        static final byte SET = 2;
        static final byte REMOVE = 3;
        final byte type;
        final String fqn;
        final byte[] data;
        final boolean ephemeral;
        private static final long serialVersionUID = 7772753222127676782L;

        private Request(byte type, String fqn) {
            this(type, fqn, false, (byte[])null);
        }

        private Request(byte type, String fqn, boolean ephemeral) {
            this(type, fqn, ephemeral, (byte[])null);
        }

        private Request(byte type, String fqn, byte[] data) {
            this(type, fqn, false, data);
        }

        private Request(byte type, String fqn, boolean ephemeral, byte[] data) {
            this.type = type;
            this.fqn = fqn;
            this.data = data;
            this.ephemeral = ephemeral;
        }

        public String toString() {
            return (this.type == 1 ? "CREATE" : (this.type == 2 ? "SET" : (this.type == 3 ? "REMOVE" : "UNKNOWN"))) + " (" + ", fqn: " + this.fqn + ", value: " + Arrays.toString(this.data) + ')';
        }
    }

    private static class Node
    implements Serializable {
        private static final long serialVersionUID = -3077676554440038890L;
        final String name;
        final String fqn;
        final Node parent;
        private transient Address ephemeral;
        private byte[] data;
        private Map<String, Node> children;
        private volatile transient List<ReplicatedTreeListener> listeners = null;

        Node(String childName, String fqn, Node parent, Address ephemeral, byte[] data) {
            this.name = childName;
            this.fqn = fqn;
            this.parent = parent;
            this.ephemeral = ephemeral;
            this.data = data != null ? Arrays.copyOf(data, data.length) : null;
        }

        Address getEphemeralAddress() {
            return this.ephemeral;
        }

        void setNotEphemeral() {
            this.ephemeral = null;
        }

        synchronized byte[] getData() {
            return this.data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setData(byte[] data) {
            Node node = this;
            synchronized (node) {
                this.data = data != null ? Arrays.copyOf(data, data.length) : null;
            }
            this.notifyNodeModified();
        }

        synchronized Map<String, Node> getChildren() {
            return this.children != null ? this.children : Collections.EMPTY_MAP;
        }

        synchronized Set<String> getChildrenNames() {
            return this.children != null ? Collections.unmodifiableSet(this.children.keySet()) : Collections.EMPTY_SET;
        }

        synchronized Node getChild(String childName) {
            return childName == null ? null : (this.children == null ? null : this.children.get(childName));
        }

        synchronized boolean hasChild(String childName) {
            return childName != null && this.children != null && this.children.containsKey(childName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Node addChild(Node child) {
            Node node = this;
            synchronized (node) {
                assert (this.children == null || !this.children.containsKey(child.name));
                assert (this.fqn.equals(ReplicatedTree.parent(child.fqn)) || this.fqn.equals("/") && ReplicatedTree.parent(child.fqn).equals(""));
                if (this.children == null) {
                    this.children = new LinkedHashMap<String, Node>();
                }
                this.children.put(child.name, child);
            }
            child.notifyNodeAdded();
            return child;
        }

        Node createChild(String childName, Address ephemeral, byte[] data, Multimap<String, ReplicatedTreeListener> pendingListeners) {
            if (childName == null) {
                return null;
            }
            Node child = new Node(childName, (!this.fqn.equals(SSEPARATOR) ? this.fqn : "") + '/' + childName, this, ephemeral, data);
            for (ReplicatedTreeListener listener : pendingListeners.removeAll((Object)child.fqn)) {
                child.addListener(listener);
            }
            this.addChild(child);
            return child;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeChild(String childName) {
            Node child = null;
            Node node = this;
            synchronized (node) {
                if (childName != null && this.children != null) {
                    child = this.children.remove(childName);
                }
            }
            if (child != null) {
                child.notifyNodeRemoved();
            }
        }

        synchronized void removeAll() {
            this.children = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(ReplicatedTreeListener listener) {
            Node node = this;
            synchronized (node) {
                if (this.listeners == null) {
                    this.listeners = new CopyOnWriteArrayList<ReplicatedTreeListener>();
                }
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(ReplicatedTreeListener listener) {
            Node node = this;
            synchronized (node) {
                if (this.listeners == null) {
                    return;
                }
            }
            this.listeners.remove(listener);
        }

        void notifyNodeAdded() {
            List<ReplicatedTreeListener> _listeners = this.listeners;
            if (_listeners != null) {
                for (ReplicatedTreeListener listener : _listeners) {
                    try {
                        listener.nodeAdded(this.fqn);
                    }
                    catch (Exception e) {
                        LOG.error("Listener threw an exception.", (Throwable)e);
                    }
                }
            }
            if (this.parent != null) {
                _listeners = this.parent.listeners;
            }
            if (_listeners != null) {
                for (ReplicatedTreeListener listener : _listeners) {
                    try {
                        listener.nodeChildAdded(this.parent.fqn, this.name);
                    }
                    catch (Exception e) {
                        LOG.error("Listener threw an exception.", (Throwable)e);
                    }
                }
            }
        }

        void notifyNodeRemoved() {
            this.notifyNodeRemoved1();
            List<ReplicatedTreeListener> _listeners = null;
            if (this.parent != null) {
                _listeners = this.parent.listeners;
            }
            if (_listeners != null) {
                for (ReplicatedTreeListener listener : _listeners) {
                    try {
                        listener.nodeChildRemoved(this.parent.fqn, this.name);
                    }
                    catch (Exception e) {
                        LOG.error("Listener threw an exception.", (Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyNodeRemoved1() {
            List<ReplicatedTreeListener> _listeners;
            ArrayList<Node> _children = null;
            Node node = this;
            synchronized (node) {
                if (this.children != null) {
                    _children = new ArrayList<Node>(this.children.values());
                }
            }
            if (_children != null) {
                for (Node child : _children) {
                    child.notifyNodeRemoved1();
                }
            }
            if ((_listeners = this.listeners) != null) {
                for (ReplicatedTreeListener listener : _listeners) {
                    try {
                        listener.nodeRemoved(this.fqn);
                    }
                    catch (Exception e) {
                        LOG.error("Listener threw an exception.", (Throwable)e);
                    }
                }
            }
        }

        void notifyNodeModified() {
            List<ReplicatedTreeListener> _listeners = this.listeners;
            if (_listeners != null) {
                for (ReplicatedTreeListener listener : this.listeners) {
                    try {
                        listener.nodeUpdated(this.fqn);
                    }
                    catch (Exception e) {
                        LOG.error("Listener threw an exception.", (Throwable)e);
                    }
                }
            }
            if (this.parent != null) {
                _listeners = this.parent.listeners;
            }
            if (_listeners != null) {
                for (ReplicatedTreeListener listener : _listeners) {
                    try {
                        listener.nodeChildUpdated(this.parent.fqn, this.name);
                    }
                    catch (Exception e) {
                        LOG.error("Listener threw an exception.", (Throwable)e);
                    }
                }
            }
        }

        synchronized StringBuilder print(StringBuilder sb, int indent) {
            for (int i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            sb.append('/').append(this.name);
            if (this.children != null) {
                for (Node n : this.children.values()) {
                    sb.append('\n');
                    n.print(sb, indent + 4);
                }
            }
            return sb;
        }

        public synchronized String toString() {
            return "Node{name: " + this.name + ", fqn: " + this.fqn + ", data: " + Arrays.toString(this.data) + '}';
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            try {
                s.defaultWriteObject();
                s.writeBoolean(this.ephemeral != null);
                if (this.ephemeral != null) {
                    Util.writeAddress((Address)this.ephemeral, (DataOutput)s);
                }
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            try {
                s.defaultReadObject();
                boolean hasAddress = s.readBoolean();
                if (hasAddress) {
                    this.ephemeral = Util.readAddress((DataInput)s);
                }
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    public static interface ConflictResolver {
        public byte[] resolve(String var1, byte[] var2, byte[] var3, Address var4);
    }

    public static interface ReplicatedTreeListener {
        public void nodeAdded(String var1);

        public void nodeRemoved(String var1);

        public void nodeUpdated(String var1);

        public void nodeChildAdded(String var1, String var2);

        public void nodeChildRemoved(String var1, String var2);

        public void nodeChildUpdated(String var1, String var2);
    }
}

