/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeInfo;
import co.paralleluniverse.galaxy.netty.ChannelNodeInfo;
import com.google.common.base.Charsets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class ChannelNodeNameReader
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelNodeNameReader.class);
    private final Cluster cluster;
    private volatile ChannelStateEvent connectEvent;
    private volatile String nodeName;
    private volatile NodeInfo node;

    public ChannelNodeNameReader(Cluster cluster) {
        this.cluster = cluster;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer message = (ChannelBuffer)e.getMessage();
        int size = message.readableBytes();
        byte[] array = new byte[size];
        message.readBytes(array);
        this.nodeName = new String(array, Charsets.UTF_8);
        LOG.info("Channel {} is node {}.", (Object)ctx.getChannel(), (Object)this.nodeName);
        this.node = this.cluster.getNodeInfoByName(this.nodeName);
        if (this.node == null) {
            LOG.error("Node info for {} not found!", (Object)ctx.getChannel(), (Object)this.nodeName);
            throw new RuntimeException("No node info for channel");
        }
        SocketAddress address = ctx.getChannel().getRemoteAddress();
        InetAddress host = ((InetSocketAddress)address).getAddress();
        if (!host.equals((InetAddress)this.node.get("ip_addr"))) {
            LOG.error("Channel coming from {} claims to be node {} - host address mismatch!", (Object)address, (Object)this.node);
            throw new RuntimeException("Node identity problem!");
        }
        LOG.info("Channel {} is {}.", (Object)ctx.getChannel(), (Object)this.node);
        ChannelNodeInfo.nodeInfo.set(ctx.getChannel(), (Object)this.node);
        assert (this.connectEvent != null);
        ctx.sendUpstream((ChannelEvent)this.connectEvent);
        ctx.getPipeline().remove((ChannelHandler)this);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.connectEvent = e;
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.node = null;
        super.channelClosed(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.node = null;
        super.channelDisconnected(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.node = null;
        super.exceptionCaught(ctx, e);
    }
}

