/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.Cluster;
import com.google.common.base.Charsets;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class ChannelNodeNameWriter
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelNodeNameWriter.class);
    private final Cluster cluster;

    public ChannelNodeNameWriter(Cluster cluster) {
        this.cluster = cluster;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = ctx.getChannel();
        String name = this.cluster.getMyNodeInfo().getName();
        LOG.debug("Writing node name, {}, to channel.", (Object)name);
        byte[] array = name.getBytes(Charsets.UTF_8);
        ChannelBuffer message = ChannelBuffers.wrappedBuffer((byte[])array);
        ctx.sendDownstream((ChannelEvent)new DownstreamMessageEvent(channel, (ChannelFuture)new DefaultChannelFuture(channel, false), (Object)message, null));
        super.channelConnected(ctx, e);
        ctx.getPipeline().remove((ChannelHandler)this);
    }
}

